/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.concurrent.TimeUnit;
import org.junit.Rule;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ITextTest {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Rule
    public Timeout testTimeout = this.getTestTimeout();

    public static void createDestinationFolder(String path) {
        File fpath = new File(path);
        fpath.mkdirs();
    }

    public static void createOrClearDestinationFolder(String path) {
        File fpath = new File(path);
        fpath.mkdirs();
        ITextTest.deleteDirectoryContents(path, false);
    }

    public static void deleteDirectory(String path) {
        ITextTest.deleteDirectoryContents(path, true);
    }

    public static void removeCryptographyRestrictions() {
        try {
            Field field = Class.forName("javax.crypto.JceSecurity").getDeclaredField("isRestricted");
            if (field.isAccessible()) {
                return;
            }
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            modifiersField.setAccessible(false);
            field.setAccessible(true);
            if (field.getBoolean(null)) {
                field.set(null, Boolean.FALSE);
            } else {
                field.setAccessible(false);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void restoreCryptographyRestrictions() {
        try {
            Field field = Class.forName("javax.crypto.JceSecurity").getDeclaredField("isRestricted");
            if (field.isAccessible()) {
                field.set(null, Boolean.TRUE);
                field.setAccessible(false);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected Timeout getTestTimeout() {
        return new Timeout(5L, TimeUnit.MINUTES);
    }

    protected byte[] readFile(String filename) throws IOException {
        int read;
        FileInputStream input = new FileInputStream(filename);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((read = input.read(buffer)) != -1) {
            output.write(buffer, 0, read);
        }
        input.close();
        return output.toByteArray();
    }

    protected String createStringByEscaped(byte[] bytes) {
        String[] chars = new String(bytes).substring(1).split("#");
        StringBuilder buf = new StringBuilder(chars.length);
        for (String ch : chars) {
            if (ch.length() == 0) continue;
            Integer b = Integer.parseInt(ch, 16);
            buf.append((char)b.intValue());
        }
        return buf.toString();
    }

    private static void deleteDirectoryContents(String path, boolean removeParentDirectory) {
        File file = new File(path);
        if (file.exists() && file.listFiles() != null) {
            for (File f : file.listFiles()) {
                if (f.isDirectory()) {
                    ITextTest.deleteDirectoryContents(f.getPath(), false);
                    f.delete();
                    continue;
                }
                f.delete();
            }
            if (removeParentDirectory) {
                file.delete();
            }
        }
    }
}

