/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers.utils.ua2;

import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.pdfua.exceptions.PdfUAConformanceException;

public final class PdfUA2StringChecker {
    private PdfUA2StringChecker() {
    }

    public static void checkPdfString(PdfString string) {
        if (("PDF".equals(string.getEncoding()) || "UTF-8".equals(string.getEncoding()) || "UnicodeBig".equals(string.getEncoding())) && PdfUA2StringChecker.stringContainsPua(string.getValue())) {
            throw new PdfUAConformanceException("Text strings intended to be human readable shall not use the Unicode PUA.");
        }
    }

    static boolean stringContainsPua(String string) {
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                boolean isSupplementaryPrivateAreaB;
                int code = string.codePointAt(i);
                boolean isPrivateArea = code >= 57344 && code <= 63743;
                boolean isSupplementaryPrivateAreaA = code >= 983040 && code <= 1048573;
                boolean bl = isSupplementaryPrivateAreaB = code >= 0x100000 && code <= 1114109;
                if (!isPrivateArea && !isSupplementaryPrivateAreaA && !isSupplementaryPrivateAreaB) continue;
                return true;
            }
        }
        return false;
    }
}

