/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDate;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.signatures.PdfSignatureBuildProperties;

public class PdfSignature
extends PdfObjectWrapper<PdfDictionary> {
    public PdfSignature() {
        super((PdfObject)new PdfDictionary());
        this.put(PdfName.Type, (PdfObject)PdfName.Sig);
    }

    public PdfSignature(PdfName filter, PdfName subFilter) {
        this();
        this.put(PdfName.Filter, (PdfObject)filter);
        this.put(PdfName.SubFilter, (PdfObject)subFilter);
    }

    public void setByteRange(int[] range) {
        PdfArray array = new PdfArray();
        for (int k = 0; k < range.length; ++k) {
            array.add((PdfObject)new PdfNumber(range[k]));
        }
        this.put(PdfName.ByteRange, (PdfObject)array);
    }

    public void setContents(byte[] contents) {
        this.put(PdfName.Contents, (PdfObject)new PdfString(contents).setHexWriting(true));
    }

    public void setCert(byte[] cert) {
        this.put(PdfName.Cert, (PdfObject)new PdfString(cert));
    }

    public void setName(String name) {
        this.put(PdfName.Name, (PdfObject)new PdfString(name, "UnicodeBig"));
    }

    public void setDate(PdfDate date) {
        this.put(PdfName.M, date.getPdfObject());
    }

    public void setLocation(String location) {
        this.put(PdfName.Location, (PdfObject)new PdfString(location, "UnicodeBig"));
    }

    public void setReason(String reason) {
        this.put(PdfName.Reason, (PdfObject)new PdfString(reason, "UnicodeBig"));
    }

    public void setSignatureCreator(String signatureCreator) {
        if (signatureCreator != null) {
            this.getPdfSignatureBuildProperties().setSignatureCreator(signatureCreator);
        }
    }

    public void setContact(String contactInfo) {
        this.put(PdfName.ContactInfo, (PdfObject)new PdfString(contactInfo, "UnicodeBig"));
    }

    public PdfSignature put(PdfName key, PdfObject value) {
        ((PdfDictionary)this.getPdfObject()).put(key, value);
        return this;
    }

    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    private PdfSignatureBuildProperties getPdfSignatureBuildProperties() {
        PdfDictionary buildPropDict = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.Prop_Build);
        if (buildPropDict == null) {
            buildPropDict = new PdfDictionary();
            this.put(PdfName.Prop_Build, (PdfObject)buildPropDict);
        }
        return new PdfSignatureBuildProperties(buildPropDict);
    }
}

