/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.cert.ocsp.AbstractOCSPException;
import com.itextpdf.commons.bouncycastle.cert.ocsp.IBasicOCSPResp;
import com.itextpdf.commons.bouncycastle.cert.ocsp.ICertificateStatus;
import com.itextpdf.commons.bouncycastle.cert.ocsp.ISingleResp;
import com.itextpdf.commons.bouncycastle.operator.AbstractOperatorCreationException;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.signatures.CRLVerifier;
import com.itextpdf.signatures.CertificateUtil;
import com.itextpdf.signatures.CertificateVerifier;
import com.itextpdf.signatures.OcspClientBouncyCastle;
import com.itextpdf.signatures.RootStoreVerifier;
import com.itextpdf.signatures.SignUtils;
import com.itextpdf.signatures.VerificationException;
import com.itextpdf.signatures.VerificationOK;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPVerifier
extends RootStoreVerifier {
    private static final IBouncyCastleFactory BOUNCY_CASTLE_FACTORY = BouncyCastleFactoryCreator.getFactory();
    protected static final Logger LOGGER = LoggerFactory.getLogger(OCSPVerifier.class);
    protected static final String id_kp_OCSPSigning = "1.3.6.1.5.5.7.3.9";
    protected List<IBasicOCSPResp> ocsps;

    public OCSPVerifier(CertificateVerifier verifier, List<IBasicOCSPResp> ocsps) {
        super(verifier);
        this.ocsps = ocsps;
    }

    @Override
    public List<VerificationOK> verify(X509Certificate signCert, X509Certificate issuerCert, Date signDate) throws GeneralSecurityException {
        ArrayList<VerificationOK> result = new ArrayList<VerificationOK>();
        int validOCSPsFound = 0;
        if (this.ocsps != null) {
            for (IBasicOCSPResp ocspResp : this.ocsps) {
                if (!this.verify(ocspResp, signCert, issuerCert, signDate)) continue;
                ++validOCSPsFound;
            }
        }
        boolean online = false;
        if (this.onlineCheckingAllowed && validOCSPsFound == 0 && this.verify(this.getOcspResponse(signCert, issuerCert), signCert, issuerCert, signDate)) {
            ++validOCSPsFound;
            online = true;
        }
        LOGGER.info("Valid OCSPs found: " + validOCSPsFound);
        if (validOCSPsFound > 0) {
            result.add(new VerificationOK(signCert, this.getClass(), "Valid OCSPs Found: " + validOCSPsFound + (online ? " (online)" : "")));
        }
        if (this.verifier != null) {
            result.addAll(this.verifier.verify(signCert, issuerCert, signDate));
        }
        return result;
    }

    public boolean verify(IBasicOCSPResp ocspResp, X509Certificate signCert, X509Certificate issuerCert, Date signDate) throws GeneralSecurityException {
        ISingleResp[] resp;
        if (ocspResp == null) {
            return false;
        }
        for (ISingleResp iSingleResp : resp = ocspResp.getResponses()) {
            ICertificateStatus status;
            if (!signCert.getSerialNumber().equals(iSingleResp.getCertID().getSerialNumber())) continue;
            try {
                if (issuerCert == null) {
                    issuerCert = signCert;
                }
                if (!SignUtils.checkIfIssuersMatch(iSingleResp.getCertID(), issuerCert)) {
                    LOGGER.info("OCSP: Issuers doesn't match.");
                    continue;
                }
            }
            catch (IOException e) {
                throw new GeneralSecurityException(e.getMessage());
            }
            catch (AbstractOCSPException | AbstractOperatorCreationException e) {
                continue;
            }
            if (iSingleResp.getNextUpdate() == null) {
                Date nextUpdate = SignUtils.add180Sec(iSingleResp.getThisUpdate());
                LOGGER.info(MessageFormatUtil.format((String)"No 'next update' for OCSP Response; assuming {0}", (Object[])new Object[]{nextUpdate}));
                if (signDate.after(nextUpdate)) {
                    LOGGER.info(MessageFormatUtil.format((String)"OCSP no longer valid: {0} after {1}", (Object[])new Object[]{signDate, nextUpdate}));
                    continue;
                }
            } else if (signDate.after(iSingleResp.getNextUpdate())) {
                LOGGER.info(MessageFormatUtil.format((String)"OCSP no longer valid: {0} after {1}", (Object[])new Object[]{signDate, iSingleResp.getNextUpdate()}));
                continue;
            }
            if (!Objects.equals(status = iSingleResp.getCertStatus(), BOUNCY_CASTLE_FACTORY.createCertificateStatus().getGood())) continue;
            this.isValidResponse(ocspResp, issuerCert, signDate);
            return true;
        }
        return false;
    }

    public void isValidResponse(IBasicOCSPResp ocspResp, X509Certificate issuerCert, Date signDate) throws GeneralSecurityException {
        X509Certificate responderCert = null;
        if (this.isSignatureValid(ocspResp, issuerCert)) {
            responderCert = issuerCert;
        }
        if (responderCert == null) {
            if (ocspResp.getCerts() != null) {
                Iterable<X509Certificate> certs = SignUtils.getCertsFromOcspResponse(ocspResp);
                for (X509Certificate cert : certs) {
                    List<String> keyPurposes = null;
                    try {
                        keyPurposes = cert.getExtendedKeyUsage();
                        if (keyPurposes == null || !keyPurposes.contains(id_kp_OCSPSigning) || !this.isSignatureValid(ocspResp, cert)) continue;
                        responderCert = cert;
                        break;
                    }
                    catch (CertificateParsingException certificateParsingException) {
                    }
                }
                if (responderCert == null) {
                    throw new VerificationException(issuerCert, "OCSP response could not be verified");
                }
                responderCert.verify(issuerCert.getPublicKey());
                responderCert.checkValidity(signDate);
                if (SignUtils.getExtensionValueByOid(responderCert, BOUNCY_CASTLE_FACTORY.createOCSPObjectIdentifiers().getIdPkixOcspNoCheck().getId()) == null) {
                    CRL crl;
                    try {
                        crl = CertificateUtil.getCRL(responderCert);
                    }
                    catch (Exception ignored) {
                        crl = null;
                    }
                    if (crl != null && crl instanceof X509CRL) {
                        CRLVerifier crlVerifier = new CRLVerifier(null, null);
                        crlVerifier.setRootStore(this.rootStore);
                        crlVerifier.setOnlineCheckingAllowed(this.onlineCheckingAllowed);
                        if (!crlVerifier.verify((X509CRL)crl, responderCert, issuerCert, signDate)) {
                            throw new VerificationException(issuerCert, "Authorized OCSP responder certificate was revoked.");
                        }
                    } else {
                        LOGGER.error("Authorized OCSP responder certificate revocation status cannot be checked");
                    }
                }
            } else {
                if (this.rootStore != null) {
                    try {
                        for (X509Certificate anchor : SignUtils.getCertificates(this.rootStore)) {
                            if (!this.isSignatureValid(ocspResp, anchor)) continue;
                            responderCert = anchor;
                            break;
                        }
                    }
                    catch (Exception e) {
                        responderCert = null;
                    }
                }
                if (responderCert == null) {
                    throw new VerificationException(issuerCert, "OCSP response could not be verified: it does not contain certificate chain and response is not signed by issuer certificate or any from the root store.");
                }
            }
        }
    }

    public boolean isSignatureValid(IBasicOCSPResp ocspResp, Certificate responderCert) {
        try {
            return SignUtils.isSignatureValid(ocspResp, responderCert, BOUNCY_CASTLE_FACTORY.getProviderName());
        }
        catch (Exception e) {
            return false;
        }
    }

    public IBasicOCSPResp getOcspResponse(X509Certificate signCert, X509Certificate issuerCert) {
        ISingleResp[] resps;
        if (signCert == null && issuerCert == null) {
            return null;
        }
        OcspClientBouncyCastle ocsp = new OcspClientBouncyCastle(null);
        IBasicOCSPResp ocspResp = ocsp.getBasicOCSPResp(signCert, issuerCert, null);
        if (ocspResp == null) {
            return null;
        }
        for (ISingleResp resp : resps = ocspResp.getResponses()) {
            ICertificateStatus status = resp.getCertStatus();
            if (!Objects.equals(status, BOUNCY_CASTLE_FACTORY.createCertificateStatus().getGood())) continue;
            return ocspResp;
        }
        return null;
    }
}

