/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.asn1.esf.ISignaturePolicyIdentifier;
import com.itextpdf.commons.utils.DateTimeUtil;
import com.itextpdf.commons.utils.FileUtil;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.forms.PdfSigFieldLock;
import com.itextpdf.forms.fields.PdfFormAnnotation;
import com.itextpdf.forms.fields.PdfFormCreator;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.forms.fields.PdfSignatureFormField;
import com.itextpdf.forms.fields.SignatureFormFieldBuilder;
import com.itextpdf.forms.form.element.IFormField;
import com.itextpdf.forms.form.element.SignatureFieldAppearance;
import com.itextpdf.forms.util.BorderStyleUtil;
import com.itextpdf.io.source.ByteBuffer;
import com.itextpdf.io.source.IRandomAccessSource;
import com.itextpdf.io.source.RASInputStream;
import com.itextpdf.io.source.RandomAccessSourceFactory;
import com.itextpdf.io.util.StreamUtil;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.IsoKey;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDate;
import com.itextpdf.kernel.pdf.PdfDeveloperExtension;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfLiteral;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfOutputStream;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.PdfVersion;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.StampingProperties;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfWidgetAnnotation;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.properties.Background;
import com.itextpdf.layout.properties.TextAlignment;
import com.itextpdf.layout.properties.TransparentColor;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.pdfa.PdfAAgnosticPdfDocument;
import com.itextpdf.signatures.BouncyCastleDigest;
import com.itextpdf.signatures.DigestAlgorithms;
import com.itextpdf.signatures.ICrlClient;
import com.itextpdf.signatures.IExternalDigest;
import com.itextpdf.signatures.IExternalSignature;
import com.itextpdf.signatures.IExternalSignatureContainer;
import com.itextpdf.signatures.IOcspClient;
import com.itextpdf.signatures.ITSAClient;
import com.itextpdf.signatures.OcspClientBouncyCastle;
import com.itextpdf.signatures.PdfPKCS7;
import com.itextpdf.signatures.PdfSignature;
import com.itextpdf.signatures.PdfSignatureAppearance;
import com.itextpdf.signatures.SignaturePolicyInfo;
import com.itextpdf.signatures.SignatureUtil;
import com.itextpdf.signatures.SignerProperties;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PdfSigner {
    public static final int NOT_CERTIFIED = 0;
    public static final int CERTIFIED_NO_CHANGES_ALLOWED = 1;
    public static final int CERTIFIED_FORM_FILLING = 2;
    public static final int CERTIFIED_FORM_FILLING_AND_ANNOTATIONS = 3;
    protected int certificationLevel = 0;
    protected String fieldName;
    protected RandomAccessFile raf;
    protected byte[] bout;
    protected long[] range;
    protected PdfDocument document;
    protected PdfSignature cryptoDictionary;
    protected ISignatureEvent signatureEvent;
    protected OutputStream originalOS;
    protected ByteArrayOutputStream temporaryOS;
    protected File tempFile;
    protected Map<PdfName, PdfLiteral> exclusionLocations;
    protected boolean preClosed = false;
    protected PdfSigFieldLock fieldLock;
    protected PdfSignatureAppearance appearance;
    protected Calendar signDate = DateTimeUtil.getCurrentTimeCalendar();
    protected boolean closed = false;
    private final PdfAcroForm acroForm;

    public PdfSigner(PdfReader reader, OutputStream outputStream, StampingProperties properties) throws IOException {
        this(reader, outputStream, null, properties);
    }

    public PdfSigner(PdfReader reader, OutputStream outputStream, String path, StampingProperties stampingProperties, SignerProperties signerProperties) throws IOException {
        this(reader, outputStream, path, stampingProperties);
        this.fieldLock = signerProperties.getFieldLockDict();
        this.updateFieldName(signerProperties.getFieldName());
        signerProperties.setFieldName(this.fieldName);
        this.certificationLevel = signerProperties.getCertificationLevel();
        this.appearance.setPageRect(signerProperties.getPageRect());
        this.appearance.setPageNumber(signerProperties.getPageNumber());
        this.appearance.setSignDate(signerProperties.getSignDate());
        this.appearance.setSignatureCreator(signerProperties.getSignatureCreator());
        this.appearance.setContact(signerProperties.getContact());
        this.appearance.setReason(signerProperties.getReason());
        this.appearance.setLocation(signerProperties.getLocation());
        this.appearance.setSignatureAppearance(signerProperties.getSignatureAppearance());
    }

    public PdfSigner(PdfReader reader, OutputStream outputStream, String path, StampingProperties properties) throws IOException {
        StampingProperties localProps = new StampingProperties(properties).preserveEncryption();
        if (path == null) {
            this.temporaryOS = new ByteArrayOutputStream();
            this.document = this.initDocument(reader, new PdfWriter((OutputStream)this.temporaryOS), localProps);
        } else {
            this.tempFile = FileUtil.createTempFile((String)path);
            this.document = this.initDocument(reader, new PdfWriter((OutputStream)FileUtil.getFileOutputStream((File)this.tempFile)), localProps);
        }
        this.acroForm = PdfFormCreator.getAcroForm((PdfDocument)this.document, (boolean)true);
        this.originalOS = outputStream;
        this.fieldName = this.getNewSigFieldName();
        this.appearance = new PdfSignatureAppearance(this.document, new Rectangle(0.0f, 0.0f), 1);
        this.appearance.setSignDate(this.signDate);
    }

    PdfSigner(PdfDocument document, OutputStream outputStream, ByteArrayOutputStream temporaryOS, File tempFile) {
        if (tempFile == null) {
            this.temporaryOS = temporaryOS;
        } else {
            this.tempFile = tempFile;
        }
        this.document = document;
        this.acroForm = PdfFormCreator.getAcroForm((PdfDocument)document, (boolean)true);
        this.originalOS = outputStream;
        this.fieldName = this.getNewSigFieldName();
        this.appearance = new PdfSignatureAppearance(document, new Rectangle(0.0f, 0.0f), 1);
        this.appearance.setSignDate(this.signDate);
    }

    protected PdfDocument initDocument(PdfReader reader, PdfWriter writer, StampingProperties properties) {
        return new PdfAAgnosticPdfDocument(reader, writer, properties);
    }

    public Calendar getSignDate() {
        return this.signDate;
    }

    public void setSignDate(Calendar signDate) {
        this.signDate = signDate;
        this.appearance.setSignDate(signDate);
    }

    @Deprecated
    public PdfSignatureAppearance getSignatureAppearance() {
        return this.appearance;
    }

    public void setSignatureAppearance(SignatureFieldAppearance appearance) {
        this.appearance.setSignatureAppearance(appearance);
    }

    public int getCertificationLevel() {
        return this.certificationLevel;
    }

    public void setCertificationLevel(int certificationLevel) {
        this.certificationLevel = certificationLevel;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public PdfSignature getSignatureDictionary() {
        return this.cryptoDictionary;
    }

    public ISignatureEvent getSignatureEvent() {
        return this.signatureEvent;
    }

    public void setSignatureEvent(ISignatureEvent signatureEvent) {
        this.signatureEvent = signatureEvent;
    }

    public String getNewSigFieldName() {
        String name = "Signature";
        int step = 1;
        while (this.acroForm.getField(name + step) != null) {
            ++step;
        }
        return name + step;
    }

    public void setFieldName(String fieldName) {
        this.updateFieldName(fieldName);
    }

    public PdfDocument getDocument() {
        return this.document;
    }

    protected void setDocument(PdfDocument document) {
        if (null == document.getReader()) {
            throw new IllegalArgumentException("Document must have reader.");
        }
        this.document = document;
    }

    public int getPageNumber() {
        return this.appearance.getPageNumber();
    }

    public PdfSigner setPageNumber(int pageNumber) {
        this.appearance.setPageNumber(pageNumber);
        return this;
    }

    public Rectangle getPageRect() {
        return this.appearance.getPageRect();
    }

    public PdfSigner setPageRect(Rectangle pageRect) {
        this.appearance.setPageRect(pageRect);
        return this;
    }

    public void setOriginalOutputStream(OutputStream originalOS) {
        this.originalOS = originalOS;
    }

    public PdfSigFieldLock getFieldLockDict() {
        return this.fieldLock;
    }

    public void setFieldLockDict(PdfSigFieldLock fieldLock) {
        this.fieldLock = fieldLock;
    }

    public String getSignatureCreator() {
        return this.appearance.getSignatureCreator();
    }

    public PdfSigner setSignatureCreator(String signatureCreator) {
        this.appearance.setSignatureCreator(signatureCreator);
        return this;
    }

    public String getContact() {
        return this.appearance.getContact();
    }

    public PdfSigner setContact(String contact) {
        this.appearance.setContact(contact);
        return this;
    }

    public String getReason() {
        return this.appearance.getReason();
    }

    public PdfSigner setReason(String reason) {
        this.appearance.setReason(reason);
        return this;
    }

    public String getLocation() {
        return this.appearance.getLocation();
    }

    public PdfSigner setLocation(String location) {
        this.appearance.setLocation(location);
        return this;
    }

    public PdfSignatureFormField getSignatureField() {
        PdfFormField field = this.acroForm.getField(this.fieldName);
        if (field == null) {
            PdfSignatureFormField sigField = ((SignatureFormFieldBuilder)new SignatureFormFieldBuilder(this.document, this.fieldName).setWidgetRectangle(this.getPageRect())).createSignature();
            this.acroForm.addField((PdfFormField)sigField);
            return sigField;
        }
        if (field instanceof PdfSignatureFormField) {
            return (PdfSignatureFormField)field;
        }
        return null;
    }

    public void signDetached(IExternalDigest externalDigest, IExternalSignature externalSignature, Certificate[] chain, Collection<ICrlClient> crlList, IOcspClient ocspClient, ITSAClient tsaClient, int estimatedSize, CryptoStandard sigtype) throws IOException, GeneralSecurityException {
        this.signDetached(externalDigest, externalSignature, chain, crlList, ocspClient, tsaClient, estimatedSize, sigtype, (ISignaturePolicyIdentifier)null);
    }

    public void signDetached(IExternalSignature externalSignature, Certificate[] chain, Collection<ICrlClient> crlList, IOcspClient ocspClient, ITSAClient tsaClient, int estimatedSize, CryptoStandard sigtype) throws IOException, GeneralSecurityException {
        this.signDetached((IExternalDigest)new BouncyCastleDigest(), externalSignature, chain, crlList, ocspClient, tsaClient, estimatedSize, sigtype, (ISignaturePolicyIdentifier)null);
    }

    public void signDetached(IExternalDigest externalDigest, IExternalSignature externalSignature, Certificate[] chain, Collection<ICrlClient> crlList, IOcspClient ocspClient, ITSAClient tsaClient, int estimatedSize, CryptoStandard sigtype, SignaturePolicyInfo signaturePolicy) throws IOException, GeneralSecurityException {
        this.signDetached(externalDigest, externalSignature, chain, crlList, ocspClient, tsaClient, estimatedSize, sigtype, signaturePolicy.toSignaturePolicyIdentifier());
    }

    public void signDetached(IExternalSignature externalSignature, Certificate[] chain, Collection<ICrlClient> crlList, IOcspClient ocspClient, ITSAClient tsaClient, int estimatedSize, CryptoStandard sigtype, SignaturePolicyInfo signaturePolicy) throws IOException, GeneralSecurityException {
        this.signDetached((IExternalDigest)new BouncyCastleDigest(), externalSignature, chain, crlList, ocspClient, tsaClient, estimatedSize, sigtype, signaturePolicy);
    }

    public void signDetached(IExternalSignature externalSignature, Certificate[] chain, Collection<ICrlClient> crlList, IOcspClient ocspClient, ITSAClient tsaClient, int estimatedSize, CryptoStandard sigtype, ISignaturePolicyIdentifier signaturePolicy) throws IOException, GeneralSecurityException {
        this.signDetached((IExternalDigest)new BouncyCastleDigest(), externalSignature, chain, crlList, ocspClient, tsaClient, estimatedSize, sigtype, signaturePolicy);
    }

    public void signDetached(IExternalDigest externalDigest, IExternalSignature externalSignature, Certificate[] chain, Collection<ICrlClient> crlList, IOcspClient ocspClient, ITSAClient tsaClient, int estimatedSize, CryptoStandard sigtype, ISignaturePolicyIdentifier signaturePolicy) throws IOException, GeneralSecurityException {
        String hashAlgorithm;
        if (this.closed) {
            throw new PdfException("This instance of PdfSigner has been already closed.");
        }
        if (this.certificationLevel > 0 && this.isDocumentPdf2() && this.documentContainsCertificationOrApprovalSignatures()) {
            throw new PdfException("Certification signature creation failed. Document shall not contain any certification or approval signatures before signing with certification signature.");
        }
        this.document.checkIsoConformance((Object)(sigtype == CryptoStandard.CADES ? 1 : 0), IsoKey.SIGNATURE_TYPE);
        Collection<byte[]> crlBytes = null;
        int i = 0;
        while (crlBytes == null && i < chain.length) {
            crlBytes = this.processCrl(chain[i++], crlList);
        }
        if (estimatedSize == 0) {
            estimatedSize = 8192;
            if (crlBytes != null) {
                for (byte[] element : crlBytes) {
                    estimatedSize += element.length + 10;
                }
            }
            if (ocspClient != null) {
                estimatedSize += 4192;
            }
            if (tsaClient != null) {
                estimatedSize += tsaClient.getTokenSizeEstimate() + 96;
            }
        }
        this.appearance.setCertificate(chain[0]);
        if (sigtype == CryptoStandard.CADES && !this.isDocumentPdf2()) {
            this.addDeveloperExtension(PdfDeveloperExtension.ESIC_1_7_EXTENSIONLEVEL2);
        }
        if (externalSignature.getSignatureAlgorithmName().startsWith("Ed")) {
            this.addDeveloperExtension(PdfDeveloperExtension.ISO_32002);
        }
        if ((hashAlgorithm = externalSignature.getDigestAlgorithmName()).startsWith("SHA3-") || hashAlgorithm.equals("SHAKE256")) {
            this.addDeveloperExtension(PdfDeveloperExtension.ISO_32001);
        }
        PdfSignature dic = new PdfSignature(PdfName.Adobe_PPKLite, sigtype == CryptoStandard.CADES ? PdfName.ETSI_CAdES_DETACHED : PdfName.Adbe_pkcs7_detached);
        dic.setReason(this.getReason());
        dic.setLocation(this.getLocation());
        dic.setSignatureCreator(this.getSignatureCreator());
        dic.setContact(this.getContact());
        dic.setDate(new PdfDate(this.getSignDate()));
        this.cryptoDictionary = dic;
        HashMap<PdfName, Integer> exc = new HashMap<PdfName, Integer>();
        exc.put(PdfName.Contents, estimatedSize * 2 + 2);
        this.preClose(exc);
        PdfPKCS7 sgn = new PdfPKCS7(null, chain, hashAlgorithm, null, externalDigest, false);
        if (signaturePolicy != null) {
            sgn.setSignaturePolicy(signaturePolicy);
        }
        InputStream data = this.getRangeStream();
        byte[] hash = DigestAlgorithms.digest(data, hashAlgorithm, externalDigest);
        ArrayList<byte[]> ocspList = new ArrayList<byte[]>();
        if (chain.length > 1 && ocspClient != null) {
            for (int j = 0; j < chain.length - 1; ++j) {
                byte[] ocsp = ocspClient.getEncoded((X509Certificate)chain[j], (X509Certificate)chain[j + 1], null);
                if (ocsp == null || !BouncyCastleFactoryCreator.getFactory().createCertificateStatus().getGood().equals(OcspClientBouncyCastle.getCertificateStatus(ocsp))) continue;
                ocspList.add(ocsp);
            }
        }
        byte[] sh = sgn.getAuthenticatedAttributeBytes(hash, sigtype, ocspList, crlBytes);
        byte[] extSignature = externalSignature.sign(sh);
        sgn.setExternalSignatureValue(extSignature, null, externalSignature.getSignatureAlgorithmName(), externalSignature.getSignatureMechanismParameters());
        byte[] encodedSig = sgn.getEncodedPKCS7(hash, sigtype, tsaClient, ocspList, crlBytes);
        if (estimatedSize < encodedSig.length) {
            throw new IOException("Not enough space");
        }
        byte[] paddedSig = new byte[estimatedSize];
        System.arraycopy(encodedSig, 0, paddedSig, 0, encodedSig.length);
        PdfDictionary dic2 = new PdfDictionary();
        dic2.put(PdfName.Contents, (PdfObject)new PdfString(paddedSig).setHexWriting(true));
        this.close(dic2);
        this.closed = true;
    }

    public void signExternalContainer(IExternalSignatureContainer externalSignatureContainer, int estimatedSize) throws GeneralSecurityException, IOException {
        if (this.closed) {
            throw new PdfException("This instance of PdfSigner has been already closed.");
        }
        PdfSignature dic = this.createSignatureDictionary(true);
        externalSignatureContainer.modifySigningDictionary((PdfDictionary)dic.getPdfObject());
        this.cryptoDictionary = dic;
        HashMap<PdfName, Integer> exc = new HashMap<PdfName, Integer>();
        exc.put(PdfName.Contents, estimatedSize * 2 + 2);
        this.preClose(exc);
        InputStream data = this.getRangeStream();
        byte[] encodedSig = externalSignatureContainer.sign(data);
        if (estimatedSize < encodedSig.length) {
            throw new IOException("Not enough space.");
        }
        byte[] paddedSig = new byte[estimatedSize];
        System.arraycopy(encodedSig, 0, paddedSig, 0, encodedSig.length);
        PdfDictionary dic2 = new PdfDictionary();
        dic2.put(PdfName.Contents, (PdfObject)new PdfString(paddedSig).setHexWriting(true));
        this.close(dic2);
        this.closed = true;
    }

    public void timestamp(ITSAClient tsa, String signatureName) throws IOException, GeneralSecurityException {
        byte[] tsToken;
        int n;
        if (this.closed) {
            throw new PdfException("This instance of PdfSigner has been already closed.");
        }
        if (tsa == null) {
            throw new PdfException("Provided TSA client is null. TSA client is required for timestamp signing.");
        }
        int contentEstimated = tsa.getTokenSizeEstimate();
        if (!this.isDocumentPdf2()) {
            this.addDeveloperExtension(PdfDeveloperExtension.ESIC_1_7_EXTENSIONLEVEL5);
        }
        this.setFieldName(signatureName);
        PdfSignature dic = new PdfSignature(PdfName.Adobe_PPKLite, PdfName.ETSI_RFC3161);
        dic.put(PdfName.Type, (PdfObject)PdfName.DocTimeStamp);
        this.cryptoDictionary = dic;
        HashMap<PdfName, Integer> exc = new HashMap<PdfName, Integer>();
        exc.put(PdfName.Contents, contentEstimated * 2 + 2);
        this.preClose(exc);
        InputStream data = this.getRangeStream();
        MessageDigest messageDigest = tsa.getMessageDigest();
        byte[] buf = new byte[4096];
        while ((n = data.read(buf)) > 0) {
            messageDigest.update(buf, 0, n);
        }
        byte[] tsImprint = messageDigest.digest();
        try {
            tsToken = tsa.getTimeStampToken(tsImprint);
        }
        catch (Exception e) {
            throw new GeneralSecurityException(e.getMessage(), e);
        }
        if (contentEstimated + 2 < tsToken.length) {
            throw new IOException(MessageFormatUtil.format((String)"Timestamp token estimation size is not large enough to accommodate the entire timestamp token. Timestamp token estimation size is: {0} bytes, however real timestamp token size is: {1} bytes.", (Object[])new Object[]{contentEstimated, tsToken.length}));
        }
        byte[] paddedSig = new byte[contentEstimated];
        System.arraycopy(tsToken, 0, paddedSig, 0, tsToken.length);
        PdfDictionary dic2 = new PdfDictionary();
        dic2.put(PdfName.Contents, (PdfObject)new PdfString(paddedSig).setHexWriting(true));
        this.close(dic2);
        this.closed = true;
    }

    public static void signDeferred(PdfDocument document, String fieldName, OutputStream outs, IExternalSignatureContainer externalSignatureContainer) throws IOException, GeneralSecurityException {
        SignatureApplier applier = new SignatureApplier(document, fieldName, outs);
        applier.apply(a -> externalSignatureContainer.sign(a.getDataToSign()));
    }

    protected Collection<byte[]> processCrl(Certificate cert, Collection<ICrlClient> crlList) throws CertificateEncodingException {
        if (crlList == null) {
            return null;
        }
        ArrayList<byte[]> crlBytes = new ArrayList<byte[]>();
        for (ICrlClient cc : crlList) {
            Collection<byte[]> b;
            if (cc == null || (b = cc.getEncoded((X509Certificate)cert, null)) == null) continue;
            crlBytes.addAll(b);
        }
        return crlBytes.size() == 0 ? null : crlBytes;
    }

    protected void addDeveloperExtension(PdfDeveloperExtension extension) {
        this.document.getCatalog().addDeveloperExtension(extension);
    }

    protected boolean isPreClosed() {
        return this.preClosed;
    }

    protected void preClose(Map<PdfName, Integer> exclusionSizes) throws IOException {
        if (this.preClosed) {
            throw new PdfException("Document has been already pre closed.");
        }
        this.preClosed = true;
        SignatureUtil sgnUtil = new SignatureUtil(this.document);
        String name = this.getFieldName();
        boolean fieldExist = sgnUtil.doesSignatureFieldExist(name);
        this.acroForm.setSignatureFlags(3);
        PdfSigFieldLock fieldLock = null;
        if (this.cryptoDictionary == null) {
            throw new PdfException("No crypto dictionary defined.");
        }
        ((PdfDictionary)this.cryptoDictionary.getPdfObject()).makeIndirect(this.document);
        fieldLock = fieldExist ? this.populateExistingSignatureFormField(this.acroForm) : this.createNewSignatureFormField(this.acroForm, name);
        this.exclusionLocations = new HashMap<PdfName, PdfLiteral>();
        PdfLiteral lit = new PdfLiteral(80);
        this.exclusionLocations.put(PdfName.ByteRange, lit);
        this.cryptoDictionary.put(PdfName.ByteRange, (PdfObject)lit);
        for (Map.Entry<PdfName, Integer> entry : exclusionSizes.entrySet()) {
            PdfName key = entry.getKey();
            lit = new PdfLiteral(entry.getValue().intValue());
            this.exclusionLocations.put(key, lit);
            this.cryptoDictionary.put(key, (PdfObject)lit);
        }
        if (this.certificationLevel > 0) {
            this.addDocMDP(this.cryptoDictionary);
        }
        if (fieldLock != null) {
            this.addFieldMDP(this.cryptoDictionary, fieldLock);
        }
        if (this.signatureEvent != null) {
            this.signatureEvent.getSignatureDictionary(this.cryptoDictionary);
        }
        if (this.certificationLevel > 0) {
            PdfDictionary docmdp = new PdfDictionary();
            docmdp.put(PdfName.DocMDP, this.cryptoDictionary.getPdfObject());
            this.document.getCatalog().put(PdfName.Perms, (PdfObject)docmdp);
            this.document.getCatalog().setModified();
        }
        this.document.checkIsoConformance((Object)this.cryptoDictionary.getPdfObject(), IsoKey.SIGNATURE);
        ((PdfDictionary)this.cryptoDictionary.getPdfObject()).flush(false);
        this.document.close();
        this.range = new long[this.exclusionLocations.size() * 2];
        long byteRangePosition = this.exclusionLocations.get(PdfName.ByteRange).getPosition();
        this.exclusionLocations.remove(PdfName.ByteRange);
        int idx = 1;
        for (PdfLiteral lit1 : this.exclusionLocations.values()) {
            long n = lit1.getPosition();
            this.range[idx++] = n;
            this.range[idx++] = (long)lit1.getBytesCount() + n;
        }
        Arrays.sort(this.range, 1, this.range.length - 1);
        for (int k = 3; k < this.range.length - 2; k += 2) {
            int n = k;
            this.range[n] = this.range[n] - this.range[k - 1];
        }
        if (this.tempFile == null) {
            this.bout = this.temporaryOS.toByteArray();
            this.range[this.range.length - 1] = (long)this.bout.length - this.range[this.range.length - 2];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PdfOutputStream os = new PdfOutputStream((OutputStream)bos);
            os.write(91);
            for (int k = 0; k < this.range.length; ++k) {
                ((PdfOutputStream)os.writeLong(this.range[k])).write(32);
            }
            os.write(93);
            System.arraycopy(bos.toByteArray(), 0, this.bout, (int)byteRangePosition, bos.size());
        } else {
            try {
                this.raf = FileUtil.getRandomAccessFile((File)this.tempFile);
                long len = this.raf.length();
                this.range[this.range.length - 1] = len - this.range[this.range.length - 2];
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                PdfOutputStream os = new PdfOutputStream((OutputStream)bos);
                os.write(91);
                for (int k = 0; k < this.range.length; ++k) {
                    ((PdfOutputStream)os.writeLong(this.range[k])).write(32);
                }
                os.write(93);
                this.raf.seek(byteRangePosition);
                this.raf.write(bos.toByteArray(), 0, bos.size());
            }
            catch (IOException e) {
                try {
                    this.raf.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.tempFile.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
        }
    }

    protected PdfSigFieldLock populateExistingSignatureFormField(PdfAcroForm acroForm) throws IOException {
        PdfSignatureFormField sigField = (PdfSignatureFormField)acroForm.getField(this.fieldName);
        PdfSigFieldLock sigFieldLock = sigField.getSigFieldLockDictionary();
        if (sigFieldLock == null && this.fieldLock != null) {
            ((PdfDictionary)this.fieldLock.getPdfObject()).makeIndirect(this.document);
            sigField.put(PdfName.Lock, this.fieldLock.getPdfObject());
            sigFieldLock = this.fieldLock;
        }
        sigField.put(PdfName.P, this.document.getPage(this.getPageNumber()).getPdfObject());
        sigField.put(PdfName.V, this.cryptoDictionary.getPdfObject());
        PdfObject obj = sigField.getPdfObject().get(PdfName.F);
        int flags = 0;
        if (obj != null && obj.isNumber()) {
            flags = ((PdfNumber)obj).intValue();
        }
        sigField.put(PdfName.F, (PdfObject)new PdfNumber(flags |= 0x80));
        sigField.disableFieldRegeneration();
        if (this.appearance.isReuseAppearanceSet()) {
            sigField.setReuseAppearance(this.appearance.isReuseAppearance());
        }
        if (this.appearance.getSignatureAppearanceLayer() != null) {
            sigField.setSignatureAppearanceLayer(this.appearance.getSignatureAppearanceLayer());
        }
        if (this.appearance.getBackgroundLayer() != null) {
            sigField.setBackgroundLayer(this.appearance.getBackgroundLayer());
        }
        sigField.getFirstFormAnnotation().setFormFieldElement((IFormField)this.appearance.getSignatureAppearance());
        sigField.enableFieldRegeneration();
        sigField.setModified();
        return sigFieldLock;
    }

    protected PdfSigFieldLock createNewSignatureFormField(PdfAcroForm acroForm, String name) throws IOException {
        PdfWidgetAnnotation widget = new PdfWidgetAnnotation(this.getPageRect());
        widget.setFlags(132);
        PdfSignatureFormField sigField = new SignatureFormFieldBuilder(this.document, name).createSignature();
        sigField.put(PdfName.V, this.cryptoDictionary.getPdfObject());
        sigField.addKid(widget);
        PdfSigFieldLock sigFieldLock = sigField.getSigFieldLockDictionary();
        if (this.fieldLock != null) {
            ((PdfDictionary)this.fieldLock.getPdfObject()).makeIndirect(this.document);
            sigField.put(PdfName.Lock, this.fieldLock.getPdfObject());
            sigFieldLock = this.fieldLock;
        }
        int pagen = this.getPageNumber();
        widget.setPage(this.document.getPage(pagen));
        sigField.disableFieldRegeneration();
        sigField.setReuseAppearance(this.appearance.isReuseAppearance()).setSignatureAppearanceLayer(this.appearance.getSignatureAppearanceLayer()).setBackgroundLayer(this.appearance.getBackgroundLayer());
        this.applyDefaultPropertiesForTheNewField(sigField);
        sigField.enableFieldRegeneration();
        acroForm.addField((PdfFormField)sigField, this.document.getPage(pagen));
        if (((PdfDictionary)acroForm.getPdfObject()).isIndirect()) {
            acroForm.setModified();
        } else {
            this.document.getCatalog().setModified();
        }
        return sigFieldLock;
    }

    protected InputStream getRangeStream() throws IOException {
        RandomAccessSourceFactory fac = new RandomAccessSourceFactory();
        IRandomAccessSource randomAccessSource = fac.createRanged(this.getUnderlyingSource(), this.range);
        return new RASInputStream(randomAccessSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(PdfDictionary update) throws IOException {
        try {
            if (!this.preClosed) {
                throw new PdfException("Document must be preClosed.");
            }
            ByteArrayOutputStream bous = new ByteArrayOutputStream();
            PdfOutputStream os = new PdfOutputStream((OutputStream)bous);
            for (PdfName key : update.keySet()) {
                PdfObject obj = update.get(key);
                PdfLiteral lit = this.exclusionLocations.get(key);
                if (lit == null) {
                    throw new IllegalArgumentException("The key didn't reserve space in preclose");
                }
                bous.reset();
                os.write(obj);
                if (bous.size() > lit.getBytesCount()) {
                    throw new IllegalArgumentException("The key is too big.");
                }
                if (this.tempFile == null) {
                    System.arraycopy(bous.toByteArray(), 0, this.bout, (int)lit.getPosition(), bous.size());
                    continue;
                }
                this.raf.seek(lit.getPosition());
                this.raf.write(bous.toByteArray(), 0, bous.size());
            }
            if (update.size() != this.exclusionLocations.size()) {
                throw new IllegalArgumentException("The update dictionary has less keys than required");
            }
            if (this.tempFile == null) {
                this.originalOS.write(this.bout, 0, this.bout.length);
            } else if (this.originalOS != null) {
                int r;
                this.raf.seek(0L);
                byte[] buf = new byte[8192];
                for (long length = this.raf.length(); length > 0L; length -= (long)r) {
                    r = this.raf.read(buf, 0, (int)Math.min((long)buf.length, length));
                    if (r < 0) {
                        throw new EOFException("unexpected eof");
                    }
                    this.originalOS.write(buf, 0, r);
                }
            }
        }
        finally {
            if (this.tempFile != null) {
                this.raf.close();
                if (this.originalOS != null) {
                    this.tempFile.delete();
                }
            }
            if (this.originalOS != null) {
                try {
                    this.originalOS.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected IRandomAccessSource getUnderlyingSource() throws IOException {
        RandomAccessSourceFactory fac = new RandomAccessSourceFactory();
        return this.raf == null ? fac.createSource(this.bout) : fac.createSource(this.raf);
    }

    protected void addDocMDP(PdfSignature crypto) {
        PdfDictionary reference = new PdfDictionary();
        PdfDictionary transformParams = new PdfDictionary();
        transformParams.put(PdfName.P, (PdfObject)new PdfNumber(this.certificationLevel));
        transformParams.put(PdfName.V, (PdfObject)new PdfName("1.2"));
        transformParams.put(PdfName.Type, (PdfObject)PdfName.TransformParams);
        reference.put(PdfName.TransformMethod, (PdfObject)PdfName.DocMDP);
        reference.put(PdfName.Type, (PdfObject)PdfName.SigRef);
        reference.put(PdfName.TransformParams, (PdfObject)transformParams);
        reference.put(PdfName.Data, this.document.getTrailer().get(PdfName.Root));
        PdfArray types = new PdfArray();
        types.add((PdfObject)reference);
        crypto.put(PdfName.Reference, (PdfObject)types);
    }

    protected void addFieldMDP(PdfSignature crypto, PdfSigFieldLock fieldLock) {
        PdfDictionary reference = new PdfDictionary();
        PdfDictionary transformParams = new PdfDictionary();
        transformParams.putAll((PdfDictionary)fieldLock.getPdfObject());
        transformParams.put(PdfName.Type, (PdfObject)PdfName.TransformParams);
        transformParams.put(PdfName.V, (PdfObject)new PdfName("1.2"));
        reference.put(PdfName.TransformMethod, (PdfObject)PdfName.FieldMDP);
        reference.put(PdfName.Type, (PdfObject)PdfName.SigRef);
        reference.put(PdfName.TransformParams, (PdfObject)transformParams);
        reference.put(PdfName.Data, this.document.getTrailer().get(PdfName.Root));
        PdfArray types = ((PdfDictionary)crypto.getPdfObject()).getAsArray(PdfName.Reference);
        if (types == null) {
            types = new PdfArray();
            crypto.put(PdfName.Reference, (PdfObject)types);
        }
        types.add((PdfObject)reference);
    }

    protected boolean documentContainsCertificationOrApprovalSignatures() {
        boolean containsCertificationOrApprovalSignature = false;
        PdfDictionary urSignature = null;
        PdfDictionary catalogPerms = ((PdfDictionary)this.document.getCatalog().getPdfObject()).getAsDictionary(PdfName.Perms);
        if (catalogPerms != null) {
            urSignature = catalogPerms.getAsDictionary(PdfName.UR3);
        }
        for (Map.Entry entry : this.acroForm.getAllFormFields().entrySet()) {
            PdfSignature pdfSignature;
            PdfDictionary sigDict;
            PdfDictionary fieldDict = ((PdfFormField)entry.getValue()).getPdfObject();
            if (!PdfName.Sig.equals((Object)fieldDict.get(PdfName.FT)) || (sigDict = fieldDict.getAsDictionary(PdfName.V)) == null || (pdfSignature = new PdfSignature(sigDict)).getContents() == null || pdfSignature.getByteRange() == null || pdfSignature.getType().equals((Object)PdfName.DocTimeStamp) || sigDict == urSignature) continue;
            containsCertificationOrApprovalSignature = true;
            break;
        }
        return containsCertificationOrApprovalSignature;
    }

    protected Rectangle getWidgetRectangle(PdfWidgetAnnotation widget) {
        return widget.getRectangle().toRectangle();
    }

    protected int getWidgetPageNumber(PdfWidgetAnnotation widget) {
        int pageNumber = 0;
        PdfDictionary pageDict = ((PdfDictionary)widget.getPdfObject()).getAsDictionary(PdfName.P);
        if (pageDict != null) {
            pageNumber = this.document.getPageNumber(pageDict);
        } else {
            for (int i = 1; i <= this.document.getNumberOfPages(); ++i) {
                PdfPage page = this.document.getPage(i);
                if (page.isFlushed() || !page.containsAnnotation((PdfAnnotation)widget)) continue;
                pageNumber = i;
                break;
            }
        }
        return pageNumber;
    }

    private void updateFieldName(String fieldName) {
        if (fieldName != null) {
            PdfFormField field = this.acroForm.getField(fieldName);
            if (field != null) {
                if (!PdfName.Sig.equals((Object)field.getFormType())) {
                    throw new IllegalArgumentException("Field type is not a signature field type.");
                }
                if (field.getValue() != null) {
                    throw new IllegalArgumentException("Field has been already signed.");
                }
                List widgets = field.getWidgets();
                if (widgets.size() > 0) {
                    PdfWidgetAnnotation widget = (PdfWidgetAnnotation)widgets.get(0);
                    this.setPageRect(this.getWidgetRectangle(widget));
                    this.setPageNumber(this.getWidgetPageNumber(widget));
                }
            } else if (fieldName.indexOf(46) >= 0) {
                throw new IllegalArgumentException("Field names cannot contain a dot.");
            }
            this.appearance.setFieldName(fieldName);
            this.fieldName = fieldName;
        }
    }

    private boolean isDocumentPdf2() {
        return this.document.getPdfVersion().compareTo(PdfVersion.PDF_2_0) >= 0;
    }

    PdfSignature createSignatureDictionary(boolean includeDate) {
        PdfSignature dic = new PdfSignature();
        dic.setReason(this.getReason());
        dic.setLocation(this.getLocation());
        dic.setSignatureCreator(this.getSignatureCreator());
        dic.setContact(this.getContact());
        if (includeDate) {
            dic.setDate(new PdfDate(this.getSignDate()));
        }
        return dic;
    }

    private void applyDefaultPropertiesForTheNewField(PdfSignatureFormField sigField) {
        TransparentColor color;
        UnitValue fontSize;
        SignatureFieldAppearance formFieldElement = this.appearance.getSignatureAppearance();
        PdfFormAnnotation annotation = sigField.getFirstFormAnnotation();
        annotation.setFormFieldElement((IFormField)formFieldElement);
        ((PdfWidgetAnnotation)sigField.getWidgets().get(0)).setHighlightMode(PdfAnnotation.HIGHLIGHT_NONE);
        sigField.setJustification((TextAlignment)formFieldElement.getProperty(70));
        Object retrievedFont = formFieldElement.getProperty(20);
        if (retrievedFont instanceof PdfFont) {
            sigField.setFont((PdfFont)retrievedFont);
        }
        if ((fontSize = (UnitValue)formFieldElement.getProperty(24)) != null && fontSize.isPointValue()) {
            sigField.setFontSize(fontSize.getValue());
        }
        if ((color = (TransparentColor)formFieldElement.getProperty(21)) != null) {
            sigField.setColor(color.getColor());
        }
        BorderStyleUtil.applyBorderProperty((IPropertyContainer)formFieldElement, (PdfFormAnnotation)annotation);
        Background background = (Background)formFieldElement.getProperty(6);
        if (background != null) {
            sigField.getFirstFormAnnotation().setBackgroundColor(background.getColor());
        }
    }

    @FunctionalInterface
    static interface ISignatureDataProvider {
        public byte[] sign(SignatureApplier var1) throws GeneralSecurityException, IOException;
    }

    static class SignatureApplier {
        private final PdfDocument document;
        private final String fieldName;
        private final OutputStream outs;
        private IRandomAccessSource readerSource;
        private long[] gaps;

        public SignatureApplier(PdfDocument document, String fieldName, OutputStream outs) {
            this.document = document;
            this.fieldName = fieldName;
            this.outs = outs;
        }

        public void apply(ISignatureDataProvider signatureDataProvider) throws IOException, GeneralSecurityException {
            SignatureUtil signatureUtil = new SignatureUtil(this.document);
            PdfSignature signature = signatureUtil.getSignature(this.fieldName);
            if (signature == null) {
                throw new PdfException("There is no field in the document with such name: {0}.").setMessageParams(new Object[]{this.fieldName});
            }
            if (!signatureUtil.signatureCoversWholeDocument(this.fieldName)) {
                throw new PdfException("Signature with name {0} is not the last. It doesn't cover the whole document.").setMessageParams(new Object[]{this.fieldName});
            }
            PdfArray b = signature.getByteRange();
            this.gaps = b.toLongArray();
            this.readerSource = this.document.getReader().getSafeFile().createSourceView();
            int spaceAvailable = (int)(this.gaps[2] - this.gaps[1]) - 2;
            if ((spaceAvailable & 1) != 0) {
                throw new IllegalArgumentException("Gap is not a multiple of 2");
            }
            byte[] signedContent = signatureDataProvider.sign(this);
            if ((spaceAvailable /= 2) < signedContent.length) {
                throw new PdfException("Available space is not enough for signature.");
            }
            StreamUtil.copyBytes((IRandomAccessSource)this.readerSource, (long)0L, (long)(this.gaps[1] + 1L), (OutputStream)this.outs);
            ByteBuffer bb = new ByteBuffer(spaceAvailable * 2);
            for (byte bi : signedContent) {
                bb.appendHex(bi);
            }
            int remain = (spaceAvailable - signedContent.length) * 2;
            for (int k = 0; k < remain; ++k) {
                bb.append((byte)48);
            }
            byte[] bbArr = bb.toByteArray();
            this.outs.write(bbArr);
            StreamUtil.copyBytes((IRandomAccessSource)this.readerSource, (long)(this.gaps[2] - 1L), (long)(this.gaps[3] + 1L), (OutputStream)this.outs);
            this.document.close();
        }

        public InputStream getDataToSign() throws IOException {
            return new RASInputStream(new RandomAccessSourceFactory().createRanged(this.readerSource, this.gaps));
        }
    }

    public static interface ISignatureEvent {
        public void getSignatureDictionary(PdfSignature var1);
    }

    public static enum CryptoStandard {
        CMS,
        CADES;

    }
}

