/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.extensions;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.signatures.validation.extensions.CertificateExtension;
import com.itextpdf.signatures.validation.extensions.KeyUsage;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;

public class KeyUsageExtension
extends CertificateExtension {
    private static final IBouncyCastleFactory FACTORY = BouncyCastleFactoryCreator.getFactory();
    private final int keyUsage;

    public KeyUsageExtension(int keyUsage) {
        super("2.5.29.15", FACTORY.createKeyUsage(keyUsage).toASN1Primitive());
        this.keyUsage = keyUsage;
    }

    public KeyUsageExtension(List<KeyUsage> keyUsages) {
        this(KeyUsageExtension.convertKeyUsageSetToInt(keyUsages));
    }

    public KeyUsageExtension(KeyUsage keyUsageValue) {
        this(Collections.singletonList(keyUsageValue));
    }

    @Override
    public boolean existsInCertificate(X509Certificate certificate) {
        boolean[] providedKeyUsageFlags = certificate.getKeyUsage();
        if (providedKeyUsageFlags == null) {
            return false;
        }
        for (int i = 0; i < providedKeyUsageFlags.length; ++i) {
            int power = providedKeyUsageFlags.length - i - 2;
            if (power < 0) {
                power = 16 + power;
            }
            if ((this.keyUsage & 1 << power) == 0 || providedKeyUsageFlags[i]) continue;
            return false;
        }
        return true;
    }

    private static int convertKeyUsageSetToInt(List<KeyUsage> keyUsages) {
        KeyUsage[] possibleKeyUsage = new KeyUsage[]{KeyUsage.DIGITAL_SIGNATURE, KeyUsage.NON_REPUDIATION, KeyUsage.KEY_ENCIPHERMENT, KeyUsage.DATA_ENCIPHERMENT, KeyUsage.KEY_AGREEMENT, KeyUsage.KEY_CERT_SIGN, KeyUsage.CRL_SIGN, KeyUsage.ENCIPHER_ONLY, KeyUsage.DECIPHER_ONLY};
        int result = 0;
        for (int i = 0; i < possibleKeyUsage.length; ++i) {
            if (!keyUsages.contains((Object)possibleKeyUsage[i])) continue;
            int power = possibleKeyUsage.length - i - 2;
            if (power < 0) {
                power = 16 + power;
            }
            result |= 1 << power;
        }
        return result;
    }
}

