/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.lotl;

import com.itextpdf.signatures.validation.lotl.CountrySpecificLotl;
import com.itextpdf.signatures.validation.lotl.LotlFetchingProperties;
import com.itextpdf.signatures.validation.lotl.xml.IDefaultXmlHandler;
import com.itextpdf.signatures.validation.lotl.xml.XmlSaxProcessor;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

final class XmlCountryRetriever {
    public List<CountrySpecificLotl> getAllCountriesLotlFilesLocation(InputStream data, LotlFetchingProperties lotlFetchingProperties) {
        TSLLocationExtractor tslLocationExtractor = new TSLLocationExtractor();
        new XmlSaxProcessor().process(data, tslLocationExtractor);
        List<CountrySpecificLotl> countrySpecificLotls = tslLocationExtractor.tslLocations;
        return countrySpecificLotls.stream().filter(countrySpecificLotl -> lotlFetchingProperties.shouldProcessCountry(countrySpecificLotl.getSchemeTerritory())).collect(Collectors.toList());
    }

    private static final class TSLLocationExtractor
    implements IDefaultXmlHandler {
        private static final String MIME_TYPE_ETSI_TSL = "application/vnd.etsi.tsl+xml";
        final List<CountrySpecificLotl> tslLocations = new ArrayList<CountrySpecificLotl>();
        String parsingState = null;
        String schemeTerritory = null;
        String tslLocation = null;
        String mimeType = null;

        TSLLocationExtractor() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, HashMap<String, String> attributes) {
            this.parsingState = localName;
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if ("OtherTSLPointer".equals(localName)) {
                CountrySpecificLotl data = new CountrySpecificLotl(this.schemeTerritory, this.tslLocation, this.mimeType);
                if (TSLLocationExtractor.isXmlLink(data)) {
                    this.tslLocations.add(data);
                }
                this.resetState();
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.parsingState == null) {
                return;
            }
            String value = new String(ch, start, length).trim();
            if (value.isEmpty()) {
                return;
            }
            switch (this.parsingState) {
                case "SchemeTerritory": {
                    this.schemeTerritory = value;
                    break;
                }
                case "TSLLocation": {
                    this.tslLocation = value;
                    break;
                }
                case "MimeType": {
                    this.mimeType = value;
                    break;
                }
            }
        }

        private void resetState() {
            this.schemeTerritory = null;
            this.tslLocation = null;
            this.parsingState = null;
            this.mimeType = null;
        }

        private static boolean isXmlLink(CountrySpecificLotl data) {
            return MIME_TYPE_ETSI_TSL.equals(data.getMimeType());
        }
    }
}

