/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.lotl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.itextpdf.signatures.CertificateUtil;
import com.itextpdf.signatures.validation.lotl.AdditionalServiceInformationExtension;
import com.itextpdf.signatures.validation.lotl.CountryServiceContext;
import com.itextpdf.signatures.validation.lotl.CountrySpecificLotlFetcher;
import com.itextpdf.signatures.validation.lotl.EuropeanLotlFetcher;
import com.itextpdf.signatures.validation.lotl.EuropeanResourceFetcher;
import com.itextpdf.signatures.validation.lotl.IServiceContext;
import com.itextpdf.signatures.validation.lotl.PivotFetcher;
import com.itextpdf.signatures.validation.lotl.QualifierExtension;
import com.itextpdf.signatures.validation.lotl.ServiceChronologicalInfo;
import com.itextpdf.signatures.validation.lotl.SimpleServiceContext;
import com.itextpdf.signatures.validation.lotl.criteria.CertSubjectDNAttributeCriteria;
import com.itextpdf.signatures.validation.lotl.criteria.Criteria;
import com.itextpdf.signatures.validation.lotl.criteria.CriteriaList;
import com.itextpdf.signatures.validation.lotl.criteria.ExtendedKeyUsageCriteria;
import com.itextpdf.signatures.validation.lotl.criteria.KeyUsageCriteria;
import com.itextpdf.signatures.validation.lotl.criteria.PolicySetCriteria;
import com.itextpdf.signatures.validation.report.CertificateReportItem;
import com.itextpdf.signatures.validation.report.ReportItem;
import com.itextpdf.signatures.validation.report.ValidationReport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class LotlCacheDataV1 {
    private static final String JSON_KEY_BASE64_ENCODED = "base64Encoded";
    private static final String JSON_KEY_REPORT_ITEMS = "reportItems";
    private static final String JSON_KEY_REPORT_ITEM_CHECKNAME = "checkName";
    private static final String JSON_KEY_REPORT_ITEM_MESSAGE = "message";
    private static final String JSON_KEY_REPORT_CAUSE = "exceptionCause";
    private static final String JSON_KEY_REPORT_STATUS = "status";
    private static final String JSON_KEY_CERTIFICATE = "certificate";
    private static final String JSON_KEY_CERTIFICATES = "certificates";
    private static final String JSON_KEY_QUALIFIER_EXTENSIONS = "qualifierExtensions";
    private static final String JSON_KEY_QUALIFIERS = "qualifiers";
    private static final String JSON_KEY_CRITERIA_LIST = "criteriaList";
    private static final String JSON_KEY_CRITERIAS = "criterias";
    private static final String JSON_KEY_CRITERIA_ASSERT_VALUE = "criteriaAssertValue";
    private static final String JSON_KEY_CRITERIA_CERT_SUBJECT_DN_ATTRIBUTE_CRITERIA = "certSubjectDNAttributeCriteria";
    private static final String JSON_KEY_CRITERIA_REQUIRED_ATTRIBUTE_IDS = "requiredAttributeIDs";
    private static final String JSON_KEY_CRITERIA_EXTENDED_KEY_USAGE_CRITERIA = "extendedKeyUsageCriteria";
    private static final String JSON_KEY_CRITERIA_REQUIRED_EXTENDED_KEY_USAGES = "requiredExtendedKeyUsages";
    private static final String JSON_KEY_CRITERIA_POLICY_SET_CRITERIA = "policySetCriteria";
    private static final String JSON_KEY_CRITERIA_REQUIRED_POLICY_IDS = "requiredPolicyIDs";
    private static final String JSON_KEY_CRITERIA_KEY_USAGE_CRITERIA = "keyUsageCriteria";
    private static final String JSON_KEY_CRITERIA_KEY_USAGE_BITS = "requiredKeyUsageBits";
    private static final String JSON_KEY_SERVICE_TYPE = "serviceType";
    private static final String JSON_KEY_SERVICE_EXTENSIONS = "serviceExtensions";
    private static final String JSON_KEY_SERVICE_CHRONOLOGICAL_INFOS = "serviceChronologicalInfos";
    private static final String JSON_KEY_SERVICE_STATUS = "serviceStatus";
    private static final String JSON_KEY_SERVICE_STATUS_STARTING_TIME = "serviceStatusStartingTime";
    private static final String JSON_KEY_URI = "uri";
    private static final String JSON_KEY_LOTL_CACHE = "lotlCache";
    private static final String JSON_KEY_EUROPEAN_RESOURCE_FETCHER_CACHE = "europeanResourceFetcherCache";
    private static final String JSON_KEY_PIVOT_CACHE = "pivotCache";
    private static final String JSON_KEY_COUNTRY_SPECIFIC_LOTL_CACHE = "countrySpecificLotlCache";
    private static final String JSON_KEY_TIME_STAMPS = "timeStamps";
    private static final String JSON_KEY_LOCAL_REPORT = "localReport";
    private static final String JSON_KEY_CURRENTLY_SUPPORTED_PUBLICATION = "currentlySupportedPublication";
    private static final String DATE_TIME_FORMATTER_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    private EuropeanLotlFetcher.Result lotlCache;
    private EuropeanResourceFetcher.Result europeanResourceFetcherCache;
    private PivotFetcher.Result pivotCache;
    private Map<String, CountrySpecificLotlFetcher.Result> countrySpecificLotlCache;
    private Map<String, Long> timeStamps = new HashMap<String, Long>();

    public LotlCacheDataV1() {
    }

    LotlCacheDataV1(EuropeanLotlFetcher.Result lotlCache, PivotFetcher.Result pivotCache, EuropeanResourceFetcher.Result europeanResourceFetcherCache, Map<String, CountrySpecificLotlFetcher.Result> countrySpecificLotlCache, Map<String, Long> timeStamps) {
        this.countrySpecificLotlCache = countrySpecificLotlCache;
        this.lotlCache = lotlCache;
        this.europeanResourceFetcherCache = europeanResourceFetcherCache;
        this.pivotCache = pivotCache;
        this.timeStamps = timeStamps;
    }

    public static LotlCacheDataV1 deserialize(InputStream inputStream) {
        try {
            return (LotlCacheDataV1)LotlCacheDataV1.createObjectMapper().readValue(inputStream, LotlCacheDataV1.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void serialize(OutputStream os) throws IOException {
        LotlCacheDataV1.createObjectMapper().writer().writeValue(os, (Object)this);
    }

    public EuropeanResourceFetcher.Result getEuropeanResourceFetcherCache() {
        return this.europeanResourceFetcherCache;
    }

    public Map<String, Long> getTimeStamps() {
        return this.timeStamps;
    }

    public PivotFetcher.Result getPivotCache() {
        return this.pivotCache;
    }

    public Map<String, CountrySpecificLotlFetcher.Result> getCountrySpecificLotlCache() {
        return this.countrySpecificLotlCache;
    }

    public EuropeanLotlFetcher.Result getLotlCache() {
        return this.lotlCache;
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(new JsonGenerator.Feature[]{JsonGenerator.Feature.AUTO_CLOSE_TARGET});
        objectMapper.writer((PrettyPrinter)new MinimalPrettyPrinter());
        SimpleModule module = new SimpleModule();
        module.addSerializer(X509Certificate.class, (JsonSerializer)new X509CertificateSerializer());
        module.addSerializer(ValidationReport.class, (JsonSerializer)new ValidationReportSerializer());
        module.addSerializer(EuropeanResourceFetcher.Result.class, (JsonSerializer)new EuropeanResultFetcherSerializer());
        module.addSerializer(LotlCacheDataV1.class, (JsonSerializer)new LotlCacheDataV1Serializer());
        module.addSerializer(ServiceChronologicalInfo.class, (JsonSerializer)new ServiceChronologicalInfoSerializer());
        objectMapper.configOverride(CountryServiceContext.class).setIgnorals(JsonIgnoreProperties.Value.forIgnoredProperties((String[])new String[]{"currentChronologicalInfo"}));
        module.addDeserializer(Certificate.class, (JsonDeserializer)new X509CertificateDeserializer());
        module.addDeserializer(X509Certificate.class, (JsonDeserializer)new X509CertificateDeserializer());
        module.addDeserializer(ValidationReport.class, (JsonDeserializer)new ValidationReportDeserializer());
        module.addDeserializer(ReportItem.class, (JsonDeserializer)new ReportItemDeserializer());
        module.addDeserializer(IServiceContext.class, (JsonDeserializer)new IServiceContextDeserializer());
        module.addDeserializer(ServiceChronologicalInfo.class, (JsonDeserializer)new ServiceChronologicalInfoDeserializer());
        objectMapper.registerModule((Module)module);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        return objectMapper;
    }

    static class ServiceChronologicalInfoDeserializer
    extends JsonDeserializer<ServiceChronologicalInfo> {
        public ServiceChronologicalInfo deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode extensionsNode;
            ObjectCodec codec = p.getCodec();
            JsonNode node = (JsonNode)codec.readTree(p);
            String serviceStatus = node.has(LotlCacheDataV1.JSON_KEY_SERVICE_STATUS) ? node.get(LotlCacheDataV1.JSON_KEY_SERVICE_STATUS).asText() : null;
            LocalDateTime serviceStatusStartingTime = node.has(LotlCacheDataV1.JSON_KEY_SERVICE_STATUS_STARTING_TIME) ? LocalDateTime.parse(node.get(LotlCacheDataV1.JSON_KEY_SERVICE_STATUS_STARTING_TIME).asText().split("\\.")[0], DateTimeFormatter.ofPattern(LotlCacheDataV1.DATE_TIME_FORMATTER_PATTERN)) : null;
            ServiceChronologicalInfo info = new ServiceChronologicalInfo();
            info.setServiceStatus(serviceStatus);
            info.setServiceStatusStartingTime(serviceStatusStartingTime);
            if (node.has(LotlCacheDataV1.JSON_KEY_SERVICE_EXTENSIONS) && (extensionsNode = node.get(LotlCacheDataV1.JSON_KEY_SERVICE_EXTENSIONS)) != null && extensionsNode.isArray()) {
                for (JsonNode extensionNode : extensionsNode) {
                    AdditionalServiceInformationExtension extension = (AdditionalServiceInformationExtension)codec.treeToValue((TreeNode)extensionNode, AdditionalServiceInformationExtension.class);
                    info.getServiceExtensions().add(extension);
                }
            }
            if (node.has(LotlCacheDataV1.JSON_KEY_QUALIFIER_EXTENSIONS) && (extensionsNode = node.get(LotlCacheDataV1.JSON_KEY_QUALIFIER_EXTENSIONS)) != null && extensionsNode.isArray()) {
                for (JsonNode extensionNode : extensionsNode) {
                    CriteriaList criteriaList;
                    JsonNode qualifiersNode = extensionNode.get(LotlCacheDataV1.JSON_KEY_QUALIFIERS);
                    if (qualifiersNode == null || !qualifiersNode.isArray()) continue;
                    QualifierExtension qualifierExtension = new QualifierExtension();
                    for (JsonNode qualifierNode : qualifiersNode) {
                        if (qualifierNode == null || !qualifierNode.isTextual()) continue;
                        qualifierExtension.addQualifier(qualifierNode.asText());
                    }
                    JsonNode criteriaListNode = extensionNode.get(LotlCacheDataV1.JSON_KEY_CRITERIA_LIST);
                    if (criteriaListNode == null || (criteriaList = ServiceChronologicalInfoDeserializer.readCriteriaListNode(criteriaListNode)) == null) continue;
                    qualifierExtension.setCriteriaList(criteriaList);
                    info.addQualifierExtension(qualifierExtension);
                }
            }
            return info;
        }

        private static CriteriaList readCriteriaListNode(JsonNode criteriaListNode) {
            JsonNode assertValueNode = criteriaListNode.get(LotlCacheDataV1.JSON_KEY_CRITERIA_ASSERT_VALUE);
            if (assertValueNode == null || !assertValueNode.isTextual()) {
                return null;
            }
            CriteriaList criteriaList = new CriteriaList(assertValueNode.asText());
            JsonNode criteriasNode = criteriaListNode.get(LotlCacheDataV1.JSON_KEY_CRITERIAS);
            if (criteriasNode == null || !criteriasNode.isArray()) {
                return null;
            }
            for (JsonNode criteriaNode : criteriasNode) {
                Criteria criteria;
                JsonNode citeriaNode = criteriaNode.get(LotlCacheDataV1.JSON_KEY_CRITERIA_LIST);
                if (citeriaNode != null) {
                    CriteriaList innerCriteriaList = ServiceChronologicalInfoDeserializer.readCriteriaListNode(citeriaNode);
                    if (innerCriteriaList == null) continue;
                    criteriaList.addCriteria(innerCriteriaList);
                    continue;
                }
                citeriaNode = criteriaNode.get(LotlCacheDataV1.JSON_KEY_CRITERIA_CERT_SUBJECT_DN_ATTRIBUTE_CRITERIA);
                if (citeriaNode != null) {
                    criteria = new CertSubjectDNAttributeCriteria();
                    JsonNode requiredAttributeIDsNode = citeriaNode.get(LotlCacheDataV1.JSON_KEY_CRITERIA_REQUIRED_ATTRIBUTE_IDS);
                    if (requiredAttributeIDsNode != null && requiredAttributeIDsNode.isArray()) {
                        for (JsonNode attributeIDNode : requiredAttributeIDsNode) {
                            ((CertSubjectDNAttributeCriteria)criteria).addRequiredAttributeId(attributeIDNode.asText());
                        }
                    }
                    criteriaList.addCriteria(criteria);
                    continue;
                }
                citeriaNode = criteriaNode.get(LotlCacheDataV1.JSON_KEY_CRITERIA_EXTENDED_KEY_USAGE_CRITERIA);
                if (citeriaNode != null) {
                    criteria = new ExtendedKeyUsageCriteria();
                    JsonNode requiredExtendedKeyUsagesNode = citeriaNode.get(LotlCacheDataV1.JSON_KEY_CRITERIA_REQUIRED_EXTENDED_KEY_USAGES);
                    if (requiredExtendedKeyUsagesNode != null && requiredExtendedKeyUsagesNode.isArray()) {
                        for (JsonNode extendedKeyUsageNode : requiredExtendedKeyUsagesNode) {
                            ((ExtendedKeyUsageCriteria)criteria).addRequiredExtendedKeyUsage(extendedKeyUsageNode.asText());
                        }
                    }
                    criteriaList.addCriteria(criteria);
                    continue;
                }
                citeriaNode = criteriaNode.get(LotlCacheDataV1.JSON_KEY_CRITERIA_POLICY_SET_CRITERIA);
                if (citeriaNode != null) {
                    criteria = new PolicySetCriteria();
                    JsonNode requiredPolicyIDsNode = citeriaNode.get(LotlCacheDataV1.JSON_KEY_CRITERIA_REQUIRED_POLICY_IDS);
                    if (requiredPolicyIDsNode != null && requiredPolicyIDsNode.isArray()) {
                        for (JsonNode policyIDNode : requiredPolicyIDsNode) {
                            ((PolicySetCriteria)criteria).addRequiredPolicyId(policyIDNode.asText());
                        }
                    }
                    criteriaList.addCriteria(criteria);
                    continue;
                }
                citeriaNode = criteriaNode.get(LotlCacheDataV1.JSON_KEY_CRITERIA_KEY_USAGE_CRITERIA);
                if (citeriaNode != null) {
                    criteria = new KeyUsageCriteria();
                    JsonNode requiredKeyUsageBitsNode = citeriaNode.get(LotlCacheDataV1.JSON_KEY_CRITERIA_KEY_USAGE_BITS);
                    if (requiredKeyUsageBitsNode != null && requiredKeyUsageBitsNode.isArray()) {
                        int counter = 0;
                        for (JsonNode keyUsageBitNode : requiredKeyUsageBitsNode) {
                            String text = keyUsageBitNode.asText();
                            ((KeyUsageCriteria)criteria).getKeyUsageBits()[counter] = "null".equals(text) ? null : Boolean.valueOf(Boolean.parseBoolean(text));
                            ++counter;
                        }
                    }
                    criteriaList.addCriteria(criteria);
                    continue;
                }
                throw new RuntimeException("Unknown criteria type in JSON");
            }
            return criteriaList;
        }
    }

    static class IServiceContextDeserializer
    extends JsonDeserializer<IServiceContext> {
        public IServiceContext deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            IServiceContext context;
            ObjectCodec codec = p.getCodec();
            JsonNode node = (JsonNode)codec.readTree(p);
            ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
            JsonNode certsNode = node.get(LotlCacheDataV1.JSON_KEY_CERTIFICATES);
            if (certsNode != null && certsNode.isArray()) {
                for (JsonNode certNode : certsNode) {
                    X509Certificate x509Certificate = (X509Certificate)codec.treeToValue((TreeNode)certNode, X509Certificate.class);
                    certificates.add(x509Certificate);
                }
            }
            if (node.has(LotlCacheDataV1.JSON_KEY_SERVICE_TYPE)) {
                context = new CountryServiceContext();
                ArrayList<ServiceChronologicalInfo> infos = new ArrayList<ServiceChronologicalInfo>();
                JsonNode jsonNode = node.get(LotlCacheDataV1.JSON_KEY_SERVICE_CHRONOLOGICAL_INFOS);
                if (jsonNode != null && jsonNode.isArray()) {
                    for (JsonNode jsonNode2 : jsonNode) {
                        ServiceChronologicalInfo info = (ServiceChronologicalInfo)codec.treeToValue((TreeNode)jsonNode2, ServiceChronologicalInfo.class);
                        infos.add(info);
                    }
                }
                for (Certificate certificate : certificates) {
                    ((CountryServiceContext)context).addCertificate(certificate);
                }
                ((CountryServiceContext)context).getServiceChronologicalInfos().addAll(infos);
                ((CountryServiceContext)context).setServiceType(node.get(LotlCacheDataV1.JSON_KEY_SERVICE_TYPE).asText());
                return context;
            }
            context = new SimpleServiceContext();
            for (Certificate certificate : certificates) {
                ((SimpleServiceContext)context).addCertificate(certificate);
            }
            return context;
        }
    }

    static class X509CertificateSerializer
    extends JsonSerializer<X509Certificate> {
        public void serialize(X509Certificate cert, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            byte[] encoded;
            gen.writeStartObject();
            try {
                encoded = cert.getEncoded();
            }
            catch (CertificateEncodingException e) {
                throw new RuntimeException(e);
            }
            String base64Encoded = Base64.getEncoder().encodeToString(encoded);
            gen.writeStringField(LotlCacheDataV1.JSON_KEY_BASE64_ENCODED, base64Encoded);
            gen.writeEndObject();
        }
    }

    static class ValidationReportSerializer
    extends JsonSerializer<ValidationReport> {
        public void serialize(ValidationReport report, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            gen.writeArrayFieldStart(LotlCacheDataV1.JSON_KEY_REPORT_ITEMS);
            ArrayList<ReportItem> sortedItems = new ArrayList<ReportItem>(report.getLogs());
            sortedItems.sort((item1, item2) -> {
                if (item1.getCheckName() == null && item2.getCheckName() == null) {
                    return 0;
                }
                if (item1.getCheckName() == null) {
                    return -1;
                }
                if (item2.getCheckName() == null) {
                    return 1;
                }
                return item1.getCheckName().compareTo(item2.getCheckName());
            });
            for (ReportItem item : sortedItems) {
                gen.writeObject((Object)item);
            }
            gen.writeEndArray();
            gen.writeEndObject();
        }
    }

    static class EuropeanResultFetcherSerializer
    extends JsonSerializer<EuropeanResourceFetcher.Result> {
        public void serialize(EuropeanResourceFetcher.Result result, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeObjectField(LotlCacheDataV1.JSON_KEY_LOCAL_REPORT, (Object)result.getLocalReport());
            jsonGenerator.writeArrayFieldStart(LotlCacheDataV1.JSON_KEY_CERTIFICATES);
            for (Certificate certificate : result.getCertificates()) {
                jsonGenerator.writeObject((Object)certificate);
            }
            jsonGenerator.writeEndArray();
            jsonGenerator.writeStringField(LotlCacheDataV1.JSON_KEY_CURRENTLY_SUPPORTED_PUBLICATION, result.getCurrentlySupportedPublication());
            jsonGenerator.writeEndObject();
        }
    }

    static class ServiceChronologicalInfoSerializer
    extends JsonSerializer<ServiceChronologicalInfo> {
        public void serialize(ServiceChronologicalInfo info, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField(LotlCacheDataV1.JSON_KEY_SERVICE_STATUS, info.getServiceStatus());
            if (info.getServiceStatusStartingTime() != null) {
                jsonGenerator.writeStringField(LotlCacheDataV1.JSON_KEY_SERVICE_STATUS_STARTING_TIME, info.getServiceStatusStartingTime().format(DateTimeFormatter.ofPattern(LotlCacheDataV1.DATE_TIME_FORMATTER_PATTERN)));
            } else {
                jsonGenerator.writeNullField(LotlCacheDataV1.JSON_KEY_SERVICE_STATUS_STARTING_TIME);
            }
            if (info.getServiceExtensions() != null) {
                jsonGenerator.writeArrayFieldStart(LotlCacheDataV1.JSON_KEY_SERVICE_EXTENSIONS);
                for (AdditionalServiceInformationExtension additionalServiceInformationExtension : info.getServiceExtensions()) {
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeStringField(LotlCacheDataV1.JSON_KEY_URI, additionalServiceInformationExtension.getUri());
                    jsonGenerator.writeEndObject();
                }
                jsonGenerator.writeEndArray();
            } else {
                jsonGenerator.writeNullField(LotlCacheDataV1.JSON_KEY_SERVICE_EXTENSIONS);
            }
            jsonGenerator.writeArrayFieldStart(LotlCacheDataV1.JSON_KEY_QUALIFIER_EXTENSIONS);
            for (QualifierExtension qualifierExtension : info.getQualifierExtensions()) {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeArrayFieldStart(LotlCacheDataV1.JSON_KEY_QUALIFIERS);
                for (String qualifier : qualifierExtension.getQualifiers()) {
                    jsonGenerator.writeString(qualifier);
                }
                jsonGenerator.writeEndArray();
                ServiceChronologicalInfoSerializer.serializeCriteriaList(qualifierExtension.getCriteriaList(), jsonGenerator);
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndArray();
            jsonGenerator.writeEndObject();
        }

        private static void serializeCriteriaList(CriteriaList criteriaList, JsonGenerator jsonGenerator) throws IOException {
            if (criteriaList == null) {
                return;
            }
            jsonGenerator.writeFieldName(LotlCacheDataV1.JSON_KEY_CRITERIA_LIST);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField(LotlCacheDataV1.JSON_KEY_CRITERIA_ASSERT_VALUE, criteriaList.getAssertValue());
            jsonGenerator.writeArrayFieldStart(LotlCacheDataV1.JSON_KEY_CRITERIAS);
            for (Criteria criteria : criteriaList.getCriteriaList()) {
                jsonGenerator.writeStartObject();
                if (criteria instanceof CriteriaList) {
                    ServiceChronologicalInfoSerializer.serializeCriteriaList((CriteriaList)criteria, jsonGenerator);
                } else if (criteria instanceof CertSubjectDNAttributeCriteria) {
                    ServiceChronologicalInfoSerializer.writeStringList(LotlCacheDataV1.JSON_KEY_CRITERIA_CERT_SUBJECT_DN_ATTRIBUTE_CRITERIA, LotlCacheDataV1.JSON_KEY_CRITERIA_REQUIRED_ATTRIBUTE_IDS, ((CertSubjectDNAttributeCriteria)criteria).getRequiredAttributeIds(), jsonGenerator);
                } else if (criteria instanceof ExtendedKeyUsageCriteria) {
                    ServiceChronologicalInfoSerializer.writeStringList(LotlCacheDataV1.JSON_KEY_CRITERIA_EXTENDED_KEY_USAGE_CRITERIA, LotlCacheDataV1.JSON_KEY_CRITERIA_REQUIRED_EXTENDED_KEY_USAGES, ((ExtendedKeyUsageCriteria)criteria).getRequiredExtendedKeyUsages(), jsonGenerator);
                } else if (criteria instanceof KeyUsageCriteria) {
                    ArrayList<String> keyUsages = new ArrayList<String>();
                    for (Boolean keyUsage : ((KeyUsageCriteria)criteria).getKeyUsageBits()) {
                        if (keyUsage == null) {
                            keyUsages.add("null");
                            continue;
                        }
                        keyUsages.add(keyUsage != false ? "true" : "false");
                    }
                    ServiceChronologicalInfoSerializer.writeStringList(LotlCacheDataV1.JSON_KEY_CRITERIA_KEY_USAGE_CRITERIA, LotlCacheDataV1.JSON_KEY_CRITERIA_KEY_USAGE_BITS, keyUsages, jsonGenerator);
                } else if (criteria instanceof PolicySetCriteria) {
                    ServiceChronologicalInfoSerializer.writeStringList(LotlCacheDataV1.JSON_KEY_CRITERIA_POLICY_SET_CRITERIA, LotlCacheDataV1.JSON_KEY_CRITERIA_REQUIRED_POLICY_IDS, ((PolicySetCriteria)criteria).getRequiredPolicyIds(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndArray();
            jsonGenerator.writeEndObject();
        }

        private static void writeStringList(String parentFieldName, String arrayFieldName, List<String> stringList, JsonGenerator jsonGenerator) throws IOException {
            jsonGenerator.writeFieldName(parentFieldName);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeArrayFieldStart(arrayFieldName);
            for (String keyUsage : stringList) {
                jsonGenerator.writeString(keyUsage);
            }
            jsonGenerator.writeEndArray();
            jsonGenerator.writeEndObject();
        }
    }

    static class ReportItemDeserializer
    extends JsonDeserializer<ReportItem> {
        public ReportItem deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            ReportItem item;
            ObjectCodec codec = p.getCodec();
            JsonNode node = (JsonNode)codec.readTree(p);
            String checkName = node.has(LotlCacheDataV1.JSON_KEY_REPORT_ITEM_CHECKNAME) ? node.get(LotlCacheDataV1.JSON_KEY_REPORT_ITEM_CHECKNAME).asText() : null;
            String message = node.has(LotlCacheDataV1.JSON_KEY_REPORT_ITEM_MESSAGE) ? node.get(LotlCacheDataV1.JSON_KEY_REPORT_ITEM_MESSAGE).asText() : null;
            ReportItem.ReportItemStatus status = node.has(LotlCacheDataV1.JSON_KEY_REPORT_STATUS) ? ReportItem.ReportItemStatus.valueOf(node.get(LotlCacheDataV1.JSON_KEY_REPORT_STATUS).asText()) : null;
            Exception cause = null;
            if (node.has(LotlCacheDataV1.JSON_KEY_REPORT_CAUSE) && !node.get(LotlCacheDataV1.JSON_KEY_REPORT_CAUSE).isNull()) {
                JsonNode causeNode = node.get(LotlCacheDataV1.JSON_KEY_REPORT_CAUSE);
                cause = (Exception)codec.treeToValue((TreeNode)causeNode, Exception.class);
            }
            if (node.has(LotlCacheDataV1.JSON_KEY_CERTIFICATE) && !node.get(LotlCacheDataV1.JSON_KEY_CERTIFICATE).isNull()) {
                X509Certificate certificate = (X509Certificate)codec.treeToValue((TreeNode)node.get(LotlCacheDataV1.JSON_KEY_CERTIFICATE), X509Certificate.class);
                item = new CertificateReportItem(certificate, checkName, message, cause, status);
            } else {
                item = new ReportItem(checkName, message, cause, status);
            }
            return item;
        }
    }

    static class ValidationReportDeserializer
    extends JsonDeserializer<ValidationReport> {
        public ValidationReport deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            ObjectCodec codec = p.getCodec();
            JsonNode node = (JsonNode)codec.readTree(p);
            ValidationReport report = new ValidationReport();
            JsonNode itemsNode = node.get(LotlCacheDataV1.JSON_KEY_REPORT_ITEMS);
            if (itemsNode != null && itemsNode.isArray()) {
                for (JsonNode itemNode : itemsNode) {
                    ReportItem item = (ReportItem)codec.treeToValue((TreeNode)itemNode, ReportItem.class);
                    report.addReportItem(item);
                }
            }
            return report;
        }
    }

    static class X509CertificateDeserializer
    extends JsonDeserializer<X509Certificate> {
        public X509Certificate deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            ObjectCodec codec = p.getCodec();
            JsonNode node = (JsonNode)codec.readTree(p);
            String base64Encoded = node.get(LotlCacheDataV1.JSON_KEY_BASE64_ENCODED).asText();
            byte[] decoded = Base64.getDecoder().decode(base64Encoded);
            try {
                return (X509Certificate)CertificateUtil.generateCertificate(new ByteArrayInputStream(decoded));
            }
            catch (CertificateException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class LotlCacheDataV1Serializer
    extends JsonSerializer<LotlCacheDataV1> {
        public void serialize(LotlCacheDataV1 lotlCacheData, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeObjectField(LotlCacheDataV1.JSON_KEY_LOTL_CACHE, (Object)lotlCacheData.getLotlCache());
            jsonGenerator.writeObjectField(LotlCacheDataV1.JSON_KEY_EUROPEAN_RESOURCE_FETCHER_CACHE, (Object)lotlCacheData.getEuropeanResourceFetcherCache());
            jsonGenerator.writeObjectField(LotlCacheDataV1.JSON_KEY_PIVOT_CACHE, (Object)lotlCacheData.getPivotCache());
            if (lotlCacheData.getCountrySpecificLotlCache() != null) {
                jsonGenerator.writeObjectFieldStart(LotlCacheDataV1.JSON_KEY_COUNTRY_SPECIFIC_LOTL_CACHE);
                ArrayList<String> keys = new ArrayList<String>(lotlCacheData.getCountrySpecificLotlCache().keySet());
                Collections.sort(keys);
                for (String key : keys) {
                    CountrySpecificLotlFetcher.Result entry = lotlCacheData.getCountrySpecificLotlCache().get(key);
                    jsonGenerator.writeObjectField(key, (Object)entry);
                }
                jsonGenerator.writeEndObject();
            } else {
                jsonGenerator.writeNullField(LotlCacheDataV1.JSON_KEY_COUNTRY_SPECIFIC_LOTL_CACHE);
            }
            if (lotlCacheData.getTimeStamps() != null) {
                jsonGenerator.writeObjectFieldStart(LotlCacheDataV1.JSON_KEY_TIME_STAMPS);
                for (Map.Entry<String, Long> entry : lotlCacheData.getTimeStamps().entrySet()) {
                    jsonGenerator.writeNumberField(entry.getKey(), entry.getValue().longValue());
                }
                jsonGenerator.writeEndObject();
            } else {
                jsonGenerator.writeNullField(LotlCacheDataV1.JSON_KEY_TIME_STAMPS);
            }
            jsonGenerator.writeEndObject();
        }
    }
}

