/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.lotl;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.signatures.validation.SafeCalling;
import com.itextpdf.signatures.validation.TrustedCertificatesStore;
import com.itextpdf.signatures.validation.lotl.LotlService;
import com.itextpdf.signatures.validation.lotl.XmlCertificateRetriever;
import com.itextpdf.signatures.validation.lotl.XmlDefaultCertificateHandler;
import com.itextpdf.signatures.validation.lotl.XmlPivotsHandler;
import com.itextpdf.signatures.validation.lotl.XmlSignatureValidator;
import com.itextpdf.signatures.validation.lotl.xml.XmlSaxProcessor;
import com.itextpdf.signatures.validation.report.ReportItem;
import com.itextpdf.signatures.validation.report.ValidationReport;
import java.io.ByteArrayInputStream;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PivotFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(PivotFetcher.class);
    private final LotlService service;
    private String currentJournalUri;

    public PivotFetcher(LotlService service) {
        this.service = service;
    }

    public void setCurrentJournalUri(String currentJournalUri) {
        this.currentJournalUri = currentJournalUri;
    }

    public Result downloadAndValidatePivotFiles(byte[] lotlXml, List<Certificate> certificates) {
        if (lotlXml == null) {
            throw new PdfException("Unable to retrieve main Lotl file. Lotl validation isn't successful.");
        }
        Result result = new Result();
        List<String> pivotsUrlList = this.getPivotsUrlList(lotlXml);
        List ojUris = pivotsUrlList.stream().filter(url -> XmlPivotsHandler.isOfficialJournal(url)).collect(Collectors.toList());
        if (ojUris.size() > 1) {
            LOGGER.warn("Main LOTL file contains two Official Journal of European Union links. This usually indicates that transition period for Official Journal has started. Newest version of Official Journal should be used from now on to retrieve trusted certificates and LOTL location.");
        }
        result.setPivotUrls(pivotsUrlList);
        ArrayList<byte[]> pivotFiles = new ArrayList<byte[]>();
        boolean startProcessing = ojUris.isEmpty() || this.currentJournalUri == null;
        for (int i = pivotsUrlList.size() - 1; i >= 0; --i) {
            String pivotUrl = pivotsUrlList.get(i);
            if (pivotUrl.equals(this.currentJournalUri)) {
                startProcessing = true;
                continue;
            }
            if (!startProcessing || XmlPivotsHandler.isOfficialJournal(pivotUrl)) continue;
            SafeCalling.onExceptionLog(() -> pivotFiles.add(this.service.getResourceRetriever().getByteArrayByUrl(new URL(pivotUrl))), result.getLocalReport(), e -> new ReportItem("Lotl validation.", MessageFormatUtil.format((String)"Unable to retrieve pivot Lotl with {0} url. Lotl validation isn't successful.", (Object[])new Object[]{pivotUrl}), (Exception)e, ReportItem.ReportItemStatus.INVALID));
            if (result.getLocalReport().getValidationResult() == ValidationReport.ValidationResult.VALID) continue;
            return result;
        }
        List<Certificate> trustedCertificates = certificates;
        pivotFiles.add(lotlXml);
        for (byte[] pivotFile : pivotFiles) {
            TrustedCertificatesStore trustedCertificatesStore = new TrustedCertificatesStore();
            trustedCertificatesStore.addGenerallyTrustedCertificates(trustedCertificates);
            if (pivotFile == null) {
                result.getLocalReport().addReportItem(new ReportItem("Lotl validation.", "Lotl chain validation wasn't successful, trusted certificates were not parsed.", ReportItem.ReportItemStatus.INVALID));
                return result;
            }
            XmlSignatureValidator xmlSignatureValidator = this.service.getXmlSignatureValidator(trustedCertificatesStore);
            ValidationReport localReport = xmlSignatureValidator.validate(new ByteArrayInputStream(pivotFile));
            if (localReport.getValidationResult() != ValidationReport.ValidationResult.VALID) {
                result.getLocalReport().addReportItem(new ReportItem("Lotl validation.", "Lotl chain validation wasn't successful, trusted certificates were not parsed.", ReportItem.ReportItemStatus.INVALID));
                result.getLocalReport().merge(localReport);
                if (!ojUris.stream().anyMatch(ojUri -> ojUri.equals(this.currentJournalUri))) {
                    throw new PdfException("Trusted certificates from Official Journal of European Union are outdated. LOTL file cannot be validated. Please, provide OJ certificates, which match the ones used to sign European Union List of Trusted Lists.");
                }
                return result;
            }
            XmlCertificateRetriever certificateRetriever = new XmlCertificateRetriever(new XmlDefaultCertificateHandler());
            trustedCertificates = certificateRetriever.getCertificates(new ByteArrayInputStream(pivotFile));
        }
        return result;
    }

    protected List<String> getPivotsUrlList(byte[] lotlXml) {
        XmlPivotsHandler pivotsHandler = new XmlPivotsHandler();
        new XmlSaxProcessor().process(new ByteArrayInputStream(lotlXml), pivotsHandler);
        return pivotsHandler.getPivots();
    }

    public static class Result {
        private ValidationReport localReport = new ValidationReport();
        private List<String> pivotsUrlList = new ArrayList<String>();

        public ValidationReport getLocalReport() {
            return this.localReport;
        }

        public void setLocalReport(ValidationReport localReport) {
            this.localReport = localReport;
        }

        public List<String> getPivotUrls() {
            return Collections.unmodifiableList(this.pivotsUrlList);
        }

        public void setPivotUrls(List<String> pivotsUrlList) {
            this.pivotsUrlList = pivotsUrlList;
        }

        public String generateUniqueIdentifier() {
            return String.join((CharSequence)"_", this.pivotsUrlList);
        }
    }
}

