/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.lotl;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Encodable;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Sequence;
import com.itextpdf.commons.bouncycastle.asn1.x509.qualified.IQCStatement;
import com.itextpdf.commons.utils.DateTimeUtil;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.signatures.CertificateUtil;
import com.itextpdf.signatures.validation.context.CertificateSource;
import com.itextpdf.signatures.validation.context.ValidationContext;
import com.itextpdf.signatures.validation.lotl.CountryServiceContext;
import com.itextpdf.signatures.validation.lotl.QualifierExtension;
import com.itextpdf.signatures.validation.lotl.ServiceChronologicalInfo;
import com.itextpdf.signatures.validation.report.ReportItem;
import com.itextpdf.signatures.validation.report.ValidationReport;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class QualifiedValidator {
    private static final IBouncyCastleFactory FACTORY = BouncyCastleFactoryCreator.getFactory();
    private static final Date EIDAS = DateTimeUtil.createUtcDateTime((int)2016, (int)5, (int)30, (int)22, (int)0, (int)0);
    static final String QUALIFICATION_CHECK = "Qualification check.";
    static final String NOT_ACCREDITED_STATUS = "Trusted Certificate {0} is not considered to be qualified, because it's status is not \"Accredited\", \"Under Supervision\" or \"Supervision in Cessation\".";
    static final String NOT_GRANTED_STATUS = "Trusted Certificate {0} is not considered to be qualified, because it's status is not \"Granted\".";
    static final String CONTRADICTING_QSCD = "Trusted Certificate {0} is not considered to be created by a Qualified Signature Creation Device, because it has contradicting QC_XX_QSCD Qualifier values.";
    static final String CONTRADICTING_QC_FOR = "Trusted Certificate {0} type is not identifiable, because it has contradicting QCFor_XX Qualifier values.";
    static final String CONTRADICTING_QC_STATEMENT = "Trusted Certificate {0} is not considered to be qualified, because it has contradicting QC Statement Qualifier values.";
    static final String QC_WSA = "Trusted Certificate {0} is not considered to be qualified, because it has QCForWSA Qualifier value.";
    static final String QC_TYPE_WSA = "Certificate {0} is not considered to be qualified, because it has WSA value in the QcType certificate extension.";
    static final String EXCEPTION_STATEMENT_PARSING = "Exception thrown during Certificate {0} QC Statement extension parsing. The conclusion will be made as if this extension is missing.";
    static final String CONTRADICTING_QC_TYPE = "Certificate {0} has contradicting QcType extension values. The conclusion will be made as if this extension is missing.";
    static final String CERT_NOT_QUALIFIED = "Certificate {0} is not qualified according to the corresponding Trusted List Qualifier Extensions and Certificate Extensions.";
    static final String NOT_QSCD = "Certificate {0} is qualified, but it's private key doesn't reside in Qualified Signature Creation device.";
    static final String TYPE_UNDEFINED = "Certificate {0} type (either eSig or eSeal) cannot be defined.";
    static final String TYPE_CONTRADICTS_WITH_SI = "Certificate {0} type (either eSig or eSeal) contradicts with the type provided in Additional Service Information extension value.";
    static final String CERTIFICATE_VALIDATION_EXCEPTION = "Exception occurred while validating qualification status of a {0} certificate.";
    static final String MULTIPLE_CA_QC_ENTRIES = "Multiple CA/QC entries correspond to the given signing certificate and their conclusions on qualification status are different.";
    private static final String QC_WITH_QSCD = "QcWithQSCD";
    private static final String NO_QSCD = "QcNoQSCD";
    private static final String QSCD_MANAGED_ON_BEHALF = "QCQSCDManagedOnBehalf";
    private static final String QSCD_STATUS_AS_IN_CERT = "QcQSCDStatusAsInCert";
    private static final String QC_STATEMENTS_EXTENSION = "1.3.6.1.5.5.7.1.3";
    private static final String QC_COMPLIANCE_EXTENSION = "0.4.0.1862.1.1";
    private static final String QSCD_EXTENSION = "0.4.0.1862.1.4";
    private static final String QUALIFIED_TYPE_EXTENSION = "0.4.0.1862.1.6";
    private static final String ESIG_TYPE_EXTENSION = "0.4.0.1862.1.6.1";
    private static final String ESEAL_TYPE_EXTENSION = "0.4.0.1862.1.6.2";
    private static final String WSA_TYPE_EXTENSION = "0.4.0.1862.1.6.3";
    private static final String CERTIFICATE_POLICIES_EXTENSION = "2.5.29.32";
    private static final String QCP_EXTENSION = "0.4.0.1456.1.2";
    private static final String QCP_PLUS_EXTENSION = "0.4.0.1456.1.1";
    private final Map<String, QualificationValidationData> signaturesValidationResults = new HashMap<String, QualificationValidationData>();
    private QualificationValidationData signatureValidationData;
    private QualificationValidationData currentValidationData;

    public QualificationValidationData obtainQualificationValidationResultForSignature(String signatureName) {
        return this.signaturesValidationResults.remove(signatureName);
    }

    public Map<String, QualificationValidationData> obtainAllSignaturesValidationResults() {
        HashMap<String, QualificationValidationData> results = new HashMap<String, QualificationValidationData>(this.signaturesValidationResults);
        this.signaturesValidationResults.clear();
        return results;
    }

    public void startSignatureValidation(String signatureName) {
        this.signatureValidationData = new QualificationValidationData();
        this.signaturesValidationResults.put(signatureName, this.signatureValidationData);
    }

    public void ensureValidatorIsEmpty() {
        if (!this.signaturesValidationResults.isEmpty()) {
            throw new PdfException("QualifiedValidator instance has to be created from scratch per each validated document. Alternatively, one can obtain previous validation results by using QualifiedValidator#obtainAllSignaturesValidationResults() before running the validation process for the next document.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSignatureQualification(List<X509Certificate> previousCertificates, CountryServiceContext currentContext, X509Certificate trustedCertificate, Date validationDate, ValidationContext context) {
        this.currentValidationData = new QualificationValidationData();
        try {
            FinalQualificationData finalDataAtIssuing;
            FinalQualificationData finalDataAtSigning;
            if (!QualifiedValidator.getQualifiedServiceTypes().contains(currentContext.getServiceType())) {
                this.currentValidationData.qualificationConclusion = QualificationConclusion.NOT_CATCHING;
                return;
            }
            if (ValidationContext.checkIfContextChainContainsCertificateSource(context, CertificateSource.OCSP_ISSUER) || ValidationContext.checkIfContextChainContainsCertificateSource(context, CertificateSource.CRL_ISSUER) || ValidationContext.checkIfContextChainContainsCertificateSource(context, CertificateSource.TIMESTAMP)) {
                return;
            }
            if (!"http://uri.etsi.org/TrstSvc/Svctype/CA/QC".equals(currentContext.getServiceType())) {
                this.currentValidationData.qualificationConclusion = QualificationConclusion.NOT_CATCHING;
                return;
            }
            X509Certificate signCert = previousCertificates.isEmpty() ? trustedCertificate : previousCertificates.get(0);
            String trustedCertificateName = trustedCertificate.getSubjectX500Principal().getName();
            try {
                finalDataAtSigning = this.isCertificateQualified(signCert, trustedCertificateName, currentContext, validationDate);
                finalDataAtIssuing = this.isCertificateQualified(signCert, trustedCertificateName, currentContext, signCert.getNotBefore());
            }
            catch (Exception e) {
                this.addReportItem(new ReportItem(QUALIFICATION_CHECK, MessageFormatUtil.format((String)CERTIFICATE_VALIDATION_EXCEPTION, (Object[])new Object[]{signCert.getSubjectX500Principal()}), e, ReportItem.ReportItemStatus.INFO));
                this.currentValidationData.qualificationConclusion = QualificationConclusion.NOT_CATCHING;
                this.updateSignatureQualification();
                return;
            }
            if (this.currentValidationData.qualificationConclusion == QualificationConclusion.NOT_CATCHING) {
                return;
            }
            boolean finalQualification = finalDataAtSigning.finalQualification == finalDataAtIssuing.finalQualification ? finalDataAtSigning.finalQualification : false;
            boolean finalQualifiedCreationDevice = finalDataAtSigning.finalQualifiedCreationDevice;
            CertificateType finalCertType = finalDataAtSigning.finalCertType == finalDataAtIssuing.finalCertType ? finalDataAtSigning.finalCertType : CertificateType.UNDEFINED;
            if (finalCertType == CertificateType.WSA) {
                this.currentValidationData.qualificationConclusion = QualificationConclusion.NOT_QUALIFIED;
                return;
            }
            if (finalQualification) {
                if (finalQualifiedCreationDevice) {
                    if (finalCertType == CertificateType.E_SIG) {
                        this.currentValidationData.qualificationConclusion = QualificationConclusion.ESIG_WITH_QC_AND_QSCD;
                    } else if (finalCertType == CertificateType.E_SEAL) {
                        this.currentValidationData.qualificationConclusion = QualificationConclusion.ESEAL_WITH_QC_AND_QSCD;
                    } else if (finalCertType == CertificateType.INCOHERENT) {
                        this.currentValidationData.qualificationConclusion = QualificationConclusion.UNKNOWN_QC_AND_QSCD;
                    } else {
                        this.addReportItem(new ReportItem(QUALIFICATION_CHECK, MessageFormatUtil.format((String)TYPE_UNDEFINED, (Object[])new Object[]{signCert.getSubjectX500Principal()}), ReportItem.ReportItemStatus.INFO));
                        this.currentValidationData.qualificationConclusion = QualificationConclusion.UNKNOWN_QC_AND_QSCD;
                    }
                } else {
                    this.addReportItem(new ReportItem(QUALIFICATION_CHECK, MessageFormatUtil.format((String)NOT_QSCD, (Object[])new Object[]{signCert.getSubjectX500Principal()}), ReportItem.ReportItemStatus.INFO));
                    if (finalCertType == CertificateType.E_SIG) {
                        this.currentValidationData.qualificationConclusion = QualificationConclusion.ESIG_WITH_QC;
                    } else if (finalCertType == CertificateType.E_SEAL) {
                        this.currentValidationData.qualificationConclusion = QualificationConclusion.ESEAL_WITH_QC;
                    } else if (finalCertType == CertificateType.INCOHERENT) {
                        this.currentValidationData.qualificationConclusion = QualificationConclusion.UNKNOWN_QC;
                    } else {
                        this.addReportItem(new ReportItem(QUALIFICATION_CHECK, MessageFormatUtil.format((String)TYPE_UNDEFINED, (Object[])new Object[]{signCert.getSubjectX500Principal()}), ReportItem.ReportItemStatus.INFO));
                        this.currentValidationData.qualificationConclusion = QualificationConclusion.UNKNOWN_QC;
                    }
                }
            } else {
                this.addReportItem(new ReportItem(QUALIFICATION_CHECK, MessageFormatUtil.format((String)CERT_NOT_QUALIFIED, (Object[])new Object[]{signCert.getSubjectX500Principal()}), ReportItem.ReportItemStatus.INFO));
                if (finalCertType == CertificateType.E_SIG) {
                    this.currentValidationData.qualificationConclusion = QualificationConclusion.NOT_QUALIFIED_ESIG;
                } else if (finalCertType == CertificateType.E_SEAL) {
                    this.currentValidationData.qualificationConclusion = QualificationConclusion.NOT_QUALIFIED_ESEAL;
                } else if (finalCertType == CertificateType.INCOHERENT) {
                    this.currentValidationData.qualificationConclusion = QualificationConclusion.UNKNOWN;
                } else {
                    this.addReportItem(new ReportItem(QUALIFICATION_CHECK, MessageFormatUtil.format((String)TYPE_UNDEFINED, (Object[])new Object[]{signCert.getSubjectX500Principal()}), ReportItem.ReportItemStatus.INFO));
                    this.currentValidationData.qualificationConclusion = QualificationConclusion.NOT_QUALIFIED;
                }
            }
        }
        finally {
            this.updateSignatureQualification();
        }
    }

    private static Set<String> getQualifiedServiceTypes() {
        HashSet<String> qualifiedServiceTypes = new HashSet<String>();
        qualifiedServiceTypes.add("http://uri.etsi.org/TrstSvc/Svctype/CA/QC");
        qualifiedServiceTypes.add("http://uri.etsi.org/TrstSvc/Svctype/Certstatus/OCSP/QC");
        qualifiedServiceTypes.add("http://uri.etsi.org/TrstSvc/Svctype/Certstatus/CRL/QC");
        qualifiedServiceTypes.add("http://uri.etsi.org/TrstSvc/Svctype/TSA/QTST");
        qualifiedServiceTypes.add("http://uri.etsi.org/TrstSvc/Svctype/EDS/Q");
        qualifiedServiceTypes.add("http://uri.etsi.org/TrstSvc/Svctype/EDS/REM/Q");
        qualifiedServiceTypes.add("http://uri.etsi.org/TrstSvc/Svctype/PSES/Q");
        qualifiedServiceTypes.add("http://uri.etsi.org/TrstSvc/Svctype/QESValidation/Q");
        qualifiedServiceTypes.add("http://uri.etsi.org/TrstSvc/Svctype/RemoteQSigCDManagement/Q");
        qualifiedServiceTypes.add("http://uri.etsi.org/TrstSvc/Svctype/RemoteQSealCDManagement/Q");
        qualifiedServiceTypes.add("http://uri.etsi.org/TrstSvc/Svctype/EAA/Q");
        qualifiedServiceTypes.add("http://uri.etsi.org/TrstSvc/Svctype/ElectronicArchiving/Q");
        qualifiedServiceTypes.add("http://uri.etsi.org/TrstSvc/Svctype/Ledgers/Q");
        qualifiedServiceTypes.add("http://uri.etsi.org/TrstSvc/Svctype/TSA/TSS-QC");
        qualifiedServiceTypes.add("http://uri.etsi.org/TrstSvc/Svctype/TSA/TSS-AdESQCandQES");
        return qualifiedServiceTypes;
    }

    private boolean checkServiceStatus(ServiceChronologicalInfo chronologicalInfo, boolean isBeforeEIDAS, String trustedCertificateName) {
        String serviceStatus = chronologicalInfo.getServiceStatus();
        if (isBeforeEIDAS) {
            if (!("http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/accredited".equals(serviceStatus) || "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/undersupervision".equals(serviceStatus) || "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/supervisionincessation".equals(serviceStatus))) {
                this.addReportItem(new ReportItem(QUALIFICATION_CHECK, MessageFormatUtil.format((String)NOT_ACCREDITED_STATUS, (Object[])new Object[]{trustedCertificateName}), ReportItem.ReportItemStatus.INFO));
                return false;
            }
        } else if (!"http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/granted".equals(serviceStatus)) {
            this.addReportItem(new ReportItem(QUALIFICATION_CHECK, MessageFormatUtil.format((String)NOT_GRANTED_STATUS, (Object[])new Object[]{trustedCertificateName}), ReportItem.ReportItemStatus.INFO));
            return false;
        }
        return true;
    }

    private Boolean parseQualifiedCreationDeviceOverrule(List<String> applicableQualifiers, String trustedCertificateName, boolean isBeforeEidas) {
        String qualifiedCreationDeviceTL = null;
        Boolean qualifiedCreationDeviceOverrule = null;
        List modifiedQualifiers = isBeforeEidas ? applicableQualifiers.stream().filter(applicableQualifier -> applicableQualifier.contains("SSCD")).collect(Collectors.toList()) : applicableQualifiers.stream().filter(applicableQualifier -> applicableQualifier.contains("QSCD")).collect(Collectors.toList());
        for (String applicableQualifier2 : modifiedQualifiers) {
            String qualifier;
            switch (qualifier = applicableQualifier2.replace("SSCD", "QSCD")) {
                case "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCQSCDManagedOnBehalf": {
                    if (NO_QSCD.equals(qualifiedCreationDeviceTL) || QSCD_STATUS_AS_IN_CERT.equals(qualifiedCreationDeviceTL)) {
                        this.addReportItem(new ReportItem(QUALIFICATION_CHECK, MessageFormatUtil.format((String)CONTRADICTING_QSCD, (Object[])new Object[]{trustedCertificateName}), ReportItem.ReportItemStatus.INFO));
                        return false;
                    }
                    qualifiedCreationDeviceTL = QSCD_MANAGED_ON_BEHALF;
                    qualifiedCreationDeviceOverrule = true;
                    break;
                }
                case "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCQSCDStatusAsInCert": {
                    if (NO_QSCD.equals(qualifiedCreationDeviceTL) || QSCD_MANAGED_ON_BEHALF.equals(qualifiedCreationDeviceTL) || QC_WITH_QSCD.equals(qualifiedCreationDeviceTL)) {
                        this.addReportItem(new ReportItem(QUALIFICATION_CHECK, MessageFormatUtil.format((String)CONTRADICTING_QSCD, (Object[])new Object[]{trustedCertificateName}), ReportItem.ReportItemStatus.INFO));
                        return false;
                    }
                    qualifiedCreationDeviceTL = QSCD_STATUS_AS_IN_CERT;
                    break;
                }
                case "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCWithQSCD": {
                    if (NO_QSCD.equals(qualifiedCreationDeviceTL) || QSCD_STATUS_AS_IN_CERT.equals(qualifiedCreationDeviceTL)) {
                        this.addReportItem(new ReportItem(QUALIFICATION_CHECK, MessageFormatUtil.format((String)CONTRADICTING_QSCD, (Object[])new Object[]{trustedCertificateName}), ReportItem.ReportItemStatus.INFO));
                        return false;
                    }
                    qualifiedCreationDeviceTL = QC_WITH_QSCD;
                    qualifiedCreationDeviceOverrule = true;
                    break;
                }
                case "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCNoQSCD": {
                    if (QC_WITH_QSCD.equals(qualifiedCreationDeviceTL) || QSCD_STATUS_AS_IN_CERT.equals(qualifiedCreationDeviceTL) || QSCD_MANAGED_ON_BEHALF.equals(qualifiedCreationDeviceTL)) {
                        this.addReportItem(new ReportItem(QUALIFICATION_CHECK, MessageFormatUtil.format((String)CONTRADICTING_QSCD, (Object[])new Object[]{trustedCertificateName}), ReportItem.ReportItemStatus.INFO));
                        return false;
                    }
                    qualifiedCreationDeviceTL = NO_QSCD;
                    qualifiedCreationDeviceOverrule = false;
                }
            }
        }
        return qualifiedCreationDeviceOverrule;
    }

    private Boolean parseCertificateQualificationOverrule(List<String> applicableQualifiers, String trustedCertificateName) {
        Boolean certQualificationOverrule = null;
        Iterator<String> iterator = applicableQualifiers.iterator();
        while (iterator.hasNext()) {
            String applicableQualifier;
            switch (applicableQualifier = iterator.next()) {
                case "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCStatement": {
                    if (Boolean.FALSE.equals(certQualificationOverrule)) {
                        this.addReportItem(new ReportItem(QUALIFICATION_CHECK, MessageFormatUtil.format((String)CONTRADICTING_QC_STATEMENT, (Object[])new Object[]{trustedCertificateName}), ReportItem.ReportItemStatus.INFO));
                        return false;
                    }
                    certQualificationOverrule = true;
                    break;
                }
                case "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/NotQualified": {
                    if (Boolean.TRUE.equals(certQualificationOverrule)) {
                        this.addReportItem(new ReportItem(QUALIFICATION_CHECK, MessageFormatUtil.format((String)CONTRADICTING_QC_STATEMENT, (Object[])new Object[]{trustedCertificateName}), ReportItem.ReportItemStatus.INFO));
                        return false;
                    }
                    certQualificationOverrule = false;
                }
            }
        }
        return certQualificationOverrule;
    }

    private CertificateType parseCertTypeOverrule(List<String> applicableQualifiers, String trustedCertificateName) {
        CertificateType certTypeOverrule = CertificateType.UNDEFINED;
        Iterator<String> iterator = applicableQualifiers.iterator();
        while (iterator.hasNext()) {
            String applicableQualifier;
            switch (applicableQualifier = iterator.next()) {
                case "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCForESig": {
                    if (certTypeOverrule == CertificateType.E_SEAL) {
                        this.addReportItem(new ReportItem(QUALIFICATION_CHECK, MessageFormatUtil.format((String)CONTRADICTING_QC_FOR, (Object[])new Object[]{trustedCertificateName}), ReportItem.ReportItemStatus.INFO));
                        return CertificateType.INCOHERENT;
                    }
                    certTypeOverrule = CertificateType.E_SIG;
                    break;
                }
                case "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCForESeal": 
                case "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCForLegalPerson": {
                    if (certTypeOverrule == CertificateType.E_SIG) {
                        this.addReportItem(new ReportItem(QUALIFICATION_CHECK, MessageFormatUtil.format((String)CONTRADICTING_QC_FOR, (Object[])new Object[]{trustedCertificateName}), ReportItem.ReportItemStatus.INFO));
                        return CertificateType.INCOHERENT;
                    }
                    certTypeOverrule = CertificateType.E_SEAL;
                    break;
                }
                case "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCForWSA": {
                    this.addReportItem(new ReportItem(QUALIFICATION_CHECK, MessageFormatUtil.format((String)QC_WSA, (Object[])new Object[]{trustedCertificateName}), ReportItem.ReportItemStatus.INFO));
                    return CertificateType.WSA;
                }
            }
        }
        return certTypeOverrule;
    }

    private CertificateType parseTypeFromCertificate(List<IQCStatement> qcStatements, X509Certificate certificate) {
        CertificateType certType = CertificateType.UNDEFINED;
        for (IQCStatement qcStatement : qcStatements) {
            if (!QUALIFIED_TYPE_EXTENSION.equals(qcStatement.getStatementId().getId())) continue;
            IASN1Encodable qcType = qcStatement.getStatementInfo();
            IASN1Sequence typeSequence = FACTORY.createASN1Sequence(qcType);
            List typeIds = Arrays.stream(typeSequence.toArray()).map(type -> FACTORY.createASN1ObjectIdentifier(type).getId()).collect(Collectors.toList());
            Iterator iterator = typeIds.iterator();
            while (iterator.hasNext()) {
                String typeId;
                switch (typeId = (String)iterator.next()) {
                    case "0.4.0.1862.1.6.1": {
                        if (certType != CertificateType.UNDEFINED && certType != CertificateType.E_SIG) {
                            this.addReportItem(new ReportItem(QUALIFICATION_CHECK, MessageFormatUtil.format((String)CONTRADICTING_QC_TYPE, (Object[])new Object[]{certificate.getSubjectX500Principal()}), ReportItem.ReportItemStatus.INFO));
                            return CertificateType.INCOHERENT;
                        }
                        certType = CertificateType.E_SIG;
                        break;
                    }
                    case "0.4.0.1862.1.6.2": {
                        if (certType != CertificateType.UNDEFINED && certType != CertificateType.E_SEAL) {
                            this.addReportItem(new ReportItem(QUALIFICATION_CHECK, MessageFormatUtil.format((String)CONTRADICTING_QC_TYPE, (Object[])new Object[]{certificate.getSubjectX500Principal()}), ReportItem.ReportItemStatus.INFO));
                            return CertificateType.INCOHERENT;
                        }
                        certType = CertificateType.E_SEAL;
                        break;
                    }
                    case "0.4.0.1862.1.6.3": {
                        this.addReportItem(new ReportItem(QUALIFICATION_CHECK, MessageFormatUtil.format((String)QC_TYPE_WSA, (Object[])new Object[]{certificate.getSubjectX500Principal()}), ReportItem.ReportItemStatus.INFO));
                        return CertificateType.WSA;
                    }
                }
            }
        }
        return certType;
    }

    private FinalQualificationData isCertificateQualified(X509Certificate certificate, String trustedCertificateName, CountryServiceContext countryServiceContext, Date date) {
        ServiceChronologicalInfo chronologicalInfo = countryServiceContext.getServiceChronologicalInfoByDate(DateTimeUtil.getRelativeTime((Date)date));
        boolean isBeforeEIDAS = date.before(EIDAS);
        List<QualifierExtension> qualifiers = chronologicalInfo.getQualifierExtensions();
        ArrayList<String> applicableQualifiers = new ArrayList<String>();
        for (QualifierExtension qualifier : qualifiers) {
            if (!qualifier.checkCriteria(certificate)) continue;
            applicableQualifiers.addAll(qualifier.getQualifiers());
        }
        CertificateType certTypeOverrule = CertificateType.UNDEFINED;
        if (!isBeforeEIDAS) {
            certTypeOverrule = this.parseCertTypeOverrule(applicableQualifiers, trustedCertificateName);
        }
        if (certTypeOverrule == CertificateType.WSA) {
            return new FinalQualificationData(false, false, certTypeOverrule);
        }
        Boolean certQualificationOverrule = this.parseCertificateQualificationOverrule(applicableQualifiers, trustedCertificateName);
        Boolean qualifiedCreationDeviceOverrule = this.parseQualifiedCreationDeviceOverrule(applicableQualifiers, trustedCertificateName, isBeforeEIDAS);
        byte[] qcStatementsExtensionValue = CertificateUtil.getExtensionValueByOid(certificate, QC_STATEMENTS_EXTENSION);
        List qcStatements = null;
        try {
            qcStatements = FACTORY.parseQcStatement(qcStatementsExtensionValue);
        }
        catch (Exception e) {
            this.addReportItem(new ReportItem(QUALIFICATION_CHECK, MessageFormatUtil.format((String)EXCEPTION_STATEMENT_PARSING, (Object[])new Object[]{certificate.getSubjectX500Principal()}), e, ReportItem.ReportItemStatus.INFO));
        }
        Boolean certificateQualification = null;
        Boolean qualifiedCreationDevice = null;
        CertificateType certType = CertificateType.UNDEFINED;
        if (qcStatements != null) {
            for (IQCStatement qcStatement : qcStatements) {
                switch (qcStatement.getStatementId().getId()) {
                    case "0.4.0.1862.1.1": {
                        certificateQualification = true;
                        break;
                    }
                    case "0.4.0.1862.1.4": {
                        qualifiedCreationDevice = true;
                    }
                }
            }
            certType = this.parseTypeFromCertificate(qcStatements, certificate);
        }
        if (certType == CertificateType.WSA) {
            return new FinalQualificationData(false, false, certType);
        }
        if (isBeforeEIDAS) {
            try {
                byte[] policyIdExtension = CertificateUtil.getExtensionValueByOid(certificate, CERTIFICATE_POLICIES_EXTENSION);
                if (policyIdExtension != null) {
                    List policyIds = FACTORY.getPoliciesIds(policyIdExtension);
                    for (String policyId : policyIds) {
                        if (QCP_EXTENSION.equals(policyId)) {
                            certificateQualification = true;
                        }
                        if (!QCP_PLUS_EXTENSION.equals(policyId)) continue;
                        certificateQualification = true;
                        qualifiedCreationDevice = true;
                    }
                }
            }
            catch (Exception e) {
                this.addReportItem(new ReportItem(QUALIFICATION_CHECK, MessageFormatUtil.format((String)EXCEPTION_STATEMENT_PARSING, (Object[])new Object[]{certificate.getSubjectX500Principal()}), e, ReportItem.ReportItemStatus.INFO));
            }
        }
        boolean finalQualification = certQualificationOverrule != null ? certQualificationOverrule : (certificateQualification != null ? certificateQualification : false);
        boolean finalQualifiedCreationDevice = qualifiedCreationDeviceOverrule != null ? qualifiedCreationDeviceOverrule : (qualifiedCreationDevice != null ? qualifiedCreationDevice : false);
        CertificateType finalCertType = certTypeOverrule != CertificateType.UNDEFINED && finalQualification ? certTypeOverrule : (certType != CertificateType.UNDEFINED ? certType : (Boolean.TRUE.equals(certificateQualification) ? CertificateType.E_SIG : CertificateType.UNDEFINED));
        if (!isBeforeEIDAS) {
            List serviceExtensions = chronologicalInfo.getServiceExtensions().stream().map(serviceExtension -> serviceExtension.getUri()).collect(Collectors.toList());
            if (finalCertType == CertificateType.E_SEAL) {
                if (!serviceExtensions.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForeSeals")) {
                    this.addReportItem(new ReportItem(QUALIFICATION_CHECK, MessageFormatUtil.format((String)TYPE_CONTRADICTS_WITH_SI, (Object[])new Object[]{certificate.getSubjectX500Principal()}), ReportItem.ReportItemStatus.INFO));
                    this.currentValidationData.qualificationConclusion = QualificationConclusion.NOT_CATCHING;
                    finalQualification = false;
                }
            } else if (!(finalCertType != CertificateType.E_SIG && finalCertType != CertificateType.UNDEFINED || serviceExtensions.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForeSignatures"))) {
                this.addReportItem(new ReportItem(QUALIFICATION_CHECK, MessageFormatUtil.format((String)TYPE_CONTRADICTS_WITH_SI, (Object[])new Object[]{certificate.getSubjectX500Principal()}), ReportItem.ReportItemStatus.INFO));
                this.currentValidationData.qualificationConclusion = QualificationConclusion.NOT_CATCHING;
                finalQualification = false;
            }
        }
        if (!this.checkServiceStatus(chronologicalInfo, isBeforeEIDAS, trustedCertificateName)) {
            finalQualification = false;
        }
        return new FinalQualificationData(finalQualification, finalQualifiedCreationDevice, finalCertType);
    }

    private void updateSignatureQualification() {
        if (this.signatureValidationData == null) {
            throw new PdfException("Signature validation name needs to be provided with QualifiedValidator#startSignatureValidation method.");
        }
        if (this.signatureValidationData.qualificationConclusion == null || this.signatureValidationData.qualificationConclusion == QualificationConclusion.NOT_CATCHING) {
            this.signatureValidationData.qualificationConclusion = this.currentValidationData.qualificationConclusion;
            this.signatureValidationData.validationReport = this.currentValidationData.validationReport;
        } else if (this.currentValidationData.qualificationConclusion != QualificationConclusion.NOT_CATCHING && this.currentValidationData.qualificationConclusion != this.signatureValidationData.qualificationConclusion) {
            this.signatureValidationData.qualificationConclusion = QualificationConclusion.INCOHERENT;
            this.signatureValidationData.validationReport.merge(this.currentValidationData.validationReport);
            this.signatureValidationData.validationReport.addReportItem(new ReportItem(QUALIFICATION_CHECK, MULTIPLE_CA_QC_ENTRIES, ReportItem.ReportItemStatus.INFO));
        }
    }

    private void addReportItem(ReportItem reportItem) {
        this.currentValidationData.getValidationReport().addReportItem(reportItem);
    }

    private static enum CertificateType {
        E_SIG,
        E_SEAL,
        WSA,
        UNDEFINED,
        INCOHERENT;

    }

    private static class FinalQualificationData {
        final boolean finalQualification;
        final boolean finalQualifiedCreationDevice;
        final CertificateType finalCertType;

        FinalQualificationData(boolean finalQualification, boolean finalQualifiedCreationDevice, CertificateType finalCertType) {
            this.finalQualification = finalQualification;
            this.finalQualifiedCreationDevice = finalQualifiedCreationDevice;
            this.finalCertType = finalCertType;
        }
    }

    public static enum QualificationConclusion {
        ESIG_WITH_QC_AND_QSCD,
        ESEAL_WITH_QC_AND_QSCD,
        ESIG_WITH_QC,
        ESEAL_WITH_QC,
        NOT_QUALIFIED_ESIG,
        NOT_QUALIFIED_ESEAL,
        UNKNOWN_QC_AND_QSCD,
        UNKNOWN_QC,
        UNKNOWN,
        INCOHERENT,
        NOT_APPLICABLE,
        NOT_CATCHING,
        NOT_QUALIFIED;

    }

    public static class QualificationValidationData {
        QualificationConclusion qualificationConclusion;
        ValidationReport validationReport = new ValidationReport();

        QualificationValidationData() {
        }

        public QualificationConclusion getQualificationConclusion() {
            return this.qualificationConclusion == null || this.qualificationConclusion == QualificationConclusion.NOT_CATCHING || this.qualificationConclusion == QualificationConclusion.INCOHERENT ? QualificationConclusion.NOT_APPLICABLE : this.qualificationConclusion;
        }

        public ValidationReport getValidationReport() {
            return this.validationReport;
        }
    }
}

