/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.parse;

public class CssDeclarationValueTokenizer {
    private String src;
    private int index = -1;
    private char stringQuote;
    private boolean inString;
    private int functionDepth = 0;

    public CssDeclarationValueTokenizer(String propertyValue) {
        this.src = propertyValue;
    }

    public Token getNextValidToken() {
        Token token = this.getNextToken();
        while (token != null && !token.isString() && token.getValue().trim().isEmpty()) {
            token = this.getNextToken();
        }
        if (token != null && this.functionDepth > 0) {
            StringBuilder functionBuffer = new StringBuilder();
            while (token != null && this.functionDepth > 0) {
                this.processFunctionToken(token, functionBuffer);
                token = this.getNextToken();
            }
            this.functionDepth = 0;
            if (functionBuffer.length() != 0) {
                if (token != null) {
                    this.processFunctionToken(token, functionBuffer);
                }
                return new Token(functionBuffer.toString(), TokenType.FUNCTION);
            }
        }
        return token;
    }

    private Token getNextToken() {
        StringBuilder buff = new StringBuilder();
        if (this.index >= this.src.length() - 1) {
            return null;
        }
        if (this.inString) {
            boolean isEscaped = false;
            StringBuilder pendingUnicodeSequence = new StringBuilder();
            while (++this.index < this.src.length()) {
                char curChar = this.src.charAt(this.index);
                if (isEscaped) {
                    if (this.isHexDigit(curChar) && pendingUnicodeSequence.length() < 6) {
                        pendingUnicodeSequence.append(curChar);
                        continue;
                    }
                    if (pendingUnicodeSequence.length() != 0) {
                        int codePoint = Integer.parseInt(pendingUnicodeSequence.toString(), 16);
                        if (Character.isValidCodePoint(codePoint)) {
                            buff.appendCodePoint(codePoint);
                        } else {
                            buff.append("\ufffd");
                        }
                        pendingUnicodeSequence.setLength(0);
                        if (curChar == this.stringQuote) {
                            this.inString = false;
                            return new Token(buff.toString(), TokenType.STRING);
                        }
                        if (!Character.isWhitespace(curChar)) {
                            buff.append(curChar);
                        }
                        isEscaped = false;
                        continue;
                    }
                    buff.append(curChar);
                    isEscaped = false;
                    continue;
                }
                if (curChar == this.stringQuote) {
                    this.inString = false;
                    return new Token(buff.toString(), TokenType.STRING);
                }
                if (curChar == '\\') {
                    isEscaped = true;
                    continue;
                }
                buff.append(curChar);
            }
        } else {
            while (++this.index < this.src.length()) {
                char curChar = this.src.charAt(this.index);
                if (curChar == '(') {
                    ++this.functionDepth;
                    buff.append(curChar);
                    continue;
                }
                if (curChar == ')') {
                    --this.functionDepth;
                    buff.append(curChar);
                    if (this.functionDepth != 0) continue;
                    return new Token(buff.toString(), TokenType.FUNCTION);
                }
                if (curChar == '\"' || curChar == '\'') {
                    this.stringQuote = curChar;
                    this.inString = true;
                    return new Token(buff.toString(), TokenType.FUNCTION);
                }
                if (curChar == ',' && !this.inString && this.functionDepth == 0) {
                    return new Token(",", TokenType.COMMA);
                }
                if (Character.isWhitespace(curChar)) {
                    if (this.functionDepth > 0) {
                        buff.append(curChar);
                    }
                    return new Token(buff.toString(), this.functionDepth > 0 ? TokenType.FUNCTION : TokenType.UNKNOWN);
                }
                buff.append(curChar);
            }
        }
        return new Token(buff.toString(), TokenType.FUNCTION);
    }

    private boolean isHexDigit(char c) {
        return '/' < c && c < ':' || '@' < c && c < 'G' || '`' < c && c < 'g';
    }

    private void processFunctionToken(Token token, StringBuilder functionBuffer) {
        if (token.isString()) {
            functionBuffer.append(this.stringQuote);
            functionBuffer.append(token.getValue());
            functionBuffer.append(this.stringQuote);
        } else {
            functionBuffer.append(token.getValue());
        }
    }

    public static enum TokenType {
        STRING,
        FUNCTION,
        COMMA,
        UNKNOWN;

    }

    public static class Token {
        private String value;
        private TokenType type;

        public Token(String value, TokenType type) {
            this.value = value;
            this.type = type;
        }

        public String getValue() {
            return this.value;
        }

        public TokenType getType() {
            return this.type;
        }

        public boolean isString() {
            return this.type == TokenType.STRING;
        }

        public String toString() {
            return this.value;
        }
    }
}

