/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.resolve.shorthand.impl;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.IShorthandResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBoxShorthandResolver
implements IShorthandResolver {
    private static final String _0_LEFT_1 = "{0}-left{1}";
    private static final String _0_RIGHT_1 = "{0}-right{1}";
    private static final String _0_BOTTOM_1 = "{0}-bottom{1}";
    private static final String _0_TOP_1 = "{0}-top{1}";

    protected abstract String getPrefix();

    protected abstract String getPostfix();

    @Override
    public List<CssDeclaration> resolveShorthand(String shorthandExpression) {
        String[] props = shorthandExpression.split("\\s+");
        ArrayList<CssDeclaration> resolvedDecl = new ArrayList<CssDeclaration>();
        String topProperty = MessageFormatUtil.format((String)_0_TOP_1, (Object[])new Object[]{this.getPrefix(), this.getPostfix()});
        String rightProperty = MessageFormatUtil.format((String)_0_RIGHT_1, (Object[])new Object[]{this.getPrefix(), this.getPostfix()});
        String bottomProperty = MessageFormatUtil.format((String)_0_BOTTOM_1, (Object[])new Object[]{this.getPrefix(), this.getPostfix()});
        String leftProperty = MessageFormatUtil.format((String)_0_LEFT_1, (Object[])new Object[]{this.getPrefix(), this.getPostfix()});
        if (props.length == 1) {
            resolvedDecl.add(new CssDeclaration(topProperty, props[0]));
            resolvedDecl.add(new CssDeclaration(rightProperty, props[0]));
            resolvedDecl.add(new CssDeclaration(bottomProperty, props[0]));
            resolvedDecl.add(new CssDeclaration(leftProperty, props[0]));
        } else {
            for (String prop : props) {
                if (!"inherit".equals(prop) && !"initial".equals(prop)) continue;
                Logger logger = LoggerFactory.getLogger(AbstractBoxShorthandResolver.class);
                logger.warn(MessageFormatUtil.format((String)"Invalid css property declaration: {0}", (Object[])new Object[]{shorthandExpression}));
                return Collections.emptyList();
            }
            if (props.length == 2) {
                resolvedDecl.add(new CssDeclaration(topProperty, props[0]));
                resolvedDecl.add(new CssDeclaration(rightProperty, props[1]));
                resolvedDecl.add(new CssDeclaration(bottomProperty, props[0]));
                resolvedDecl.add(new CssDeclaration(leftProperty, props[1]));
            } else if (props.length == 3) {
                resolvedDecl.add(new CssDeclaration(topProperty, props[0]));
                resolvedDecl.add(new CssDeclaration(rightProperty, props[1]));
                resolvedDecl.add(new CssDeclaration(bottomProperty, props[2]));
                resolvedDecl.add(new CssDeclaration(leftProperty, props[1]));
            } else if (props.length == 4) {
                resolvedDecl.add(new CssDeclaration(topProperty, props[0]));
                resolvedDecl.add(new CssDeclaration(rightProperty, props[1]));
                resolvedDecl.add(new CssDeclaration(bottomProperty, props[2]));
                resolvedDecl.add(new CssDeclaration(leftProperty, props[3]));
            }
        }
        return resolvedDecl;
    }
}

