/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.media;

import com.itextpdf.commons.utils.StringNormalizer;
import com.itextpdf.styledxmlparser.css.media.MediaDeviceDescription;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import java.util.Objects;

public class MediaExpression {
    private static final float DEFAULT_FONT_SIZE = 12.0f;
    private boolean minPrefix;
    private boolean maxPrefix;
    private String feature;
    private String value;

    MediaExpression(String feature, String value) {
        this.feature = StringNormalizer.normalize((String)feature);
        if (value != null) {
            this.value = StringNormalizer.normalize((String)value);
        }
        String minPref = "min-";
        String maxPref = "max-";
        this.minPrefix = feature.startsWith(minPref);
        if (this.minPrefix) {
            this.feature = feature.substring(minPref.length());
        }
        this.maxPrefix = feature.startsWith(maxPref);
        if (this.maxPrefix) {
            this.feature = feature.substring(maxPref.length());
        }
    }

    public boolean matches(MediaDeviceDescription deviceDescription) {
        switch (this.feature) {
            case "color": {
                Integer val = CssDimensionParsingUtils.parseInteger(this.value);
                if (this.minPrefix) {
                    return val != null && deviceDescription.getBitsPerComponent() >= val;
                }
                if (this.maxPrefix) {
                    return val != null && deviceDescription.getBitsPerComponent() <= val;
                }
                return val == null ? deviceDescription.getBitsPerComponent() != 0 : val.intValue() == deviceDescription.getBitsPerComponent();
            }
            case "color-index": {
                Integer val = CssDimensionParsingUtils.parseInteger(this.value);
                if (this.minPrefix) {
                    return val != null && deviceDescription.getColorIndex() >= val;
                }
                if (this.maxPrefix) {
                    return val != null && deviceDescription.getColorIndex() <= val;
                }
                return val == null ? deviceDescription.getColorIndex() != 0 : val.intValue() == deviceDescription.getColorIndex();
            }
            case "aspect-ratio": {
                int[] aspectRatio = CssDimensionParsingUtils.parseAspectRatio(this.value);
                if (this.minPrefix) {
                    return aspectRatio != null && (float)aspectRatio[0] * deviceDescription.getHeight() >= (float)aspectRatio[1] * deviceDescription.getWidth();
                }
                if (this.maxPrefix) {
                    return aspectRatio != null && (float)aspectRatio[0] * deviceDescription.getHeight() <= (float)aspectRatio[1] * deviceDescription.getWidth();
                }
                return aspectRatio != null && CssUtils.compareFloats((float)aspectRatio[0] * deviceDescription.getHeight(), (float)aspectRatio[1] * deviceDescription.getWidth());
            }
            case "grid": {
                Integer val = CssDimensionParsingUtils.parseInteger(this.value);
                return val != null && val == 0 && !deviceDescription.isGrid() || deviceDescription.isGrid();
            }
            case "scan": {
                return Objects.equals(this.value, deviceDescription.getScan());
            }
            case "orientation": {
                return Objects.equals(this.value, deviceDescription.getOrientation());
            }
            case "monochrome": {
                Integer val = CssDimensionParsingUtils.parseInteger(this.value);
                if (this.minPrefix) {
                    return val != null && deviceDescription.getMonochrome() >= val;
                }
                if (this.maxPrefix) {
                    return val != null && deviceDescription.getMonochrome() <= val;
                }
                return val == null ? deviceDescription.getMonochrome() > 0 : val.intValue() == deviceDescription.getMonochrome();
            }
            case "height": {
                float val = MediaExpression.parseAbsoluteLength(this.value);
                if (this.minPrefix) {
                    return deviceDescription.getHeight() >= val;
                }
                if (this.maxPrefix) {
                    return deviceDescription.getHeight() <= val;
                }
                return deviceDescription.getHeight() > 0.0f;
            }
            case "width": {
                float val = MediaExpression.parseAbsoluteLength(this.value);
                if (this.minPrefix) {
                    return deviceDescription.getWidth() >= val;
                }
                if (this.maxPrefix) {
                    return deviceDescription.getWidth() <= val;
                }
                return deviceDescription.getWidth() > 0.0f;
            }
            case "resolution": {
                float val = CssDimensionParsingUtils.parseResolution(this.value);
                if (this.minPrefix) {
                    return deviceDescription.getResolution() >= val;
                }
                if (this.maxPrefix) {
                    return deviceDescription.getResolution() <= val;
                }
                return deviceDescription.getResolution() > 0.0f;
            }
        }
        return false;
    }

    private static float parseAbsoluteLength(String value) {
        if (CssTypesValidationUtils.isRelativeValue(value)) {
            return CssDimensionParsingUtils.parseRelativeValue(value, 12.0f);
        }
        return CssDimensionParsingUtils.parseAbsoluteLength(value);
    }
}

