/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import com.itextpdf.svg.utils.DrawUtils;

public class EllipseSvgNodeRenderer
extends AbstractSvgNodeRenderer {
    float cx;
    float cy;
    float rx;
    float ry;

    @Override
    protected void doDraw(SvgDrawContext context) {
        PdfCanvas cv = context.getCurrentCanvas();
        cv.writeLiteral("% ellipse\n");
        if (this.setParameters()) {
            cv.moveTo((double)this.cx + (double)this.rx, (double)this.cy);
            DrawUtils.arc((double)this.cx - (double)this.rx, (double)this.cy - (double)this.ry, (double)this.cx + (double)this.rx, (double)this.cy + (double)this.ry, 0.0, 360.0, cv);
        }
    }

    protected boolean setParameters() {
        this.cx = 0.0f;
        this.cy = 0.0f;
        if (this.getAttribute("cx") != null) {
            this.cx = CssUtils.parseAbsoluteLength((String)this.getAttribute("cx"));
        }
        if (this.getAttribute("cy") != null) {
            this.cy = CssUtils.parseAbsoluteLength((String)this.getAttribute("cy"));
        }
        if (this.getAttribute("rx") == null || !(CssUtils.parseAbsoluteLength((String)this.getAttribute("rx")) > 0.0f)) {
            return false;
        }
        this.rx = CssUtils.parseAbsoluteLength((String)this.getAttribute("rx"));
        if (this.getAttribute("ry") == null || !(CssUtils.parseAbsoluteLength((String)this.getAttribute("ry")) > 0.0f)) {
            return false;
        }
        this.ry = CssUtils.parseAbsoluteLength((String)this.getAttribute("ry"));
        return true;
    }

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        EllipseSvgNodeRenderer copy = new EllipseSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        return copy;
    }
}

