/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.font.FontCharacteristics;
import com.itextpdf.layout.font.FontInfo;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.font.FontSet;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.exceptions.SvgProcessingException;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.ISvgTextNodeHelper;
import com.itextpdf.svg.renderers.impl.ISvgTextNodeRenderer;
import com.itextpdf.svg.utils.SvgCssUtils;
import com.itextpdf.svg.utils.SvgTextUtil;
import com.itextpdf.svg.utils.TextRectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TextSvgBranchRenderer
extends AbstractSvgNodeRenderer
implements ISvgTextNodeRenderer,
ISvgTextNodeHelper {
    protected static final AffineTransform TEXTFLIP = new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, 0.0);
    private final List<ISvgTextNodeRenderer> children = new ArrayList<ISvgTextNodeRenderer>();
    protected boolean performRootTransformations = true;
    private PdfFont font;
    private boolean moveResolved = false;
    private float xMove;
    private float yMove;
    private boolean posResolved = false;
    private float[] xPos;
    private float[] yPos;
    private boolean whiteSpaceProcessed = false;

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        TextSvgBranchRenderer copy = new TextSvgBranchRenderer();
        this.deepCopyAttributesAndStyles(copy);
        this.deepCopyChildren(copy);
        return copy;
    }

    public final void addChild(ISvgTextNodeRenderer child) {
        if (child != null) {
            this.children.add(child);
        }
    }

    public final List<ISvgTextNodeRenderer> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public float getTextContentLength(float parentFontSize, PdfFont font) {
        return 0.0f;
    }

    @Override
    public float[] getRelativeTranslation() {
        if (!this.moveResolved) {
            this.resolveTextMove();
        }
        return new float[]{this.xMove, this.yMove};
    }

    @Override
    public boolean containsRelativeMove() {
        if (!this.moveResolved) {
            this.resolveTextMove();
        }
        boolean isNullMove = CssUtils.compareFloats((float)0.0f, (float)this.xMove) && CssUtils.compareFloats((float)0.0f, (float)this.yMove);
        return !isNullMove;
    }

    @Override
    public boolean containsAbsolutePositionChange() {
        if (!this.posResolved) {
            this.resolveTextPosition();
        }
        return this.xPos != null && this.xPos.length > 0 || this.yPos != null && this.yPos.length > 0;
    }

    @Override
    public float[][] getAbsolutePositionChanges() {
        if (!this.posResolved) {
            this.resolveTextPosition();
        }
        return new float[][]{this.xPos, this.yPos};
    }

    public void markWhiteSpaceProcessed() {
        this.whiteSpaceProcessed = true;
    }

    @Override
    public TextRectangle getTextRectangle(SvgDrawContext context, Point basePoint) {
        if (this.attributesAndStyles != null) {
            this.resolveFont(context);
            double x = 0.0;
            double y = 0.0;
            if (this.getAbsolutePositionChanges()[0] != null) {
                x = this.getAbsolutePositionChanges()[0][0];
            } else if (basePoint != null) {
                x = basePoint.getX();
            }
            if (this.getAbsolutePositionChanges()[1] != null) {
                y = this.getAbsolutePositionChanges()[1][0];
            } else if (basePoint != null) {
                y = basePoint.getY();
            }
            basePoint = new Point(x, y);
            basePoint.translate((double)this.getRelativeTranslation()[0], (double)this.getRelativeTranslation()[1]);
            Rectangle commonRect = null;
            for (ISvgTextNodeRenderer child : this.getChildren()) {
                if (!(child instanceof ISvgTextNodeHelper)) continue;
                TextRectangle rectangle = ((ISvgTextNodeHelper)((Object)child)).getTextRectangle(context, basePoint);
                basePoint = rectangle.getTextBaseLineRightPoint();
                commonRect = Rectangle.getCommonRectangle((Rectangle[])new Rectangle[]{commonRect, rectangle});
            }
            if (commonRect != null) {
                return new TextRectangle(commonRect.getX(), commonRect.getY(), commonRect.getWidth(), commonRect.getHeight(), (float)basePoint.getY());
            }
        }
        return null;
    }

    @Override
    protected Rectangle getObjectBoundingBox(SvgDrawContext context) {
        return this.getTextRectangle(context, null);
    }

    @Override
    protected void doDraw(SvgDrawContext context) {
        if (this.getChildren().size() > 0) {
            PdfCanvas currentCanvas = context.getCurrentCanvas();
            if (this.performRootTransformations) {
                currentCanvas.beginText();
                AffineTransform rootTf = this.containsAbsolutePositionChange() ? TextSvgBranchRenderer.getTextTransform(this.getAbsolutePositionChanges(), context) : new AffineTransform(TEXTFLIP);
                currentCanvas.setTextMatrix(rootTf);
                context.resetTextMove();
                if (this.containsRelativeMove()) {
                    float[] rootMove = this.getRelativeTranslation();
                    context.addTextMove(rootMove[0], -rootMove[1]);
                }
                if (!this.whiteSpaceProcessed) {
                    SvgTextUtil.processWhiteSpace(this, true);
                }
            }
            this.applyTextRenderingMode(currentCanvas);
            if (this.attributesAndStyles != null) {
                this.resolveFont(context);
                currentCanvas.setFontAndSize(this.font, this.getCurrentFontSize());
                for (ISvgTextNodeRenderer c : this.children) {
                    float textAnchorCorrection;
                    float childLength = c.getTextContentLength(this.getCurrentFontSize(), this.font);
                    if (c.containsAbsolutePositionChange()) {
                        float[][] absolutePositions = c.getAbsolutePositionChanges();
                        AffineTransform newTransform = TextSvgBranchRenderer.getTextTransform(absolutePositions, context);
                        context.setLastTextTransform(newTransform);
                        currentCanvas.setTextMatrix(newTransform);
                        context.resetTextMove();
                    }
                    if (!CssUtils.compareFloats((float)0.0f, (float)(textAnchorCorrection = this.getTextAnchorAlignmentCorrection(childLength)))) {
                        context.addTextMove(textAnchorCorrection, 0.0f);
                    }
                    if (c.containsRelativeMove()) {
                        float[] childMove = c.getRelativeTranslation();
                        context.addTextMove(childMove[0], -childMove[1]);
                    }
                    currentCanvas.saveState();
                    c.draw(context);
                    context.addTextMove(childLength, 0.0f);
                    currentCanvas.restoreState();
                    if (context.getLastTextTransform().isIdentity()) continue;
                    currentCanvas.setTextMatrix(context.getLastTextTransform());
                }
                if (this.performRootTransformations) {
                    currentCanvas.endText();
                }
            }
        }
    }

    private void resolveTextMove() {
        if (this.attributesAndStyles != null) {
            String xRawValue = (String)this.attributesAndStyles.get("dx");
            String yRawValue = (String)this.attributesAndStyles.get("dy");
            List<String> xValuesList = SvgCssUtils.splitValueList(xRawValue);
            List<String> yValuesList = SvgCssUtils.splitValueList(yRawValue);
            this.xMove = 0.0f;
            this.yMove = 0.0f;
            if (!xValuesList.isEmpty()) {
                this.xMove = CssDimensionParsingUtils.parseAbsoluteLength((String)xValuesList.get(0));
            }
            if (!yValuesList.isEmpty()) {
                this.yMove = CssDimensionParsingUtils.parseAbsoluteLength((String)yValuesList.get(0));
            }
            this.moveResolved = true;
        }
    }

    private FontInfo resolveFontName(String fontFamily, String fontWeight, String fontStyle, FontProvider provider, FontSet tempFonts) {
        boolean isBold = "bold".equalsIgnoreCase(fontWeight);
        boolean isItalic = "italic".equalsIgnoreCase(fontStyle);
        FontCharacteristics fontCharacteristics = new FontCharacteristics();
        ArrayList<String> stringArrayList = new ArrayList<String>();
        stringArrayList.add(fontFamily);
        fontCharacteristics.setBoldFlag(isBold);
        fontCharacteristics.setItalicFlag(isItalic);
        return provider.getFontSelector(stringArrayList, fontCharacteristics, tempFonts).bestMatch();
    }

    void resolveFont(SvgDrawContext context) {
        FontProvider provider = context.getFontProvider();
        FontSet tempFonts = context.getTempFonts();
        this.font = null;
        if (!provider.getFontSet().isEmpty() || tempFonts != null && !tempFonts.isEmpty()) {
            String fontFamily = (String)this.attributesAndStyles.get("font-family");
            String fontWeight = (String)this.attributesAndStyles.get("font-weight");
            String fontStyle = (String)this.attributesAndStyles.get("font-style");
            fontFamily = fontFamily != null ? fontFamily.trim() : "";
            FontInfo fontInfo = this.resolveFontName(fontFamily, fontWeight, fontStyle, provider, tempFonts);
            this.font = provider.getPdfFont(fontInfo, tempFonts);
        }
        if (this.font == null) {
            try {
                this.font = PdfFontFactory.createFont();
            }
            catch (IOException e) {
                throw new SvgProcessingException("The font wasn't found.", e);
            }
        }
    }

    PdfFont getFont() {
        return this.font;
    }

    private void resolveTextPosition() {
        if (this.attributesAndStyles != null) {
            String xRawValue = (String)this.attributesAndStyles.get("x");
            String yRawValue = (String)this.attributesAndStyles.get("y");
            this.xPos = TextSvgBranchRenderer.getPositionsFromString(xRawValue);
            this.yPos = TextSvgBranchRenderer.getPositionsFromString(yRawValue);
            this.posResolved = true;
        }
    }

    private static float[] getPositionsFromString(String rawValuesString) {
        float[] result = null;
        List<String> valuesList = SvgCssUtils.splitValueList(rawValuesString);
        if (!valuesList.isEmpty()) {
            result = new float[valuesList.size()];
            for (int i = 0; i < valuesList.size(); ++i) {
                result[i] = CssDimensionParsingUtils.parseAbsoluteLength((String)valuesList.get(i));
            }
        }
        return result;
    }

    private static AffineTransform getTextTransform(float[][] absolutePositions, SvgDrawContext context) {
        AffineTransform tf = new AffineTransform();
        if (absolutePositions[0] == null && absolutePositions[1] != null) {
            absolutePositions[0] = new float[]{context.getTextMove()[0]};
        }
        if (absolutePositions[1] == null) {
            absolutePositions[1] = new float[]{0.0f};
        }
        tf.concatenate(TEXTFLIP);
        tf.concatenate(AffineTransform.getTranslateInstance((double)absolutePositions[0][0], (double)(-absolutePositions[1][0])));
        return tf;
    }

    private void applyTextRenderingMode(PdfCanvas currentCanvas) {
        if (this.doStroke && this.doFill) {
            currentCanvas.setTextRenderingMode(2);
        } else if (this.doStroke) {
            currentCanvas.setTextRenderingMode(1);
        } else {
            currentCanvas.setTextRenderingMode(0);
        }
    }

    private void deepCopyChildren(TextSvgBranchRenderer deepCopy) {
        for (ISvgTextNodeRenderer child : this.children) {
            ISvgTextNodeRenderer newChild = (ISvgTextNodeRenderer)child.createDeepCopy();
            child.setParent(deepCopy);
            deepCopy.addChild(newChild);
        }
    }

    private float getTextAnchorAlignmentCorrection(float childContentLength) {
        float textAnchorXCorrection = 0.0f;
        if (this.attributesAndStyles != null && this.attributesAndStyles.containsKey("text-anchor")) {
            String textAnchorValue = this.getAttribute("text-anchor");
            if ("middle".equals(textAnchorValue) && this.xPos != null && this.xPos.length > 0) {
                textAnchorXCorrection -= childContentLength / 2.0f;
            }
            if ("end".equals(textAnchorValue) && this.xPos != null && this.xPos.length > 0) {
                textAnchorXCorrection -= childContentLength;
            }
        }
        return textAnchorXCorrection;
    }
}

