/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.colors.gradients.GradientSpreadMethod;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.svg.SvgConstants;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.ISvgPaintServer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.NoDrawOperationSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.StopSvgNodeRenderer;
import com.itextpdf.svg.utils.TransformUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.LoggerFactory;

public abstract class AbstractGradientSvgNodeRenderer
extends NoDrawOperationSvgNodeRenderer
implements ISvgPaintServer {
    @Override
    protected void doDraw(SvgDrawContext context) {
        throw new UnsupportedOperationException("Can't draw current SvgNodeRenderer.");
    }

    protected boolean isObjectBoundingBoxUnits() {
        String gradientUnits = this.getAttribute(SvgConstants.Attributes.GRADIENT_UNITS);
        if ("userSpaceOnUse".equals(gradientUnits)) {
            return false;
        }
        if (gradientUnits != null && !"objectBoundingBox".equals(gradientUnits)) {
            LoggerFactory.getLogger(this.getClass()).warn(MessageFormatUtil.format((String)"Could not recognize gradient units value {0}", (Object[])new Object[]{gradientUnits}));
        }
        return true;
    }

    protected AffineTransform getGradientTransform() {
        String gradientTransform = this.getAttribute(SvgConstants.Attributes.GRADIENT_TRANSFORM);
        if (gradientTransform != null && !gradientTransform.isEmpty()) {
            return TransformUtils.parseTransform(gradientTransform);
        }
        return null;
    }

    protected List<StopSvgNodeRenderer> getChildStopRenderers() {
        ArrayList<StopSvgNodeRenderer> stopRenderers = new ArrayList<StopSvgNodeRenderer>();
        for (ISvgNodeRenderer child : this.getChildren()) {
            if (!(child instanceof StopSvgNodeRenderer)) continue;
            stopRenderers.add((StopSvgNodeRenderer)child);
        }
        return stopRenderers;
    }

    protected GradientSpreadMethod parseSpreadMethod() {
        String spreadMethodValue = this.getAttribute(SvgConstants.Attributes.SPREAD_METHOD);
        if (spreadMethodValue == null) {
            return GradientSpreadMethod.PAD;
        }
        switch (spreadMethodValue) {
            case "pad": {
                return GradientSpreadMethod.PAD;
            }
            case "reflect": {
                return GradientSpreadMethod.REFLECT;
            }
            case "repeat": {
                return GradientSpreadMethod.REPEAT;
            }
        }
        LoggerFactory.getLogger(this.getClass()).warn(MessageFormatUtil.format((String)"Could not recognize gradient spread method value {0}", (Object[])new Object[]{spreadMethodValue}));
        return GradientSpreadMethod.PAD;
    }
}

