/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.CanvasGraphicsState;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.extgstate.PdfExtGState;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.ISvgTextNodeRenderer;
import com.itextpdf.svg.renderers.impl.TextSvgBranchRenderer;

public class TextSvgTSpanBranchRenderer
extends TextSvgBranchRenderer {
    private static final float EPS = 1.0E-4f;

    public TextSvgTSpanBranchRenderer() {
        this.performRootTransformations = false;
    }

    @Override
    protected Rectangle getObjectBoundingBox(SvgDrawContext context) {
        if (this.getParent() instanceof AbstractSvgNodeRenderer) {
            return ((AbstractSvgNodeRenderer)this.getParent()).getObjectBoundingBox(context);
        }
        return null;
    }

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        TextSvgTSpanBranchRenderer copy = new TextSvgTSpanBranchRenderer();
        this.fillCopy(copy);
        return copy;
    }

    @Override
    protected void doDraw(SvgDrawContext context) {
        if (this.getChildren().size() > 0) {
            PdfCanvas currentCanvas = context.getCurrentCanvas();
            if (this.attributesAndStyles != null) {
                for (ISvgTextNodeRenderer c : this.getChildren()) {
                    float textAnchorCorrection;
                    this.applyTextRenderingMode(currentCanvas);
                    this.resolveFont(context);
                    currentCanvas.setFontAndSize(this.getFont(), this.getCurrentFontSize());
                    float childLength = c.getTextContentLength(this.getCurrentFontSize(), this.getFont());
                    if (c.containsAbsolutePositionChange()) {
                        float[][] absolutePositions = c.getAbsolutePositionChanges();
                        AffineTransform newTransform = TextSvgTSpanBranchRenderer.getTextTransform(absolutePositions, context);
                        context.setLastTextTransform(newTransform);
                        currentCanvas.setTextMatrix(newTransform);
                        context.resetTextMove();
                        context.setPreviousElementTextMove(null);
                    }
                    if (!CssUtils.compareFloats((float)0.0f, (float)(textAnchorCorrection = this.getTextAnchorAlignmentCorrection(childLength)))) {
                        context.addTextMove(textAnchorCorrection, 0.0f);
                    }
                    if (c.containsRelativeMove()) {
                        float[] childMove = c.getRelativeTranslation();
                        context.addTextMove(childMove[0], -childMove[1]);
                        context.setPreviousElementTextMove(new float[]{context.getPreviousElementTextMove()[0] + childMove[0], context.getPreviousElementTextMove()[1] - childMove[1]});
                    }
                    CanvasGraphicsState savedState = new CanvasGraphicsState(currentCanvas.getGraphicsState());
                    c.draw(context);
                    this.applyGSDifference(currentCanvas, savedState);
                    context.addTextMove(childLength, 0.0f);
                    if (TextSvgTSpanBranchRenderer.floatsAreEqual(childLength, 0.0f)) continue;
                    context.setPreviousElementTextMove(new float[]{childLength, 0.0f});
                }
            }
        }
    }

    void applyGSDifference(PdfCanvas currentCanvas, CanvasGraphicsState savedGs) {
        CanvasGraphicsState newGs = currentCanvas.getGraphicsState();
        if (!TextSvgTSpanBranchRenderer.floatsAreEqual(savedGs.getCharSpacing(), newGs.getCharSpacing())) {
            currentCanvas.setCharacterSpacing(savedGs.getCharSpacing());
        }
        if (savedGs.getFillColor() != newGs.getFillColor()) {
            currentCanvas.setFillColor(savedGs.getFillColor());
        }
        if (savedGs.getFont() != newGs.getFont() || !TextSvgTSpanBranchRenderer.floatsAreEqual(savedGs.getFontSize(), newGs.getFontSize())) {
            currentCanvas.setFontAndSize(savedGs.getFont(), savedGs.getFontSize());
        }
        if (!TextSvgTSpanBranchRenderer.floatsAreEqual(savedGs.getLineWidth(), newGs.getLineWidth())) {
            currentCanvas.setLineWidth(savedGs.getLineWidth());
        }
        if (savedGs.getStrokeColor() != newGs.getStrokeColor()) {
            currentCanvas.setStrokeColor(savedGs.getStrokeColor());
        }
        if (savedGs.getTextRenderingMode() != newGs.getTextRenderingMode()) {
            currentCanvas.setTextRenderingMode(savedGs.getTextRenderingMode());
        }
        if (!TextSvgTSpanBranchRenderer.floatsAreEqual(savedGs.getFillOpacity(), newGs.getFillOpacity()) || !TextSvgTSpanBranchRenderer.floatsAreEqual(savedGs.getStrokeOpacity(), newGs.getStrokeOpacity())) {
            PdfExtGState extGState = new PdfExtGState();
            extGState.setFillOpacity(savedGs.getFillOpacity());
            extGState.setStrokeOpacity(savedGs.getStrokeOpacity());
            currentCanvas.setExtGState(extGState);
        }
    }

    private static boolean floatsAreEqual(float first, float second) {
        return Math.abs(first - second) < 1.0E-4f;
    }
}

