/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.converter;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.styledxmlparser.node.INode;
import com.itextpdf.styledxmlparser.node.impl.jsoup.JsoupXmlParser;
import com.itextpdf.svg.exceptions.SvgProcessingException;
import com.itextpdf.svg.processors.ISvgConverterProperties;
import com.itextpdf.svg.processors.impl.DefaultSvgProcessor;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import java.io.IOException;
import java.io.InputStream;

public final class SvgConverter {
    private SvgConverter() {
    }

    private static void checkNull(Object o) {
        if (o == null) {
            throw new SvgProcessingException("Parameters for this method cannot be null.");
        }
    }

    public static void drawOnDocument(String content, PdfDocument document, int pageNo) {
        SvgConverter.checkNull(document);
        SvgConverter.drawOnPage(content, document.getPage(pageNo));
    }

    public static void drawOnDocument(String content, PdfDocument document, int pageNo, ISvgConverterProperties props) {
        SvgConverter.checkNull(document);
        SvgConverter.drawOnPage(content, document.getPage(pageNo), props);
    }

    public static void drawOnDocument(InputStream stream, PdfDocument document, int pageNo) throws IOException {
        SvgConverter.checkNull(document);
        SvgConverter.drawOnPage(stream, document.getPage(pageNo));
    }

    public static void drawOnDocument(InputStream stream, PdfDocument document, int pageNo, ISvgConverterProperties props) throws IOException {
        SvgConverter.checkNull(document);
        SvgConverter.drawOnPage(stream, document.getPage(pageNo), props);
    }

    public static void drawOnPage(String content, PdfPage page) {
        SvgConverter.checkNull(page);
        SvgConverter.drawOnCanvas(content, new PdfCanvas(page));
    }

    public static void drawOnPage(String content, PdfPage page, ISvgConverterProperties props) {
        SvgConverter.checkNull(page);
        SvgConverter.drawOnCanvas(content, new PdfCanvas(page), props);
    }

    public static void drawOnPage(InputStream stream, PdfPage page) throws IOException {
        SvgConverter.checkNull(page);
        SvgConverter.drawOnCanvas(stream, new PdfCanvas(page));
    }

    public static void drawOnPage(InputStream stream, PdfPage page, ISvgConverterProperties props) throws IOException {
        SvgConverter.checkNull(page);
        SvgConverter.drawOnCanvas(stream, new PdfCanvas(page), props);
    }

    public static void drawOnCanvas(String content, PdfCanvas canvas) {
        SvgConverter.checkNull(canvas);
        SvgConverter.draw(SvgConverter.convertToXObject(content, canvas.getDocument()), canvas);
    }

    public static void drawOnCanvas(String content, PdfCanvas canvas, ISvgConverterProperties props) {
        SvgConverter.checkNull(canvas);
        SvgConverter.draw(SvgConverter.convertToXObject(content, canvas.getDocument(), props), canvas);
    }

    public static void drawOnCanvas(InputStream stream, PdfCanvas canvas) throws IOException {
        SvgConverter.checkNull(canvas);
        SvgConverter.draw(SvgConverter.convertToXObject(stream, canvas.getDocument()), canvas);
    }

    public static void drawOnCanvas(InputStream stream, PdfCanvas canvas, ISvgConverterProperties props) throws IOException {
        SvgConverter.checkNull(canvas);
        SvgConverter.draw(SvgConverter.convertToXObject(stream, canvas.getDocument(), props), canvas);
    }

    public static PdfFormXObject convertToXObject(String content, PdfDocument document) {
        return SvgConverter.convertToXObject(SvgConverter.process(SvgConverter.parse(content)), document);
    }

    public static PdfFormXObject convertToXObject(String content, PdfDocument document, ISvgConverterProperties props) {
        return SvgConverter.convertToXObject(SvgConverter.process(SvgConverter.parse(content), props), document);
    }

    public static PdfFormXObject convertToXObject(InputStream stream, PdfDocument document) throws IOException {
        return SvgConverter.convertToXObject(SvgConverter.process(SvgConverter.parse(stream)), document);
    }

    public static PdfFormXObject convertToXObject(InputStream stream, PdfDocument document, ISvgConverterProperties props) throws IOException {
        return SvgConverter.convertToXObject(SvgConverter.process(SvgConverter.parse(stream, props), props), document);
    }

    private static void draw(PdfFormXObject pdfForm, PdfCanvas canvas) {
        canvas.addXObject((PdfXObject)pdfForm, 0.0f, 0.0f);
    }

    public static PdfFormXObject convertToXObject(ISvgNodeRenderer rootRenderer, PdfDocument document) {
        SvgConverter.checkNull(rootRenderer);
        SvgConverter.checkNull(document);
        float width = CssUtils.parseAbsoluteLength((String)rootRenderer.getAttribute("width"));
        float height = CssUtils.parseAbsoluteLength((String)rootRenderer.getAttribute("height"));
        PdfFormXObject pdfForm = new PdfFormXObject(new Rectangle(0.0f, 0.0f, width, height));
        PdfCanvas canvas = new PdfCanvas(pdfForm, document);
        SvgDrawContext context = new SvgDrawContext();
        context.pushCanvas(canvas);
        rootRenderer.draw(context);
        return pdfForm;
    }

    public static ISvgNodeRenderer process(INode root) {
        SvgConverter.checkNull(root);
        DefaultSvgProcessor processor = new DefaultSvgProcessor();
        return processor.process(root);
    }

    public static ISvgNodeRenderer process(INode root, ISvgConverterProperties props) {
        SvgConverter.checkNull(root);
        DefaultSvgProcessor processor = new DefaultSvgProcessor();
        return processor.process(root, props);
    }

    public static INode parse(String content) {
        SvgConverter.checkNull(content);
        JsoupXmlParser xmlParser = new JsoupXmlParser();
        return xmlParser.parse(content);
    }

    public static INode parse(InputStream stream) throws IOException {
        SvgConverter.checkNull(stream);
        return SvgConverter.parse(stream, null);
    }

    public static INode parse(InputStream stream, ISvgConverterProperties props) throws IOException {
        SvgConverter.checkNull(stream);
        JsoupXmlParser xmlParser = new JsoupXmlParser();
        return xmlParser.parse(stream, props != null ? props.getCharset() : null);
    }
}

