/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.processors.impl;

import com.itextpdf.styledxmlparser.css.ICssContext;
import com.itextpdf.styledxmlparser.css.ICssResolver;
import com.itextpdf.styledxmlparser.node.IElementNode;
import com.itextpdf.styledxmlparser.node.INode;
import com.itextpdf.styledxmlparser.node.ITextNode;
import com.itextpdf.svg.css.SvgCssContext;
import com.itextpdf.svg.exceptions.SvgProcessingException;
import com.itextpdf.svg.processors.ISvgConverterProperties;
import com.itextpdf.svg.processors.ISvgProcessor;
import com.itextpdf.svg.processors.impl.DefaultSvgConverterProperties;
import com.itextpdf.svg.processors.impl.ProcessorState;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.factories.ISvgNodeRendererFactory;
import com.itextpdf.svg.renderers.impl.TextSvgNodeRenderer;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSvgProcessor
implements ISvgProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSvgProcessor.class);
    private ProcessorState processorState;
    private ICssResolver cssResolver;
    private SvgCssContext cssContext;
    private ISvgNodeRendererFactory rendererFactory;
    private ISvgConverterProperties defaultProps;

    @Override
    public ISvgNodeRenderer process(INode root) throws SvgProcessingException {
        return this.process(root, new DefaultSvgConverterProperties(root));
    }

    @Override
    public ISvgNodeRenderer process(INode root, ISvgConverterProperties converterProps) throws SvgProcessingException {
        if (root == null) {
            throw new SvgProcessingException("Input root value is null");
        }
        if (converterProps != null) {
            this.performSetup(converterProps);
        } else {
            this.performSetup(new DefaultSvgConverterProperties(root));
        }
        IElementNode svgRoot = DefaultSvgProcessor.findFirstElement(root, "svg");
        if (svgRoot != null) {
            this.executeDepthFirstTraversal((INode)svgRoot);
            ISvgNodeRenderer rootSvgRenderer = this.createResultAndClean();
            return rootSvgRenderer;
        }
        throw new SvgProcessingException("No root found");
    }

    private void performSetup(ISvgConverterProperties converterProps) {
        this.processorState = new ProcessorState();
        this.cssResolver = converterProps.getCssResolver() != null ? converterProps.getCssResolver() : this.defaultProps.getCssResolver();
        this.rendererFactory = converterProps.getRendererFactory() != null ? converterProps.getRendererFactory() : this.defaultProps.getRendererFactory();
        this.cssContext = new SvgCssContext();
    }

    private void executeDepthFirstTraversal(INode startingNode) {
        if (startingNode instanceof IElementNode && !this.rendererFactory.isTagIgnored((IElementNode)startingNode)) {
            IElementNode rootElementNode = (IElementNode)startingNode;
            ISvgNodeRenderer startingRenderer = this.rendererFactory.createSvgNodeRendererForTag(rootElementNode, null);
            startingRenderer.setAttributesAndStyles(this.cssResolver.resolveStyles(startingNode, (ICssContext)this.cssContext));
            this.processorState.push(startingRenderer);
            for (INode rootChild : startingNode.childNodes()) {
                this.visit(rootChild);
            }
        }
    }

    private ISvgNodeRenderer createResultAndClean() {
        return this.processorState.pop();
    }

    private void visit(INode node) {
        if (node instanceof IElementNode) {
            IElementNode element = (IElementNode)node;
            if (!this.rendererFactory.isTagIgnored(element)) {
                ISvgNodeRenderer renderer = this.createRenderer(element, this.processorState.top());
                if (renderer != null) {
                    renderer.setAttributesAndStyles(this.cssResolver.resolveStyles(node, (ICssContext)this.cssContext));
                    this.processorState.top().addChild(renderer);
                    this.processorState.push(renderer);
                }
                for (INode childNode : element.childNodes()) {
                    this.visit(childNode);
                }
                if (renderer != null) {
                    this.processorState.pop();
                }
            }
        } else if (this.processAsText(node)) {
            this.processText((ITextNode)node);
        }
    }

    private ISvgNodeRenderer createRenderer(IElementNode tag, ISvgNodeRenderer parent) {
        return this.rendererFactory.createSvgNodeRendererForTag(tag, parent);
    }

    private boolean processAsText(INode node) {
        return node instanceof ITextNode;
    }

    private void processText(ITextNode textNode) {
        ISvgNodeRenderer parentRenderer = this.processorState.top();
        if (parentRenderer != null && parentRenderer instanceof TextSvgNodeRenderer) {
            String trimmedText = textNode.wholeText().replaceAll("\\s+", " ");
            parentRenderer.setAttribute("text_content", trimmedText);
        }
    }

    private static IElementNode findFirstElement(INode node, String tagName) {
        LinkedList<INode> q = new LinkedList<INode>();
        q.add(node);
        while (!q.isEmpty()) {
            INode currentNode = (INode)q.getFirst();
            q.removeFirst();
            if (currentNode == null) {
                return null;
            }
            if (currentNode instanceof IElementNode && ((IElementNode)currentNode).name() != null && ((IElementNode)currentNode).name().equals(tagName)) {
                return (IElementNode)currentNode;
            }
            for (INode child : currentNode.childNodes()) {
                if (!(child instanceof IElementNode)) continue;
                q.add(child);
            }
        }
        return null;
    }
}

