/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.svg.exceptions.SvgProcessingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class SvgDrawContext {
    private final Map<String, Object> namedObjects = new HashMap<String, Object>();
    private final Stack<PdfCanvas> canvases = new Stack();
    private final Stack<Rectangle> viewports = new Stack();

    public PdfCanvas getCurrentCanvas() {
        return this.canvases.peek();
    }

    public PdfCanvas popCanvas() {
        return this.canvases.pop();
    }

    public void pushCanvas(PdfCanvas canvas) {
        this.canvases.push(canvas);
    }

    public int size() {
        return this.canvases.size();
    }

    public void addViewPort(Rectangle viewPort) {
        this.viewports.push(viewPort);
    }

    public Rectangle getCurrentViewPort() {
        return this.viewports.peek();
    }

    public void removeCurrentViewPort() {
        if (this.viewports.size() > 0) {
            this.viewports.pop();
        }
    }

    public void addNamedObject(String name, Object namedObject) {
        if (namedObject == null) {
            throw new SvgProcessingException("A named object can't be null.");
        }
        if (name == null || name.isEmpty()) {
            throw new SvgProcessingException("The name of the named object can't be null or empty.");
        }
        if (!this.namedObjects.containsKey(name) || namedObject instanceof PdfFormXObject) {
            this.namedObjects.put(name, namedObject);
        }
    }

    public Object getNamedObject(String name) {
        return this.namedObjects.get(name);
    }
}

