/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import com.itextpdf.svg.renderers.path.DefaultSvgPathShapeFactory;
import com.itextpdf.svg.renderers.path.IPathShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class PathSvgNodeRenderer
extends AbstractSvgNodeRenderer {
    private static final String SEPERATOR = "";
    private static final String SPACE_CHAR = " ";

    @Override
    public void doDraw(SvgDrawContext context) {
        PdfCanvas canvas = context.getCurrentCanvas();
        for (IPathShape item : this.getShapes()) {
            item.draw(canvas);
        }
    }

    private Collection<IPathShape> getShapes() {
        Collection<String> parsedResults = this.parsePropertiesAndStyles();
        ArrayList<IPathShape> shapes = new ArrayList<IPathShape>();
        for (String parsedResult : parsedResults) {
            String[] pathPropertis = parsedResult.split(SPACE_CHAR);
            if (pathPropertis.length <= 0 || pathPropertis[0].equals(SEPERATOR)) continue;
            if (pathPropertis[0].equalsIgnoreCase("z")) {
                shapes.add(DefaultSvgPathShapeFactory.createPathShape("z"));
                continue;
            }
            IPathShape pathShape = DefaultSvgPathShapeFactory.createPathShape(pathPropertis[0].toUpperCase());
            pathShape.setCoordinates(Arrays.copyOfRange(pathPropertis, 1, pathPropertis.length));
            shapes.add(pathShape);
        }
        return shapes;
    }

    private Collection<String> parsePropertiesAndStyles() {
        String[] coordinates;
        String closePath;
        StringBuilder result = new StringBuilder();
        String attributes = (String)this.attributesAndStyles.get("d");
        String string = closePath = attributes.indexOf(122) > 0 ? attributes.substring(attributes.indexOf(122)) : SEPERATOR.trim();
        if (!closePath.equals(SEPERATOR)) {
            attributes = attributes.replace(closePath, SEPERATOR).trim();
        }
        String SPLIT_REGEX = "(?=[\\p{L}][^,;])";
        for (String inst : coordinates = attributes.split(SPLIT_REGEX)) {
            if (inst.equals(SEPERATOR)) continue;
            String instruction = inst.charAt(0) + SPACE_CHAR;
            String temp = instruction + inst.replace(inst.charAt(0) + SEPERATOR, SEPERATOR).replace(",", SPACE_CHAR).trim();
            result.append(SPACE_CHAR).append(temp);
        }
        String[] resultArray = result.toString().split(SPLIT_REGEX);
        ArrayList<String> resultList = new ArrayList<String>(Arrays.asList(resultArray));
        resultList.add(closePath);
        return resultList;
    }
}

