/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.exceptions.SvgProcessingException;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractBranchSvgNodeRenderer;
import com.itextpdf.svg.utils.SvgCssUtils;
import com.itextpdf.svg.utils.TransformUtils;

public class SvgSvgNodeRenderer
extends AbstractBranchSvgNodeRenderer {
    private boolean outermost = true;

    @Override
    protected void doDraw(SvgDrawContext context) {
        this.outermost = this.getParent() == null;
        context.addViewPort(this.calculateViewPort(context));
        PdfCanvas currentCanvas = context.getCurrentCanvas();
        currentCanvas.concatMatrix(this.calculateTransformation(context));
        super.doDraw(context);
    }

    AffineTransform calculateTransformation(SvgDrawContext context) {
        AffineTransform transform;
        Rectangle viewPort = context.getCurrentViewPort();
        if (this.outermost) {
            float vertical = viewPort.getY() + viewPort.getHeight();
            transform = TransformUtils.parseTransform("matrix(1 0 0 -1 " + SvgCssUtils.convertFloatToString(viewPort.getX()) + " " + SvgCssUtils.convertFloatToString(vertical));
        } else {
            transform = AffineTransform.getTranslateInstance((double)viewPort.getX(), (double)viewPort.getY());
        }
        return transform;
    }

    Rectangle calculateViewPort(SvgDrawContext context) {
        Rectangle currentViewPort = this.outermost ? null : context.getCurrentViewPort();
        float portX = 0.0f;
        float portY = 0.0f;
        float portWidth = 0.0f;
        float portHeight = 0.0f;
        if (this.outermost) {
            PdfStream contentStream = context.getCurrentCanvas().getContentStream();
            if (!contentStream.containsKey(PdfName.BBox)) {
                throw new SvgProcessingException("The root svg tag needs to have a bounding box defined.");
            }
            PdfArray bboxArray = contentStream.getAsArray(PdfName.BBox);
            portX = bboxArray.getAsNumber(0).floatValue();
            portY = bboxArray.getAsNumber(1).floatValue();
            portWidth = bboxArray.getAsNumber(2).floatValue() - portX;
            portHeight = bboxArray.getAsNumber(3).floatValue() - portY;
        } else {
            portX = currentViewPort.getX();
            portY = currentViewPort.getY();
            portWidth = currentViewPort.getWidth();
            portHeight = currentViewPort.getHeight();
        }
        if (this.attributesAndStyles != null && !this.outermost) {
            if (this.attributesAndStyles.containsKey("x")) {
                portX = CssUtils.parseAbsoluteLength((String)((String)this.attributesAndStyles.get("x")));
            }
            if (this.attributesAndStyles.containsKey("y")) {
                portY = CssUtils.parseAbsoluteLength((String)((String)this.attributesAndStyles.get("y")));
            }
            if (this.attributesAndStyles.containsKey("width")) {
                portWidth = CssUtils.parseAbsoluteLength((String)((String)this.attributesAndStyles.get("width")));
            }
            if (this.attributesAndStyles.containsKey("height")) {
                portHeight = CssUtils.parseAbsoluteLength((String)((String)this.attributesAndStyles.get("height")));
            }
        }
        return new Rectangle(portX, portY, portWidth, portHeight);
    }
}

