/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Matrix;
import com.itextpdf.kernel.geom.NoninvertibleTransformException;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.svg.renderers.IBranchSvgNodeRenderer;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.MarkerSvgNodeRenderer;
import com.itextpdf.svg.utils.SvgCssUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBranchSvgNodeRenderer
extends AbstractSvgNodeRenderer
implements IBranchSvgNodeRenderer {
    protected static final int VIEWBOX_VALUES_NUMBER = 4;
    private final List<ISvgNodeRenderer> children = new ArrayList<ISvgNodeRenderer>();
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBranchSvgNodeRenderer.class);

    @Override
    protected void doDraw(SvgDrawContext context) {
        if (this.getChildren().size() > 0) {
            PdfStream stream = new PdfStream();
            stream.put(PdfName.Type, (PdfObject)PdfName.XObject);
            stream.put(PdfName.Subtype, (PdfObject)PdfName.Form);
            PdfFormXObject xObject = (PdfFormXObject)PdfXObject.makeXObject((PdfStream)stream);
            PdfCanvas newCanvas = new PdfCanvas(xObject, context.getCurrentCanvas().getDocument());
            this.applyViewBox(context);
            boolean overflowVisible = AbstractBranchSvgNodeRenderer.isOverflowVisible(this);
            if (this instanceof MarkerSvgNodeRenderer && overflowVisible) {
                AbstractBranchSvgNodeRenderer.writeBBoxAccordingToVisibleOverflow(context, stream);
            } else {
                Rectangle bbBox = context.getCurrentViewPort().clone();
                stream.put(PdfName.BBox, (PdfObject)new PdfArray(bbBox));
            }
            if (this instanceof MarkerSvgNodeRenderer) {
                ((MarkerSvgNodeRenderer)this).applyMarkerAttributes(context);
            }
            context.pushCanvas(newCanvas);
            if (!(this instanceof MarkerSvgNodeRenderer) || !overflowVisible) {
                this.applyViewportClip(context);
            }
            this.applyViewportTranslationCorrection(context);
            for (ISvgNodeRenderer child : this.getChildren()) {
                if (child instanceof MarkerSvgNodeRenderer) continue;
                newCanvas.saveState();
                child.draw(context);
                newCanvas.restoreState();
            }
            this.cleanUp(context);
            context.getCurrentCanvas().addXObject((PdfXObject)xObject, 0.0f, 0.0f);
        }
    }

    void applyViewBox(SvgDrawContext context) {
        float[] viewBoxValues = this.getViewBoxValues();
        if (viewBoxValues.length < 4) {
            float[] values = new float[]{0.0f, 0.0f, context.getCurrentViewPort().getWidth(), context.getCurrentViewPort().getHeight()};
            Rectangle currentViewPort = context.getCurrentViewPort();
            this.calculateAndApplyViewBox(context, values, currentViewPort);
        } else {
            Rectangle currentViewPort = context.getCurrentViewPort();
            this.calculateAndApplyViewBox(context, viewBoxValues, currentViewPort);
        }
    }

    String[] retrieveAlignAndMeet() {
        String meetOrSlice = "meet";
        String align = "xmidymid";
        String preserveAspectRatioValue = (String)this.attributesAndStyles.get("preserveAspectRatio");
        if (preserveAspectRatioValue == null) {
            preserveAspectRatioValue = (String)this.attributesAndStyles.get("preserveAspectRatio".toLowerCase());
        }
        if (this.attributesAndStyles.containsKey("preserveAspectRatio") || this.attributesAndStyles.containsKey("preserveAspectRatio".toLowerCase())) {
            List<String> aspectRatioValuesSplitValues = SvgCssUtils.splitValueList(preserveAspectRatioValue);
            align = aspectRatioValuesSplitValues.get(0).toLowerCase();
            if (aspectRatioValuesSplitValues.size() > 1) {
                meetOrSlice = aspectRatioValuesSplitValues.get(1).toLowerCase();
            }
        }
        if (this instanceof MarkerSvgNodeRenderer && !"none".equals(align) && "meet".equals(meetOrSlice)) {
            align = "xminymin";
        }
        return new String[]{align, meetOrSlice};
    }

    private void applyViewportClip(SvgDrawContext context) {
        PdfCanvas currentCanvas = context.getCurrentCanvas();
        currentCanvas.rectangle(context.getCurrentViewPort());
        currentCanvas.clip();
        currentCanvas.endPath();
    }

    private void applyViewportTranslationCorrection(SvgDrawContext context) {
        boolean preserveAspectRationNone;
        PdfCanvas currentCanvas = context.getCurrentCanvas();
        AffineTransform tf = this.calculateViewPortTranslation(context);
        boolean bl = preserveAspectRationNone = "none".equals(this.getAttribute("preserveAspectRatio")) || "none".equals(this.getAttribute("preserveAspectRatio".toLowerCase()));
        if (!tf.isIdentity() && preserveAspectRationNone) {
            currentCanvas.concatMatrix(tf);
        }
    }

    AffineTransform processAspectRatioPosition(SvgDrawContext context, float[] viewBoxValues, String align, float scaleWidth, float scaleHeight) {
        AffineTransform transform = new AffineTransform();
        Rectangle currentViewPort = context.getCurrentViewPort();
        float midXBox = viewBoxValues[0] + viewBoxValues[2] / 2.0f;
        float midYBox = viewBoxValues[1] + viewBoxValues[3] / 2.0f;
        float midXPort = currentViewPort.getX() + currentViewPort.getWidth() / 2.0f;
        float midYPort = currentViewPort.getY() + currentViewPort.getHeight() / 2.0f;
        float x = 0.0f;
        float y = 0.0f;
        if (this.attributesAndStyles.containsKey("x")) {
            x = CssDimensionParsingUtils.parseAbsoluteLength((String)((String)this.attributesAndStyles.get("x")));
        }
        if (this.attributesAndStyles.containsKey("y")) {
            y = CssDimensionParsingUtils.parseAbsoluteLength((String)((String)this.attributesAndStyles.get("y")));
        }
        if (!(this instanceof MarkerSvgNodeRenderer)) {
            x -= currentViewPort.getX();
            y -= currentViewPort.getY();
        }
        switch (align.toLowerCase()) {
            case "none": {
                break;
            }
            case "xminymin": {
                x -= viewBoxValues[0];
                y -= viewBoxValues[1];
                break;
            }
            case "xminymid": {
                x -= viewBoxValues[0];
                y += midYPort - midYBox;
                break;
            }
            case "xminymax": {
                x -= viewBoxValues[0];
                y += currentViewPort.getHeight() - viewBoxValues[3];
                break;
            }
            case "xmidymin": {
                x += midXPort - midXBox;
                y -= viewBoxValues[1];
                break;
            }
            case "xmidymax": {
                x += midXPort - midXBox;
                y += currentViewPort.getHeight() - viewBoxValues[3];
                break;
            }
            case "xmaxymin": {
                x += currentViewPort.getWidth() - viewBoxValues[2];
                y -= viewBoxValues[1];
                break;
            }
            case "xmaxymid": {
                x += currentViewPort.getWidth() - viewBoxValues[2];
                y += midYPort - midYBox;
                break;
            }
            case "xmaxymax": {
                x += currentViewPort.getWidth() - viewBoxValues[2];
                y += currentViewPort.getHeight() - viewBoxValues[3];
                break;
            }
            default: {
                x += midXPort - midXBox;
                y += midYPort - midYBox;
            }
        }
        transform.translate((double)(x /= scaleWidth), (double)(y /= scaleHeight));
        return transform;
    }

    private void cleanUp(SvgDrawContext context) {
        if (this.getParent() != null) {
            context.removeCurrentViewPort();
        }
        context.popCanvas();
    }

    @Override
    public final void addChild(ISvgNodeRenderer child) {
        if (child != null) {
            this.children.add(child);
        }
    }

    @Override
    public final List<ISvgNodeRenderer> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    protected final void deepCopyChildren(AbstractBranchSvgNodeRenderer deepCopy) {
        for (ISvgNodeRenderer child : this.children) {
            ISvgNodeRenderer newChild = child.createDeepCopy();
            child.setParent(deepCopy);
            deepCopy.addChild(newChild);
        }
    }

    @Override
    void postDraw(SvgDrawContext context) {
    }

    @Override
    public abstract ISvgNodeRenderer createDeepCopy();

    @Override
    void setPartOfClipPath(boolean isPart) {
        super.setPartOfClipPath(isPart);
        for (ISvgNodeRenderer child : this.children) {
            if (!(child instanceof AbstractSvgNodeRenderer)) continue;
            ((AbstractSvgNodeRenderer)child).setPartOfClipPath(isPart);
        }
    }

    void calculateAndApplyViewBox(SvgDrawContext context, float[] values, Rectangle currentViewPort) {
        boolean forceUniformScaling;
        String[] alignAndMeet = this.retrieveAlignAndMeet();
        String align = alignAndMeet[0];
        String meetOrSlice = alignAndMeet[1];
        float scaleWidth = currentViewPort.getWidth() / values[2];
        float scaleHeight = currentViewPort.getHeight() / values[3];
        boolean bl = forceUniformScaling = !"none".equals(align);
        if (forceUniformScaling) {
            scaleWidth = "meet".equals(meetOrSlice) ? Math.min(scaleWidth, scaleHeight) : Math.max(scaleWidth, scaleHeight);
            scaleHeight = scaleWidth;
        }
        AffineTransform scale = AffineTransform.getScaleInstance((double)scaleWidth, (double)scaleHeight);
        float[] scaledViewBoxValues = AbstractBranchSvgNodeRenderer.scaleViewBoxValues(values, scaleWidth, scaleHeight);
        AffineTransform transform = this.processAspectRatioPosition(context, scaledViewBoxValues, align, scaleWidth, scaleHeight);
        if (!scale.isIdentity()) {
            context.getCurrentCanvas().concatMatrix(scale);
            context.getCurrentViewPort().setWidth(currentViewPort.getWidth() / scaleWidth).setX(currentViewPort.getX() / scaleWidth).setHeight(currentViewPort.getHeight() / scaleHeight).setY(currentViewPort.getY() / scaleHeight);
        }
        if (!transform.isIdentity()) {
            context.getCurrentCanvas().concatMatrix(transform);
            context.getCurrentViewPort().setX(currentViewPort.getX() + -1.0f * (float)transform.getTranslateX()).setY(currentViewPort.getY() + -1.0f * (float)transform.getTranslateY());
        }
    }

    float[] getViewBoxValues() {
        if (this.attributesAndStyles == null) {
            return new float[0];
        }
        String viewBoxValues = (String)this.attributesAndStyles.get("viewBox");
        if (viewBoxValues == null) {
            viewBoxValues = (String)this.attributesAndStyles.get("viewBox".toLowerCase());
        }
        if (viewBoxValues == null) {
            return new float[0];
        }
        List<String> valueStrings = SvgCssUtils.splitValueList(viewBoxValues);
        float[] values = new float[valueStrings.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = CssDimensionParsingUtils.parseAbsoluteLength((String)valueStrings.get(i));
        }
        if (values.length != 4) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn(MessageFormatUtil.format((String)"The viewBox value must be 4 numbers. This viewBox=\"{0}\" will not be processed.", (Object[])new Object[]{viewBoxValues}));
            }
            return new float[0];
        }
        if (values[2] < 0.0f || values[3] < 0.0f) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn(MessageFormatUtil.format((String)"The viewBox width and height cannot be negative. This viewBox=\"{0}\" will not be processed.", (Object[])new Object[]{viewBoxValues}));
            }
            return new float[0];
        }
        return values;
    }

    private static float[] scaleViewBoxValues(float[] values, float scaleWidth, float scaleHeight) {
        float[] scaledViewBoxValues = new float[values.length];
        scaledViewBoxValues[0] = values[0] * scaleWidth;
        scaledViewBoxValues[1] = values[1] * scaleHeight;
        scaledViewBoxValues[2] = values[2] * scaleWidth;
        scaledViewBoxValues[3] = values[3] * scaleHeight;
        return scaledViewBoxValues;
    }

    private static boolean isOverflowVisible(AbstractSvgNodeRenderer currentElement) {
        return "visible".equals(currentElement.attributesAndStyles.get("overflow")) || "auto".equals(currentElement.attributesAndStyles.get("overflow"));
    }

    private static void writeBBoxAccordingToVisibleOverflow(SvgDrawContext context, PdfStream stream) {
        ArrayList<PdfCanvas> canvases = new ArrayList<PdfCanvas>();
        int canvasesSize = context.size();
        for (int i = 0; i < canvasesSize; ++i) {
            canvases.add(context.popCanvas());
        }
        AffineTransform transform = new AffineTransform();
        for (int i = canvases.size() - 1; i >= 0; --i) {
            PdfCanvas canvas = (PdfCanvas)canvases.get(i);
            Matrix matrix = canvas.getGraphicsState().getCtm();
            transform.concatenate(new AffineTransform((double)matrix.get(0), (double)matrix.get(1), (double)matrix.get(3), (double)matrix.get(4), (double)matrix.get(6), (double)matrix.get(7)));
            context.pushCanvas(canvas);
        }
        try {
            transform = transform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            stream.put(PdfName.BBox, (PdfObject)new PdfArray(new Rectangle(0.0f, 0.0f, 0.0f, 0.0f)));
            Logger logger = LoggerFactory.getLogger(AbstractBranchSvgNodeRenderer.class);
            logger.warn("Unable to get inverse transformation matrix and thus calculate a viewport for the element because some of the transformation matrices, which are written to document, have a determinant of zero value. A bbox of zero values will be used as a viewport for this element.");
            return;
        }
        Point[] points = context.getRootViewPort().toPointsArray();
        transform.transform(points, 0, points, 0, points.length);
        Rectangle bbox = Rectangle.calculateBBox(Arrays.asList(points));
        stream.put(PdfName.BBox, (PdfObject)new PdfArray(bbox));
    }
}

