/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.css.impl;

import com.itextpdf.styledxmlparser.util.StyleUtil;
import com.itextpdf.svg.css.SvgCssContext;
import com.itextpdf.svg.css.impl.SvgStyleResolver;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.AbstractBranchSvgNodeRenderer;
import java.util.HashMap;
import java.util.Map;

public final class SvgNodeRendererInheritanceResolver {
    private SvgNodeRendererInheritanceResolver() {
    }

    public static void applyInheritanceToSubTree(ISvgNodeRenderer root, ISvgNodeRenderer subTree, SvgCssContext cssContext) {
        SvgNodeRendererInheritanceResolver.applyStyles(root, subTree, cssContext);
        if (subTree instanceof AbstractBranchSvgNodeRenderer) {
            AbstractBranchSvgNodeRenderer subTreeAsBranch = (AbstractBranchSvgNodeRenderer)subTree;
            for (ISvgNodeRenderer child : subTreeAsBranch.getChildren()) {
                SvgNodeRendererInheritanceResolver.applyInheritanceToSubTree(subTreeAsBranch, child, cssContext);
            }
        }
    }

    private static void applyStyles(ISvgNodeRenderer parent, ISvgNodeRenderer child, SvgCssContext cssContext) {
        if (parent != null && child != null) {
            Map childStyles = child.getAttributeMapCopy();
            if (childStyles == null) {
                childStyles = new HashMap<String, String>();
            }
            Map<String, String> parentStyles = parent.getAttributeMapCopy();
            String parentFontSize = parent.getAttribute("font-size");
            for (Map.Entry<String, String> parentAttribute : parentStyles.entrySet()) {
                childStyles = StyleUtil.mergeParentStyleDeclaration(childStyles, (String)parentAttribute.getKey(), (String)parentAttribute.getValue(), (String)parentFontSize, SvgStyleResolver.INHERITANCE_RULES);
            }
            SvgStyleResolver.resolveFontSizeStyle(childStyles, cssContext, parentFontSize);
            child.setAttributesAndStyles(childStyles);
        }
    }
}

