/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.extgstate.PdfExtGState;
import com.itextpdf.layout.properties.TransparentColor;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.parse.CssDeclarationValueTokenizer;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.styledxmlparser.css.validate.CssDeclarationValidationMaster;
import com.itextpdf.svg.MarkerVertexType;
import com.itextpdf.svg.css.impl.SvgNodeRendererInheritanceResolver;
import com.itextpdf.svg.renderers.IMarkerCapable;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.ISvgPaintServer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.ClipPathSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.ISvgTextNodeRenderer;
import com.itextpdf.svg.utils.TransformUtils;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractSvgNodeRenderer
implements ISvgNodeRenderer {
    private static final MarkerVertexType[] MARKER_VERTEX_TYPES = new MarkerVertexType[]{MarkerVertexType.MARKER_START, MarkerVertexType.MARKER_END};
    protected Map<String, String> attributesAndStyles;
    boolean partOfClipPath;
    boolean doFill = false;
    boolean doStroke = false;
    private ISvgNodeRenderer parent;

    @Override
    public void setParent(ISvgNodeRenderer parent) {
        this.parent = parent;
    }

    @Override
    public ISvgNodeRenderer getParent() {
        return this.parent;
    }

    @Override
    public void setAttributesAndStyles(Map<String, String> attributesAndStyles) {
        this.attributesAndStyles = attributesAndStyles;
    }

    @Override
    public String getAttribute(String key) {
        return this.attributesAndStyles.get(key);
    }

    public String getAttributeOrDefault(String key, String defaultValue) {
        String rawValue = this.getAttribute(key);
        return rawValue != null ? rawValue : defaultValue;
    }

    @Override
    public void setAttribute(String key, String value) {
        if (this.attributesAndStyles == null) {
            this.attributesAndStyles = new HashMap<String, String>();
        }
        this.attributesAndStyles.put(key, value);
    }

    @Override
    public Map<String, String> getAttributeMapCopy() {
        HashMap<String, String> copy = new HashMap<String, String>();
        if (this.attributesAndStyles == null) {
            return copy;
        }
        copy.putAll(this.attributesAndStyles);
        return copy;
    }

    @Override
    public final void draw(SvgDrawContext context) {
        PdfCanvas currentCanvas = context.getCurrentCanvas();
        if (this.attributesAndStyles != null) {
            AffineTransform transformation;
            String transformString = this.attributesAndStyles.get("transform");
            if (transformString != null && !transformString.isEmpty() && !(transformation = TransformUtils.parseTransform(transformString)).isIdentity()) {
                currentCanvas.concatMatrix(transformation);
            }
            if (this.attributesAndStyles.containsKey("id")) {
                context.addUsedId(this.attributesAndStyles.get("id"));
            }
        }
        if (!this.drawInClipPath(context)) {
            this.preDraw(context);
            this.doDraw(context);
            this.postDraw(context);
        }
        if (this.attributesAndStyles.containsKey("id")) {
            context.removeUsedId(this.attributesAndStyles.get("id"));
        }
    }

    protected boolean canElementFill() {
        return true;
    }

    public boolean canConstructViewPort() {
        return false;
    }

    public float getCurrentFontSize() {
        return CssDimensionParsingUtils.parseAbsoluteFontSize((String)this.getAttribute("font-size"));
    }

    protected void deepCopyAttributesAndStyles(ISvgNodeRenderer deepCopy) {
        HashMap<String, String> stylesDeepCopy = new HashMap<String, String>();
        if (this.attributesAndStyles != null) {
            stylesDeepCopy.putAll(this.attributesAndStyles);
            deepCopy.setAttributesAndStyles(stylesDeepCopy);
        }
    }

    protected abstract void doDraw(SvgDrawContext var1);

    AffineTransform calculateViewPortTranslation(SvgDrawContext context) {
        Rectangle viewPort = context.getCurrentViewPort();
        AffineTransform transform = AffineTransform.getTranslateInstance((double)viewPort.getX(), (double)viewPort.getY());
        return transform;
    }

    void postDraw(SvgDrawContext context) {
        if (this.attributesAndStyles != null) {
            PdfCanvas currentCanvas = context.getCurrentCanvas();
            if (this.partOfClipPath) {
                if ("evenodd".equalsIgnoreCase(this.getAttribute("clip-rule"))) {
                    currentCanvas.eoClip();
                } else {
                    currentCanvas.clip();
                }
                currentCanvas.endPath();
            } else if (!(this instanceof ISvgTextNodeRenderer)) {
                if (this.doFill && this.canElementFill()) {
                    String fillRuleRawValue = this.getAttribute("fill-rule");
                    if ("evenodd".equalsIgnoreCase(fillRuleRawValue)) {
                        if (this.doStroke) {
                            currentCanvas.eoFillStroke();
                        } else {
                            currentCanvas.eoFill();
                        }
                    } else if (this.doStroke) {
                        currentCanvas.fillStroke();
                    } else {
                        currentCanvas.fill();
                    }
                } else if (this.doStroke) {
                    currentCanvas.stroke();
                } else {
                    currentCanvas.endPath();
                }
            }
            if (this instanceof IMarkerCapable) {
                for (MarkerVertexType markerVertexType : MARKER_VERTEX_TYPES) {
                    if (!this.attributesAndStyles.containsKey(markerVertexType.toString())) continue;
                    currentCanvas.saveState();
                    ((IMarkerCapable)((Object)this)).drawMarker(context, markerVertexType);
                    currentCanvas.restoreState();
                }
            }
        }
    }

    void setPartOfClipPath(boolean value) {
        this.partOfClipPath = value;
    }

    void preDraw(SvgDrawContext context) {
        if (this.attributesAndStyles != null) {
            PdfCanvas currentCanvas = context.getCurrentCanvas();
            PdfExtGState opacityGraphicsState = new PdfExtGState();
            if (!this.partOfClipPath) {
                String strokeRawValue;
                float generalOpacity = this.getOpacity();
                String fillRawValue = this.getAttributeOrDefault("fill", "black");
                boolean bl = this.doFill = !"none".equalsIgnoreCase(fillRawValue);
                if (this.doFill && this.canElementFill()) {
                    float fillOpacity = this.getOpacityByAttributeName("fill-opacity", generalOpacity);
                    Color fillColor = null;
                    TransparentColor transparentColor = this.getColorFromAttributeValue(context, fillRawValue, 0.0f, fillOpacity);
                    if (transparentColor != null) {
                        fillColor = transparentColor.getColor();
                        fillOpacity = transparentColor.getOpacity();
                    }
                    if (!CssUtils.compareFloats((float)fillOpacity, (float)1.0f)) {
                        opacityGraphicsState.setFillOpacity(fillOpacity);
                    }
                    if (fillColor == null) {
                        fillColor = ColorConstants.BLACK;
                    }
                    currentCanvas.setFillColor(fillColor);
                }
                if (!"none".equalsIgnoreCase(strokeRawValue = this.getAttributeOrDefault("stroke", "none"))) {
                    String strokeWidthRawValue = this.getAttribute("stroke-width");
                    float strokeWidth = 0.75f;
                    if (strokeWidthRawValue != null) {
                        strokeWidth = CssDimensionParsingUtils.parseAbsoluteLength((String)strokeWidthRawValue);
                    }
                    float strokeOpacity = this.getOpacityByAttributeName("stroke-opacity", generalOpacity);
                    Color strokeColor = null;
                    TransparentColor transparentColor = this.getColorFromAttributeValue(context, strokeRawValue, (float)((double)strokeWidth / 2.0), strokeOpacity);
                    if (transparentColor != null) {
                        strokeColor = transparentColor.getColor();
                        strokeOpacity = transparentColor.getOpacity();
                    }
                    if (!CssUtils.compareFloats((float)strokeOpacity, (float)1.0f)) {
                        opacityGraphicsState.setStrokeOpacity(strokeOpacity);
                    }
                    if (strokeColor != null) {
                        currentCanvas.setStrokeColor(strokeColor);
                    }
                    currentCanvas.setLineWidth(strokeWidth);
                    this.doStroke = true;
                }
                if (!((PdfDictionary)opacityGraphicsState.getPdfObject()).isEmpty()) {
                    currentCanvas.setExtGState(opacityGraphicsState);
                }
            }
        }
    }

    protected float parseAbsoluteLength(String length, float percentRelativeValue, float defaultValue, SvgDrawContext context) {
        float rem;
        if (CssTypesValidationUtils.isPercentageValue((String)length)) {
            return CssDimensionParsingUtils.parseRelativeValue((String)length, (float)percentRelativeValue);
        }
        float em = this.getCurrentFontSize();
        UnitValue unitValue = CssDimensionParsingUtils.parseLengthValueToPt((String)length, (float)em, (float)(rem = context.getCssContext().getRootFontSize()));
        if (unitValue != null && unitValue.isPointValue()) {
            return unitValue.getValue();
        }
        return defaultValue;
    }

    private TransparentColor getColorFromAttributeValue(SvgDrawContext context, String rawColorValue, float objectBoundingBoxMargin, float parentOpacity) {
        String value;
        if (rawColorValue == null) {
            return null;
        }
        CssDeclarationValueTokenizer tokenizer = new CssDeclarationValueTokenizer(rawColorValue);
        CssDeclarationValueTokenizer.Token token = tokenizer.getNextValidToken();
        if (token == null) {
            return null;
        }
        String tokenValue = token.getValue();
        if (tokenValue.startsWith("url(#") && tokenValue.endsWith(")")) {
            Color resolvedColor = null;
            float resolvedOpacity = 1.0f;
            String normalizedName = tokenValue.substring(5, tokenValue.length() - 1).trim();
            ISvgNodeRenderer colorRenderer = context.getNamedObject(normalizedName);
            if (colorRenderer instanceof ISvgPaintServer) {
                resolvedColor = ((ISvgPaintServer)colorRenderer).createColor(context, this.getObjectBoundingBox(context), objectBoundingBoxMargin, parentOpacity);
            }
            if (resolvedColor != null) {
                return new TransparentColor(resolvedColor, resolvedOpacity);
            }
            token = tokenizer.getNextValidToken();
        }
        if (token != null && !"none".equalsIgnoreCase(value = token.getValue())) {
            if (!CssDeclarationValidationMaster.checkDeclaration((CssDeclaration)new CssDeclaration("color", value))) {
                return new TransparentColor((Color)new DeviceRgb(0.0f, 0.0f, 0.0f), 1.0f);
            }
            TransparentColor result = CssDimensionParsingUtils.parseColor((String)value);
            return new TransparentColor(result.getColor(), result.getOpacity() * parentOpacity);
        }
        return null;
    }

    private float getOpacityByAttributeName(String attributeName, float generalOpacity) {
        float opacity = generalOpacity;
        String opacityValue = this.getAttribute(attributeName);
        if (opacityValue != null && !"none".equalsIgnoreCase(opacityValue)) {
            opacity *= Float.valueOf(opacityValue).floatValue();
        }
        return opacity;
    }

    private boolean drawInClipPath(SvgDrawContext context) {
        String clipPathName;
        ISvgNodeRenderer template;
        if (this.attributesAndStyles.containsKey("clip-path") && (template = context.getNamedObject(this.normalizeLocalUrlName(clipPathName = this.attributesAndStyles.get("clip-path")))) instanceof ClipPathSvgNodeRenderer) {
            ClipPathSvgNodeRenderer clipPath = (ClipPathSvgNodeRenderer)template.createDeepCopy();
            SvgNodeRendererInheritanceResolver.applyInheritanceToSubTree(this, clipPath, context.getCssContext());
            clipPath.setClippedRenderer(this);
            clipPath.draw(context);
            return !clipPath.getChildren().isEmpty();
        }
        return false;
    }

    private String normalizeLocalUrlName(String name) {
        return name.replace("url(#", "").replace(")", "").trim();
    }

    private float getOpacity() {
        float result = 1.0f;
        String opacityValue = this.getAttribute("opacity");
        if (opacityValue != null && !"none".equalsIgnoreCase(opacityValue)) {
            result = Float.valueOf(opacityValue).floatValue();
        }
        if (this.parent != null && this.parent instanceof AbstractSvgNodeRenderer) {
            result *= ((AbstractSvgNodeRenderer)this.parent).getOpacity();
        }
        return result;
    }
}

