/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import com.itextpdf.svg.utils.DrawUtils;

public class EllipseSvgNodeRenderer
extends AbstractSvgNodeRenderer {
    float cx;
    float cy;
    float rx;
    float ry;

    @Override
    protected void doDraw(SvgDrawContext context) {
        PdfCanvas cv = context.getCurrentCanvas();
        cv.writeLiteral("% ellipse\n");
        if (this.setParameters()) {
            cv.moveTo((double)this.cx + (double)this.rx, (double)this.cy);
            DrawUtils.arc((double)this.cx - (double)this.rx, (double)this.cy - (double)this.ry, (double)this.cx + (double)this.rx, (double)this.cy + (double)this.ry, 0.0, 360.0, cv);
        }
    }

    @Override
    public Rectangle getObjectBoundingBox(SvgDrawContext context) {
        if (this.setParameters()) {
            return new Rectangle(this.cx - this.rx, this.cy - this.ry, this.rx + this.rx, this.ry + this.ry);
        }
        return null;
    }

    protected boolean setParameters() {
        this.cx = 0.0f;
        this.cy = 0.0f;
        if (this.getAttribute("cx") != null) {
            this.cx = CssDimensionParsingUtils.parseAbsoluteLength((String)this.getAttribute("cx"));
        }
        if (this.getAttribute("cy") != null) {
            this.cy = CssDimensionParsingUtils.parseAbsoluteLength((String)this.getAttribute("cy"));
        }
        if (this.getAttribute("rx") == null || !(CssDimensionParsingUtils.parseAbsoluteLength((String)this.getAttribute("rx")) > 0.0f)) {
            return false;
        }
        this.rx = CssDimensionParsingUtils.parseAbsoluteLength((String)this.getAttribute("rx"));
        if (this.getAttribute("ry") == null || !(CssDimensionParsingUtils.parseAbsoluteLength((String)this.getAttribute("ry")) > 0.0f)) {
            return false;
        }
        this.ry = CssDimensionParsingUtils.parseAbsoluteLength((String)this.getAttribute("ry"));
        return true;
    }

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        EllipseSvgNodeRenderer copy = new EllipseSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        return copy;
    }
}

