/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.io.font.FontProgram;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.properties.RenderingMode;
import com.itextpdf.layout.renderer.TextRenderer;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.ISvgTextNodeRenderer;
import com.itextpdf.svg.renderers.impl.TextSvgBranchRenderer;
import com.itextpdf.svg.utils.SvgTextUtil;
import com.itextpdf.svg.utils.TextRectangle;

public class TextLeafSvgNodeRenderer
extends AbstractSvgNodeRenderer
implements ISvgTextNodeRenderer {
    @Override
    public ISvgNodeRenderer createDeepCopy() {
        TextLeafSvgNodeRenderer copy = new TextLeafSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        return copy;
    }

    @Override
    public float getTextContentLength(float parentFontSize, PdfFont font) {
        float contentLength = 0.0f;
        if (font != null && this.attributesAndStyles != null && this.attributesAndStyles.containsKey("text_content")) {
            float fontSize = SvgTextUtil.resolveFontSize(this, parentFontSize);
            String content = (String)this.attributesAndStyles.get("text_content");
            contentLength = font.getWidth(content, fontSize);
        }
        return contentLength;
    }

    @Override
    public float[] getRelativeTranslation() {
        return new float[]{0.0f, 0.0f};
    }

    @Override
    public boolean containsRelativeMove() {
        return false;
    }

    @Override
    public boolean containsAbsolutePositionChange() {
        return false;
    }

    @Override
    public float[][] getAbsolutePositionChanges() {
        float[] part = new float[]{0.0f};
        return new float[][]{part, part};
    }

    @Override
    public TextRectangle getTextRectangle(SvgDrawContext context, Point basePoint) {
        if (this.getParent() instanceof TextSvgBranchRenderer && basePoint != null) {
            float parentFontSize = ((AbstractSvgNodeRenderer)this.getParent()).getCurrentFontSize();
            PdfFont parentFont = ((TextSvgBranchRenderer)this.getParent()).getFont();
            float textLength = this.getTextContentLength(parentFontSize, parentFont);
            float[] fontAscenderDescenderFromMetrics = TextRenderer.calculateAscenderDescender((PdfFont)parentFont, (RenderingMode)RenderingMode.HTML_MODE);
            float fontAscender = FontProgram.convertTextSpaceToGlyphSpace((float)fontAscenderDescenderFromMetrics[0]) * parentFontSize;
            float fontDescender = FontProgram.convertTextSpaceToGlyphSpace((float)fontAscenderDescenderFromMetrics[1]) * parentFontSize;
            float textHeight = fontAscender - fontDescender;
            return new TextRectangle((float)basePoint.getX(), (float)basePoint.getY() - fontAscender, textLength, textHeight, (float)basePoint.getY());
        }
        return null;
    }

    @Override
    public Rectangle getObjectBoundingBox(SvgDrawContext context) {
        return null;
    }

    @Override
    protected void doDraw(SvgDrawContext context) {
        if (this.attributesAndStyles != null && this.attributesAndStyles.containsKey("text_content")) {
            PdfCanvas currentCanvas = context.getCurrentCanvas();
            if (context.getPreviousElementTextMove() == null) {
                currentCanvas.moveText((double)context.getTextMove()[0], (double)context.getTextMove()[1]);
            } else {
                currentCanvas.moveText((double)context.getPreviousElementTextMove()[0], (double)context.getPreviousElementTextMove()[1]);
            }
            currentCanvas.showText((String)this.attributesAndStyles.get("text_content"));
        }
    }

    @Override
    protected boolean canElementFill() {
        return false;
    }
}

