/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.converter;

import com.itextpdf.commons.utils.FileUtil;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.WriterProperties;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.layout.element.Image;
import com.itextpdf.styledxmlparser.node.IDocumentNode;
import com.itextpdf.styledxmlparser.node.INode;
import com.itextpdf.styledxmlparser.node.impl.jsoup.JsoupXmlParser;
import com.itextpdf.styledxmlparser.resolver.resource.ResourceResolver;
import com.itextpdf.svg.exceptions.SvgProcessingException;
import com.itextpdf.svg.processors.ISvgConverterProperties;
import com.itextpdf.svg.processors.ISvgProcessorResult;
import com.itextpdf.svg.processors.impl.DefaultSvgProcessor;
import com.itextpdf.svg.processors.impl.SvgConverterProperties;
import com.itextpdf.svg.processors.impl.SvgProcessorResult;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.PdfRootSvgNodeRenderer;
import com.itextpdf.svg.utils.SvgCssUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SvgConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SvgConverter.class);

    private SvgConverter() {
    }

    private static void checkNull(Object o) {
        if (o == null) {
            throw new SvgProcessingException("Parameters cannot be null.");
        }
    }

    public static void drawOnDocument(String content, PdfDocument document, int pageNo) {
        SvgConverter.drawOnDocument(content, document, pageNo, 0.0f, 0.0f);
    }

    public static void drawOnDocument(String content, PdfDocument document, int pageNo, float x, float y) {
        SvgConverter.checkNull(document);
        SvgConverter.drawOnPage(content, document.getPage(pageNo), x, y);
    }

    public static void drawOnDocument(String content, PdfDocument document, int pageNo, ISvgConverterProperties props) {
        SvgConverter.drawOnDocument(content, document, pageNo, 0.0f, 0.0f, props);
    }

    public static void drawOnDocument(String content, PdfDocument document, int pageNo, float x, float y, ISvgConverterProperties props) {
        SvgConverter.checkNull(document);
        SvgConverter.drawOnPage(content, document.getPage(pageNo), x, y, props);
    }

    public static void drawOnDocument(InputStream stream, PdfDocument document, int pageNo) throws IOException {
        SvgConverter.drawOnDocument(stream, document, pageNo, 0.0f, 0.0f);
    }

    public static void drawOnDocument(InputStream stream, PdfDocument document, int pageNo, float x, float y) throws IOException {
        SvgConverter.checkNull(document);
        SvgConverter.drawOnPage(stream, document.getPage(pageNo), x, y);
    }

    public static void drawOnDocument(InputStream stream, PdfDocument document, int pageNo, ISvgConverterProperties props) throws IOException {
        SvgConverter.drawOnDocument(stream, document, pageNo, 0.0f, 0.0f, props);
    }

    public static void drawOnDocument(InputStream stream, PdfDocument document, int pageNo, float x, float y, ISvgConverterProperties props) throws IOException {
        SvgConverter.checkNull(document);
        SvgConverter.drawOnPage(stream, document.getPage(pageNo), x, y, props);
    }

    public static void drawOnPage(String content, PdfPage page) {
        SvgConverter.drawOnPage(content, page, 0.0f, 0.0f);
    }

    public static void drawOnPage(String content, PdfPage page, float x, float y) {
        SvgConverter.checkNull(page);
        SvgConverter.drawOnCanvas(content, new PdfCanvas(page), x, y);
    }

    public static void drawOnPage(String content, PdfPage page, ISvgConverterProperties props) {
        SvgConverter.drawOnPage(content, page, 0.0f, 0.0f, props);
    }

    public static void drawOnPage(String content, PdfPage page, float x, float y, ISvgConverterProperties props) {
        SvgConverter.checkNull(page);
        SvgConverter.drawOnCanvas(content, new PdfCanvas(page), x, y, props);
    }

    public static void drawOnPage(InputStream stream, PdfPage page) throws IOException {
        SvgConverter.drawOnPage(stream, page, 0.0f, 0.0f);
    }

    public static void drawOnPage(InputStream stream, PdfPage page, float x, float y) throws IOException {
        SvgConverter.checkNull(page);
        SvgConverter.drawOnCanvas(stream, new PdfCanvas(page), x, y);
    }

    public static void drawOnPage(InputStream stream, PdfPage page, ISvgConverterProperties props) throws IOException {
        SvgConverter.drawOnPage(stream, page, 0.0f, 0.0f, props);
    }

    public static void drawOnPage(InputStream stream, PdfPage page, float x, float y, ISvgConverterProperties props) throws IOException {
        SvgConverter.checkNull(page);
        if (props instanceof SvgConverterProperties && ((SvgConverterProperties)props).getCustomViewport() == null) {
            ((SvgConverterProperties)props).setCustomViewport(page.getMediaBox());
        }
        SvgConverter.drawOnCanvas(stream, new PdfCanvas(page), x, y, props);
    }

    public static void drawOnCanvas(String content, PdfCanvas canvas) {
        SvgConverter.drawOnCanvas(content, canvas, 0.0f, 0.0f);
    }

    public static void drawOnCanvas(String content, PdfCanvas canvas, float x, float y) {
        SvgConverter.checkNull(canvas);
        SvgConverter.draw(SvgConverter.convertToXObject(content, canvas.getDocument()), canvas, x, y);
    }

    public static void drawOnCanvas(String content, PdfCanvas canvas, ISvgConverterProperties props) {
        SvgConverter.drawOnCanvas(content, canvas, 0.0f, 0.0f, props);
    }

    public static void drawOnCanvas(String content, PdfCanvas canvas, float x, float y, ISvgConverterProperties props) {
        SvgConverter.checkNull(canvas);
        SvgConverter.draw(SvgConverter.convertToXObject(content, canvas.getDocument(), props), canvas, x, y);
    }

    public static void drawOnCanvas(InputStream stream, PdfCanvas canvas) throws IOException {
        SvgConverter.drawOnCanvas(stream, canvas, 0.0f, 0.0f);
    }

    public static void drawOnCanvas(InputStream stream, PdfCanvas canvas, float x, float y) throws IOException {
        SvgConverter.checkNull(canvas);
        SvgConverter.draw(SvgConverter.convertToXObject(stream, canvas.getDocument()), canvas, x, y);
    }

    public static void drawOnCanvas(InputStream stream, PdfCanvas canvas, ISvgConverterProperties props) throws IOException {
        SvgConverter.drawOnCanvas(stream, canvas, 0.0f, 0.0f, props);
    }

    public static void drawOnCanvas(InputStream stream, PdfCanvas canvas, float x, float y, ISvgConverterProperties props) throws IOException {
        SvgConverter.checkNull(canvas);
        SvgConverter.draw(SvgConverter.convertToXObject(stream, canvas.getDocument(), props), canvas, x, y);
    }

    public static void createPdf(File svgFile, File pdfFile) throws IOException {
        SvgConverter.createPdf(svgFile, pdfFile, null, null);
    }

    public static void createPdf(File svgFile, File pdfFile, ISvgConverterProperties props) throws IOException {
        SvgConverter.createPdf(svgFile, pdfFile, props, null);
    }

    public static void createPdf(File svgFile, File pdfFile, WriterProperties writerProps) throws IOException {
        SvgConverter.createPdf(svgFile, pdfFile, null, writerProps);
    }

    public static void createPdf(File svgFile, File pdfFile, ISvgConverterProperties props, WriterProperties writerProps) throws IOException {
        if (props == null) {
            props = new SvgConverterProperties().setBaseUri(FileUtil.getParentDirectoryUri((File)svgFile));
        } else if (props.getBaseUri() == null || props.getBaseUri().isEmpty()) {
            String baseUri = FileUtil.getParentDirectoryUri((File)svgFile);
            props = SvgConverter.convertToSvgConverterProps(props, baseUri);
        }
        try (InputStream fileInputStream = FileUtil.getInputStreamForFile((String)svgFile.getAbsolutePath());
             OutputStream fileOutputStream = FileUtil.getFileOutputStream((String)pdfFile.getAbsolutePath());){
            SvgConverter.createPdf(fileInputStream, fileOutputStream, props, writerProps);
        }
    }

    private static SvgConverterProperties convertToSvgConverterProps(ISvgConverterProperties props, String baseUri) {
        return new SvgConverterProperties().setBaseUri(baseUri).setMediaDeviceDescription(props.getMediaDeviceDescription()).setFontProvider(props.getFontProvider()).setCharset(props.getCharset()).setRendererFactory(props.getRendererFactory());
    }

    public static void createPdf(InputStream svgStream, OutputStream pdfDest) throws IOException {
        SvgConverter.createPdf(svgStream, pdfDest, null, null);
    }

    public static void createPdf(InputStream svgStream, OutputStream pdfDest, WriterProperties writerProps) throws IOException {
        SvgConverter.createPdf(svgStream, pdfDest, null, writerProps);
    }

    public static void createPdf(InputStream svgStream, OutputStream pdfDest, ISvgConverterProperties props) throws IOException {
        SvgConverter.createPdf(svgStream, pdfDest, props, null);
    }

    public static void createPdf(InputStream svgStream, OutputStream pdfDest, ISvgConverterProperties props, WriterProperties writerProps) throws IOException {
        if (writerProps == null) {
            writerProps = new WriterProperties();
        }
        try (PdfWriter writer = new PdfWriter(pdfDest, writerProps);
             PdfDocument pdfDocument = new PdfDocument(writer);){
            ISvgProcessorResult processorResult = SvgConverter.process(SvgConverter.parse(svgStream, props), props);
            ResourceResolver resourceResolver = SvgConverter.getResourceResolver(processorResult, props);
            SvgDrawContext drawContext = new SvgDrawContext(resourceResolver, processorResult.getFontProvider());
            if (processorResult instanceof SvgProcessorResult) {
                drawContext.setCssContext(((SvgProcessorResult)processorResult).getContext().getCssContext());
            }
            drawContext.addNamedObjects(processorResult.getNamedObjects());
            drawContext.setTempFonts(processorResult.getTempFonts());
            ISvgNodeRenderer topSvgRenderer = processorResult.getRootRenderer();
            SvgConverter.checkNull(topSvgRenderer);
            SvgConverter.checkNull(pdfDocument);
            float em = drawContext.getCssContext().getRootFontSize();
            Rectangle wh = SvgCssUtils.extractWidthAndHeight(topSvgRenderer, em, drawContext);
            pdfDocument.setDefaultPageSize(new PageSize(wh.getWidth(), wh.getHeight()));
            PdfPage page = pdfDocument.addNewPage();
            PdfCanvas pageCanvas = new PdfCanvas(page);
            PdfFormXObject xObject = SvgConverter.convertToXObject(topSvgRenderer, pdfDocument, drawContext);
            SvgConverter.draw(xObject, pageCanvas);
        }
    }

    public static PdfFormXObject convertToXObject(String content, PdfDocument document) {
        return SvgConverter.convertToXObject(content, document, null);
    }

    public static PdfFormXObject convertToXObject(String content, PdfDocument document, ISvgConverterProperties props) {
        SvgConverter.checkNull(content);
        SvgConverter.checkNull(document);
        return SvgConverter.convertToXObject(SvgConverter.process(SvgConverter.parse(content), props), document, props);
    }

    public static PdfFormXObject convertToXObject(InputStream stream, PdfDocument document, ISvgConverterProperties props) throws IOException {
        SvgConverter.checkNull(stream);
        SvgConverter.checkNull(document);
        return SvgConverter.convertToXObject(SvgConverter.process(SvgConverter.parse(stream, props), props), document, props);
    }

    private static PdfFormXObject convertToXObject(ISvgProcessorResult processorResult, PdfDocument document, ISvgConverterProperties props) {
        ResourceResolver resourceResolver = SvgConverter.getResourceResolver(processorResult, props);
        SvgDrawContext drawContext = new SvgDrawContext(resourceResolver, processorResult.getFontProvider());
        if (processorResult instanceof SvgProcessorResult) {
            drawContext.setCssContext(((SvgProcessorResult)processorResult).getContext().getCssContext());
        }
        if (props instanceof SvgConverterProperties) {
            drawContext.setCustomViewport(((SvgConverterProperties)props).getCustomViewport());
        }
        drawContext.setTempFonts(processorResult.getTempFonts());
        drawContext.addNamedObjects(processorResult.getNamedObjects());
        return SvgConverter.convertToXObject(processorResult.getRootRenderer(), document, drawContext);
    }

    public static PdfFormXObject convertToXObject(InputStream stream, PdfDocument document) throws IOException {
        return SvgConverter.convertToXObject(stream, document, null);
    }

    public static Image convertToImage(InputStream stream, PdfDocument document) throws IOException {
        return new Image(SvgConverter.convertToXObject(stream, document));
    }

    public static Image convertToImage(InputStream stream, PdfDocument document, ISvgConverterProperties props) throws IOException {
        return new Image(SvgConverter.convertToXObject(stream, document, props));
    }

    private static void draw(PdfFormXObject pdfForm, PdfCanvas canvas) {
        SvgConverter.draw(pdfForm, canvas, 0.0f, 0.0f);
    }

    static void draw(PdfFormXObject pdfForm, PdfCanvas canvas, float x, float y) {
        canvas.addXObjectAt((PdfXObject)pdfForm, x + (pdfForm.getBBox() == null ? 0.0f : pdfForm.getBBox().getAsNumber(0).floatValue()), y + (pdfForm.getBBox() == null ? 0.0f : pdfForm.getBBox().getAsNumber(1).floatValue()));
    }

    public static PdfFormXObject convertToXObject(ISvgNodeRenderer topSvgRenderer, PdfDocument document) {
        return SvgConverter.convertToXObject(topSvgRenderer, document, new SvgDrawContext(null, null));
    }

    private static PdfFormXObject convertToXObject(ISvgNodeRenderer topSvgRenderer, PdfDocument document, SvgDrawContext context) {
        SvgConverter.checkNull(topSvgRenderer);
        SvgConverter.checkNull(document);
        SvgConverter.checkNull(context);
        float em = context.getCssContext().getRootFontSize();
        Rectangle bbox = SvgCssUtils.extractWidthAndHeight(topSvgRenderer, em, context);
        PdfFormXObject pdfForm = new PdfFormXObject(bbox);
        PdfCanvas canvas = new PdfCanvas(pdfForm, document);
        context.pushCanvas(canvas);
        PdfRootSvgNodeRenderer root = new PdfRootSvgNodeRenderer(topSvgRenderer);
        root.draw(context);
        return pdfForm;
    }

    public static ISvgProcessorResult parseAndProcess(InputStream svgStream) {
        return SvgConverter.parseAndProcess(svgStream, null);
    }

    public static ISvgProcessorResult parseAndProcess(InputStream svgStream, ISvgConverterProperties props) {
        IDocumentNode nodeTree;
        JsoupXmlParser parser = new JsoupXmlParser();
        String charset = SvgConverter.tryToExtractCharset(props);
        try {
            nodeTree = parser.parse(svgStream, charset);
        }
        catch (Exception e) {
            throw new SvgProcessingException("Failed to parse InputStream.", e);
        }
        return new DefaultSvgProcessor().process((INode)nodeTree, props);
    }

    public static ISvgProcessorResult process(INode root, ISvgConverterProperties props) {
        SvgConverter.checkNull(root);
        return new DefaultSvgProcessor().process(root, props);
    }

    public static INode parse(String content) {
        SvgConverter.checkNull(content);
        return new JsoupXmlParser().parse(content);
    }

    public static INode parse(InputStream stream) throws IOException {
        SvgConverter.checkNull(stream);
        return SvgConverter.parse(stream, null);
    }

    public static INode parse(InputStream stream, ISvgConverterProperties props) throws IOException {
        SvgConverter.checkNull(stream);
        JsoupXmlParser xmlParser = new JsoupXmlParser();
        return xmlParser.parse(stream, SvgConverter.tryToExtractCharset(props));
    }

    @Deprecated
    public static float[] extractWidthAndHeight(ISvgNodeRenderer topSvgRenderer) {
        SvgDrawContext context = new SvgDrawContext(null, null);
        float em = context.getCssContext().getRootFontSize();
        Rectangle rectangle = SvgCssUtils.extractWidthAndHeight(topSvgRenderer, em, context);
        return new float[]{rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight()};
    }

    static ResourceResolver getResourceResolver(ISvgProcessorResult processorResult, ISvgConverterProperties props) {
        if (processorResult instanceof SvgProcessorResult) {
            return ((SvgProcessorResult)processorResult).getContext().getResourceResolver();
        }
        return SvgConverter.createResourceResolver(props);
    }

    private static String tryToExtractCharset(ISvgConverterProperties props) {
        return props != null ? props.getCharset() : null;
    }

    private static ResourceResolver createResourceResolver(ISvgConverterProperties props) {
        if (props == null) {
            return new ResourceResolver(null);
        }
        return new ResourceResolver(props.getBaseUri(), props.getResourceRetriever());
    }
}

