/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tag
implements Iterable<Tag> {
    private Tag parent;
    private final String tag;
    private final Map<String, String> attributes;
    private Map<String, String> css;
    private final List<Tag> children;
    private final String ns;

    public Tag(String tag, Map<String, String> attr) {
        this(tag, attr, new HashMap<String, String>(0), "");
    }

    public Tag(String tag) {
        this(tag, new HashMap<String, String>(0), new HashMap<String, String>(0), "");
    }

    public Tag(String tag, Map<String, String> attr, Map<String, String> css, String ns) {
        this.tag = tag;
        this.attributes = attr;
        this.css = css;
        this.children = new ArrayList<Tag>(0);
        if (ns == null) {
            throw new NullPointerException("NS cannot be null");
        }
        this.ns = ns;
    }

    public Tag(String tag, Map<String, String> attr, String ns) {
        this(tag, attr, new HashMap<String, String>(0), ns);
    }

    public Tag(String tag, String ns) {
        this(tag, new HashMap<String, String>(0), new HashMap<String, String>(0), ns);
    }

    public void setParent(Tag parent) {
        this.parent = parent;
    }

    public Tag getParent() {
        return this.parent;
    }

    @Deprecated
    public String getTag() {
        return this.tag;
    }

    public Map<String, String> getCSS() {
        return this.css;
    }

    public void setCSS(Map<String, String> css) {
        if (null != css) {
            this.css = css;
        } else {
            this.css.clear();
        }
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void addChild(Tag t) {
        t.setParent(this);
        this.children.add(t);
    }

    public List<Tag> getChildren() {
        return this.children;
    }

    public List<Tag> getChildren(String name) {
        ArrayList<Tag> named = new ArrayList<Tag>();
        for (Tag child : this.children) {
            if (!child.getName().equals(name)) continue;
            named.add(child);
        }
        return named;
    }

    public String getNameSpace() {
        return this.ns;
    }

    public String toString() {
        if ("".equalsIgnoreCase(this.ns)) {
            return String.format("%s", this.tag);
        }
        return String.format("%s:%s", this.ns, this.tag);
    }

    public boolean compareTag(Tag t) {
        if (this == t) {
            return true;
        }
        if (t == null) {
            return false;
        }
        Tag other = t;
        if (this.ns == null ? other.ns != null : !this.ns.equals(other.ns)) {
            return false;
        }
        return !(this.tag == null ? other.tag != null : !this.tag.equals(other.tag));
    }

    @Override
    public Iterator<Tag> iterator() {
        return this.children.iterator();
    }

    public Tag getChild(String name, String ns) {
        return this.getChild(name, ns, false);
    }

    public Tag getChild(String name, String ns, boolean recursive) {
        return this.recursiveGetChild(this, name, ns, recursive);
    }

    public boolean hasChildren() {
        return this.getChildren().size() != 0;
    }

    public boolean hasParent() {
        return this.getParent() != null;
    }

    public boolean hasChild(String name, String ns) {
        return this.hasChild(name, ns, false);
    }

    public boolean hasChild(String name, String ns, boolean recursive) {
        if (recursive) {
            return this.recursiveHasChild(this, name, ns, true);
        }
        return this.recursiveHasChild(this, name, ns, false);
    }

    private boolean recursiveHasChild(Tag tag, String name, String ns, boolean recursive) {
        for (Tag t : tag) {
            if (t.compareTag(new Tag(name, ns))) {
                return true;
            }
            if (!recursive || !this.recursiveHasChild(t, name, ns, recursive)) continue;
            return true;
        }
        return false;
    }

    private Tag recursiveGetChild(Tag tag, String name, String ns, boolean recursive) {
        for (Tag t : tag) {
            if (t.compareTag(new Tag(name, ns))) {
                return t;
            }
            if (!recursive) continue;
            Tag rT = null;
            rT = this.recursiveGetChild(t, name, ns, recursive);
            if (null == rT) continue;
            return rT;
        }
        return null;
    }

    public String getName() {
        return this.tag;
    }
}

