/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.html.table;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.draw.LineSeparator;
import com.itextpdf.tool.xml.NoCustomContextException;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.css.apply.HtmlCellCssApplier;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;
import com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import com.itextpdf.tool.xml.html.AbstractTagProcessor;
import com.itextpdf.tool.xml.html.HTMLUtils;
import com.itextpdf.tool.xml.html.pdfelement.HtmlCell;
import com.itextpdf.tool.xml.html.pdfelement.NoNewLineParagraph;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableData
extends AbstractTagProcessor {
    @Override
    public List<Element> content(WorkerContext ctx, Tag tag, String content) {
        String sanitized = HTMLUtils.sanitizeInline(content);
        ArrayList<Element> l = new ArrayList<Element>(1);
        if (sanitized.length() > 0) {
            Chunk c = this.getCssAppliers().getChunkCssAplier().apply(new Chunk(sanitized), tag);
            l.add((Element)c);
        }
        return l;
    }

    @Override
    public List<Element> end(WorkerContext ctx, Tag tag, List<Element> currentContent) {
        HtmlCell cell = new HtmlCell();
        try {
            HtmlPipelineContext htmlPipelineContext = this.getHtmlPipelineContext(ctx);
            cell = new HtmlCellCssApplier().apply(cell, tag, htmlPipelineContext, htmlPipelineContext);
        }
        catch (NoCustomContextException e1) {
            throw new RuntimeWorkerException(LocaleMessages.getInstance().getMessage("customcontext.404"), e1);
        }
        cell.getColumn().setUseAscender(true);
        ArrayList<Element> l = new ArrayList<Element>(1);
        ArrayList<Object> chunks = new ArrayList<Object>();
        for (Element e : currentContent) {
            if (e instanceof Chunk || e instanceof NoNewLineParagraph || e instanceof LineSeparator) {
                if (e == Chunk.NEWLINE) {
                    Element nextElement;
                    int index = currentContent.indexOf(e);
                    if (index == currentContent.size() - 1 || (nextElement = currentContent.get(index + 1)) instanceof Paragraph || chunks.isEmpty()) {
                        continue;
                    }
                } else if (e instanceof LineSeparator) {
                    chunks.add(Chunk.NEWLINE);
                }
                chunks.add(e);
                continue;
            }
            if (!chunks.isEmpty()) {
                Paragraph p = new Paragraph();
                p.setMultipliedLeading(1.2f);
                p.addAll(chunks);
                p.setAlignment(cell.getHorizontalAlignment());
                cell.addElement((Element)p);
                chunks.clear();
            }
            if (e instanceof Paragraph) {
                ((Paragraph)e).setAlignment(cell.getHorizontalAlignment());
            }
            cell.addElement(e);
        }
        if (!chunks.isEmpty()) {
            Paragraph p = new Paragraph();
            p.setMultipliedLeading(1.2f);
            p.addAll(chunks);
            p.setAlignment(cell.getHorizontalAlignment());
            cell.addElement((Element)p);
        }
        l.add((Element)cell);
        return l;
    }

    @Override
    public boolean isStackOwner() {
        return true;
    }
}

