/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml;

import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.tool.xml.ElementHandler;
import com.itextpdf.tool.xml.XMLWorker;
import com.itextpdf.tool.xml.css.CSSFileWrapper;
import com.itextpdf.tool.xml.css.CssFile;
import com.itextpdf.tool.xml.css.CssFileProcessor;
import com.itextpdf.tool.xml.css.CssFilesImpl;
import com.itextpdf.tool.xml.css.StyleAttrCSSResolver;
import com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import com.itextpdf.tool.xml.html.TagProcessorFactory;
import com.itextpdf.tool.xml.html.Tags;
import com.itextpdf.tool.xml.parser.XMLParser;
import com.itextpdf.tool.xml.pipeline.css.CSSResolver;
import com.itextpdf.tool.xml.pipeline.css.CssResolverPipeline;
import com.itextpdf.tool.xml.pipeline.end.ElementHandlerPipeline;
import com.itextpdf.tool.xml.pipeline.end.PdfWriterPipeline;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipeline;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;

public class XMLWorkerHelper {
    private static XMLWorkerHelper myself = new XMLWorkerHelper();
    private TagProcessorFactory tpf;
    private CssFile defaultCssFile;

    public static synchronized XMLWorkerHelper getInstance() {
        return myself;
    }

    private XMLWorkerHelper() {
    }

    public synchronized CssFile getCSS(InputStream in) {
        if (null == this.defaultCssFile && null != in) {
            CssFileProcessor cssFileProcessor = new CssFileProcessor();
            int i = -1;
            try {
                while (-1 != (i = in.read())) {
                    cssFileProcessor.process((char)i);
                }
                this.defaultCssFile = new CSSFileWrapper(cssFileProcessor.getCss(), true);
            }
            catch (IOException e) {
                throw new RuntimeWorkerException(e);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new RuntimeWorkerException(e);
                }
            }
        }
        return this.defaultCssFile;
    }

    public synchronized CssFile getDefaultCSS() {
        return this.getCSS(XMLWorkerHelper.class.getResourceAsStream("/default.css"));
    }

    public void parseXHtml(ElementHandler d, Reader in) throws IOException {
        CssFilesImpl cssFiles = new CssFilesImpl();
        cssFiles.add(this.getDefaultCSS());
        StyleAttrCSSResolver cssResolver = new StyleAttrCSSResolver(cssFiles);
        HtmlPipelineContext hpc = new HtmlPipelineContext(null);
        hpc.setAcceptUnknown(true).autoBookmark(true).setTagFactory(this.getDefaultTagProcessorFactory());
        CssResolverPipeline pipeline = new CssResolverPipeline(cssResolver, new HtmlPipeline(hpc, new ElementHandlerPipeline(d, null)));
        XMLWorker worker = new XMLWorker(pipeline, true);
        XMLParser p = new XMLParser();
        p.addListener(worker);
        p.parse(in);
    }

    public void parseXHtml(PdfWriter writer, Document doc, Reader in) throws IOException {
        CssFilesImpl cssFiles = new CssFilesImpl();
        cssFiles.add(this.getDefaultCSS());
        StyleAttrCSSResolver cssResolver = new StyleAttrCSSResolver(cssFiles);
        HtmlPipelineContext hpc = new HtmlPipelineContext(null);
        hpc.setAcceptUnknown(true).autoBookmark(true).setTagFactory(this.getDefaultTagProcessorFactory());
        CssResolverPipeline pipeline = new CssResolverPipeline(cssResolver, new HtmlPipeline(hpc, new PdfWriterPipeline(doc, writer)));
        XMLWorker worker = new XMLWorker(pipeline, true);
        XMLParser p = new XMLParser();
        p.addListener(worker);
        p.parse(in);
    }

    public void parseXHtml(PdfWriter writer, Document doc, InputStream in, Charset charset) throws IOException {
        this.parseXHtml(writer, doc, in, XMLWorkerHelper.class.getResourceAsStream("/default.css"), charset);
    }

    public void parseXHtml(PdfWriter writer, Document doc, InputStream in, InputStream inCssFile, Charset charset) throws IOException {
        CssFilesImpl cssFiles = new CssFilesImpl();
        cssFiles.add(this.getCSS(inCssFile));
        StyleAttrCSSResolver cssResolver = new StyleAttrCSSResolver(cssFiles);
        HtmlPipelineContext hpc = new HtmlPipelineContext(null);
        hpc.setAcceptUnknown(true).autoBookmark(true).setTagFactory(this.getDefaultTagProcessorFactory());
        CssResolverPipeline pipeline = new CssResolverPipeline(cssResolver, new HtmlPipeline(hpc, new PdfWriterPipeline(doc, writer)));
        XMLWorker worker = new XMLWorker(pipeline, true);
        XMLParser p = new XMLParser(true, worker, charset);
        if (charset != null) {
            p.parse(in, charset);
        } else {
            p.parse(in);
        }
    }

    public void parseXHtml(ElementHandler d, InputStream in, Charset charset) throws IOException {
        CssFilesImpl cssFiles = new CssFilesImpl();
        cssFiles.add(this.getDefaultCSS());
        StyleAttrCSSResolver cssResolver = new StyleAttrCSSResolver(cssFiles);
        HtmlPipelineContext hpc = new HtmlPipelineContext(null);
        hpc.setAcceptUnknown(true).autoBookmark(true).setTagFactory(this.getDefaultTagProcessorFactory());
        CssResolverPipeline pipeline = new CssResolverPipeline(cssResolver, new HtmlPipeline(hpc, new ElementHandlerPipeline(d, null)));
        XMLWorker worker = new XMLWorker(pipeline, true);
        XMLParser p = new XMLParser(true, worker, charset);
        if (charset != null) {
            p.parse(in, charset);
        } else {
            p.parse(in);
        }
    }

    public CSSResolver getDefaultCssResolver(boolean addDefaultCss) {
        StyleAttrCSSResolver resolver = new StyleAttrCSSResolver();
        if (addDefaultCss) {
            resolver.addCss(this.getDefaultCSS());
        }
        return resolver;
    }

    protected synchronized TagProcessorFactory getDefaultTagProcessorFactory() {
        if (null == this.tpf) {
            this.tpf = Tags.getHtmlTagProcessorFactory();
        }
        return this.tpf;
    }
}

