/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.html;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;
import com.itextpdf.text.Paragraph;
import com.itextpdf.tool.xml.NoCustomContextException;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;
import com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import com.itextpdf.tool.xml.html.AbstractTagProcessor;
import com.itextpdf.tool.xml.html.HTMLUtils;
import com.itextpdf.tool.xml.html.pdfelement.NoNewLineParagraph;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Div
extends AbstractTagProcessor {
    @Override
    public List<Element> content(WorkerContext ctx, Tag tag, String content) {
        String sanitized = HTMLUtils.sanitizeInline(content);
        ArrayList<Element> l = new ArrayList<Element>(1);
        if (sanitized.length() > 0) {
            Chunk c = this.getCssAppliers().getChunkCssAplier().apply(new Chunk(sanitized), tag);
            try {
                l.add(this.getCssAppliers().apply((Element)new NoNewLineParagraph(c), tag, this.getHtmlPipelineContext(ctx)));
            }
            catch (NoCustomContextException e) {
                throw new RuntimeWorkerException(e);
            }
        }
        return l;
    }

    @Override
    public List<Element> end(WorkerContext ctx, Tag tag, List<Element> currentContent) {
        try {
            Paragraph p = null;
            ArrayList<Element> l = new ArrayList<Element>(1);
            for (Element e : currentContent) {
                if (e instanceof Paragraph) {
                    if (p != null) {
                        l.add(this.getCssAppliers().apply((Element)p, tag, this.getHtmlPipelineContext(ctx)));
                        p = null;
                    }
                    l.add(e);
                    continue;
                }
                if (p == null) {
                    p = new Paragraph();
                }
                p.add(e);
            }
            if (p != null) {
                l.add(this.getCssAppliers().apply((Element)p, tag, this.getHtmlPipelineContext(ctx)));
            }
            return l;
        }
        catch (NoCustomContextException e) {
            throw new RuntimeWorkerException(LocaleMessages.getInstance().getMessage("customcontext.404"), e);
        }
    }

    @Override
    public boolean isStackOwner() {
        return true;
    }
}

