/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.zugferd;

import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.pdf.PdfAConformanceLevel;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.xmp.XMPException;
import com.itextpdf.kernel.xmp.XMPMeta;
import com.itextpdf.kernel.xmp.XMPMetaFactory;
import com.itextpdf.pdfa.checker.PdfA3Checker;
import com.itextpdf.zugferd.ZugferdConformanceException;
import java.util.ArrayList;
import java.util.List;

public class ZugferdChecker
extends PdfA3Checker {
    private static final long serialVersionUID = 4871365089564313135L;
    protected List<PdfDictionary> attachments = new ArrayList<PdfDictionary>();

    public ZugferdChecker(PdfAConformanceLevel conformanceLevel) {
        super(conformanceLevel);
    }

    protected void checkFileSpec(PdfDictionary fileSpec) {
        super.checkFileSpec(fileSpec);
        this.attachments.add(fileSpec);
    }

    protected void checkMetaData(PdfDictionary catalog) {
        super.checkMetaData(catalog);
        try {
            XMPMeta xmpMeta = XMPMetaFactory.parseFromBuffer((byte[])catalog.getAsStream(PdfName.Metadata).getBytes());
            String docFileName = xmpMeta.getPropertyString("urn:ferd:pdfa:CrossIndustryDocument:invoice:1p0#", "DocumentFileName");
            for (PdfDictionary attachment : this.attachments) {
                if ((attachment.getAsString(PdfName.UF) == null || !docFileName.equals(attachment.getAsString(PdfName.UF).toString())) && (attachment.getAsString(PdfName.F) == null || !docFileName.equals(attachment.getAsString(PdfName.F).toString()))) continue;
                PdfName relationship = attachment.getAsName(PdfName.AFRelationship);
                if (PdfName.Alternative.equals((Object)relationship)) break;
                throw new ZugferdConformanceException("AFRelationship value shall be Alternative");
            }
        }
        catch (XMPException e) {
            throw new PdfException((Throwable)e);
        }
    }
}

