/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.zugferd.validation;

import com.itextpdf.zugferd.exceptions.InvalidCodeException;

public abstract class CodeValidation {
    public abstract boolean isValid(String var1);

    public String check(String code) throws InvalidCodeException {
        if (code == null || !this.isValid(code)) {
            throw new InvalidCodeException(code, this.getClass().getName());
        }
        return code;
    }

    public boolean isNumeric(String code, int digits) {
        if (code.length() != digits) {
            return false;
        }
        for (char c : code.toCharArray()) {
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public boolean isUppercase(String code, int chars) {
        if (code.length() != chars) {
            return false;
        }
        for (char c : code.toCharArray()) {
            if (c >= 'A' && c <= 'Z') continue;
            return false;
        }
        return true;
    }

    public boolean isLowercase(String code, int chars) {
        if (code.length() != chars) {
            return false;
        }
        for (char c : code.toCharArray()) {
            if (c >= 'a' && c <= 'z') continue;
            return false;
        }
        return true;
    }
}

