/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.zugferd.validation.comfort;

import com.itextpdf.zugferd.validation.CodeValidation;

public class FreeTextSubjectCode
extends CodeValidation {
    public static final String REGULATORY_INFORMATION = "REG";
    public static final String PRICE_CONDITIONS = "AAK";
    public static final String ADDITIONAL_SALES_CONDITIONS = "AAJ";
    public static final String PAYMENT_INFORMATION = "PMT";
    public static final String PRICE_CALCULATION_FORMULA = "PRF";
    public static final String PRODUCT_INFORMATION = "PRD";
    public static final String CERTIFICATION_STATEMENTS = "AAY";
    public static final int HEADER = 1;
    public static final int LINE = 2;
    protected int level;

    public FreeTextSubjectCode(int level) {
        this.level = level;
    }

    public static boolean isHeaderLevel(String code) {
        return code.equals(REGULATORY_INFORMATION) || code.equals(PRICE_CONDITIONS) || code.equals(ADDITIONAL_SALES_CONDITIONS) || code.equals(PAYMENT_INFORMATION);
    }

    public static boolean isLineLevel(String code) {
        return code.equals(PRICE_CALCULATION_FORMULA) || code.equals(PRODUCT_INFORMATION) || code.equals(CERTIFICATION_STATEMENTS);
    }

    @Override
    public boolean isValid(String code) {
        switch (this.level) {
            case 1: {
                return FreeTextSubjectCode.isHeaderLevel(code);
            }
            case 2: {
                return FreeTextSubjectCode.isLineLevel(code);
            }
        }
        return true;
    }
}

