/*
 * Copyright (c) 2017.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.itfsw.redis.mq;

import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

import java.util.List;

/**
 * ---------------------------------------------------------------------------
 * Subscriber
 * ---------------------------------------------------------------------------
 * @author: hewei
 * @time:2017/11/13 11:03
 * ---------------------------------------------------------------------------
 */
public interface MessageSubscriber<T> extends InitializingBean, DisposableBean {
    /**
     * 订阅的频道（不安全）
     * @return
     */
    List<MessageChannel> getChannels();

    /**
     * 添加监听
     * @param listener
     * @param channel
     */
    void addMessageListener(MessageListener<T> listener, MessageChannel channel);
}
