/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.redis.mq.redis;

import com.itfsw.redis.mq.model.MessageWrapper;
import com.itfsw.redis.mq.redis.serializer.KeySerializer;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.util.Assert;

public class RedisOperations
implements InitializingBean {
    private RedisConnectionFactory connectionFactory;
    private RedisSerializer keySerializer;
    private RedisSerializer valueSerializer;
    private RedisTemplate redisTemplate;

    public RedisOperations(RedisConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        this.redisTemplate = new RedisTemplate();
    }

    public RedisSerializer getKeySerializer() {
        return this.keySerializer;
    }

    public void setKeySerializer(RedisSerializer keySerializer) {
        this.keySerializer = keySerializer;
    }

    public RedisSerializer getValueSerializer() {
        return this.valueSerializer;
    }

    public void setValueSerializer(RedisSerializer valueSerializer) {
        this.valueSerializer = valueSerializer;
    }

    public RedisConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public Long time() {
        return (Long)this.redisTemplate.execute(connection -> connection.time());
    }

    public ListOperations<String, MessageWrapper> opsForList() {
        return this.redisTemplate.opsForList();
    }

    public void convertAndSend(String channel, Object message) {
        this.redisTemplate.convertAndSend(channel, message);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.getConnectionFactory(), (String)"RedisConnectionFactory is required");
        Assert.notNull((Object)this.getRedisTemplate(), (String)"RedisTemplate is required");
        if (this.keySerializer == null) {
            this.keySerializer = new KeySerializer();
        }
        if (this.valueSerializer == null) {
            this.valueSerializer = new GenericJackson2JsonRedisSerializer();
        }
        this.redisTemplate.setConnectionFactory(this.connectionFactory);
        this.redisTemplate.setKeySerializer(this.keySerializer);
        this.redisTemplate.setValueSerializer(this.valueSerializer);
        this.redisTemplate.setHashKeySerializer(this.keySerializer);
        this.redisTemplate.setHashValueSerializer(this.valueSerializer);
        this.redisTemplate.afterPropertiesSet();
    }
}

