/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.redis.mq.redis.serializer;

import java.nio.charset.Charset;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public class KeySerializer
extends StringRedisSerializer {
    private final String prefix;

    public KeySerializer() {
        this.prefix = "mq:";
    }

    public KeySerializer(String prefix) {
        this.prefix = prefix;
    }

    public KeySerializer(String prefix, Charset charset) {
        super(charset);
        this.prefix = prefix;
    }

    public byte[] serialize(String string) throws SerializationException {
        return string == null ? null : new StringBuffer(this.prefix).append(string).toString().getBytes();
    }

    public String deserialize(byte[] bytes) throws SerializationException {
        return bytes == null ? null : new StringBuffer(new String(bytes)).deleteCharAt(this.prefix.length()).toString();
    }
}

