/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.redis.mq.support.channel;

import com.itfsw.redis.mq.MessageChannel;
import com.itfsw.redis.mq.redis.RedisOperations;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class DefaultMessageChannel<T>
implements MessageChannel<T> {
    public static final String KEY_FOR_CHANNEL_POOL = "channel-pools";
    public static final String KEY_FOR_CHANNEL_SUBS = "channel-subs";
    private RedisOperations redisOps;
    private String channelName;
    private ScheduledExecutorService channelPoolKeepScheduled;

    public DefaultMessageChannel(RedisOperations redisOps, String channelName) {
        this.redisOps = redisOps;
        this.channelName = channelName;
    }

    @Override
    public String getChannel() {
        return this.channelName;
    }

    @Override
    public RedisOperations redisOps() {
        return this.redisOps;
    }

    public void destroy() throws Exception {
        if (this.channelPoolKeepScheduled != null && !this.channelPoolKeepScheduled.isShutdown()) {
            this.redisOps.getRedisTemplate().opsForHash().delete((Object)KEY_FOR_CHANNEL_POOL, new Object[]{this.channelName});
            this.channelPoolKeepScheduled.shutdown();
            this.channelPoolKeepScheduled = null;
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.channelPoolKeepScheduled == null) {
            this.channelPoolKeepScheduled = Executors.newSingleThreadScheduledExecutor();
            this.channelPoolKeepScheduled.scheduleAtFixedRate(() -> this.redisOps.getRedisTemplate().opsForHash().put((Object)KEY_FOR_CHANNEL_POOL, (Object)this.channelName, (Object)this.redisOps.time()), 0L, 1L, TimeUnit.MINUTES);
        }
    }
}

