/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.redis.mq.support.producer;

import com.itfsw.redis.mq.MessageProducer;
import com.itfsw.redis.mq.MessageQueue;
import com.itfsw.redis.mq.MessageSender;
import com.itfsw.redis.mq.model.MessageWrapper;
import com.itfsw.redis.mq.redis.RedisOperations;
import com.itfsw.redis.mq.support.sender.AbstractMessageSender;

public class DefaultMessageProducer<T>
implements MessageProducer<T> {
    private MessageQueue<T> queue;

    public DefaultMessageProducer(MessageQueue<T> messageQueue) {
        this.queue = messageQueue;
    }

    @Override
    public String send(T message) {
        return new DefaultMessageSender<T>(this.queue.redisOps()).withMessage(message).send();
    }

    @Override
    public MessageSender<T> create(T message) {
        return new DefaultMessageSender<T>(this.queue.redisOps()).withMessage(message);
    }

    @Override
    public MessageQueue<T> getQueue() {
        return this.queue;
    }

    private class DefaultMessageSender<T>
    extends AbstractMessageSender<T> {
        public DefaultMessageSender(RedisOperations redisOps) {
            super(redisOps);
        }

        @Override
        public void send(MessageWrapper<T> messageWrapper) {
            if (messageWrapper.getHighPriority().booleanValue()) {
                DefaultMessageProducer.this.queue.preAdd(messageWrapper);
            } else {
                DefaultMessageProducer.this.queue.add(messageWrapper);
            }
        }
    }
}

