/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.redis.mq.support.publisher;

import com.itfsw.redis.mq.MessageChannel;
import com.itfsw.redis.mq.MessagePublisher;
import com.itfsw.redis.mq.MessageSender;
import com.itfsw.redis.mq.model.MessageWrapper;
import com.itfsw.redis.mq.redis.RedisOperations;
import com.itfsw.redis.mq.support.sender.AbstractMessageSender;

public class DefaultMessagePublisher<T>
implements MessagePublisher<T> {
    private MessageChannel<T> channel;

    public DefaultMessagePublisher(MessageChannel<T> channel) {
        this.channel = channel;
    }

    @Override
    public String send(T message) {
        return new DefaultMessageSender<T>(this.channel.redisOps()).withMessage(message).send();
    }

    @Override
    public MessageSender<T> create(T message) {
        return new DefaultMessageSender<T>(this.channel.redisOps()).withMessage(message);
    }

    @Override
    public MessageChannel<T> getChannel() {
        return this.channel;
    }

    public void destroy() throws Exception {
    }

    public void afterPropertiesSet() throws Exception {
    }

    private class DefaultMessageSender<T>
    extends AbstractMessageSender<T> {
        public DefaultMessageSender(RedisOperations redisOps) {
            super(redisOps);
        }

        @Override
        public void send(MessageWrapper<T> messageWrapper) {
            DefaultMessagePublisher.this.channel.redisOps().convertAndSend(DefaultMessagePublisher.this.channel.getChannel(), messageWrapper);
        }
    }
}

