/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.redis.mq.support.queue;

import com.itfsw.redis.mq.MessageQueue;
import com.itfsw.redis.mq.model.MessageWrapper;
import com.itfsw.redis.mq.redis.RedisOperations;

public class DefaultMessageQueue<T>
implements MessageQueue<T> {
    private RedisOperations redisOps;
    private String queueName = "default";

    public DefaultMessageQueue(RedisOperations redisOps) {
        this.redisOps = redisOps;
    }

    @Override
    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public RedisOperations redisOps() {
        return this.redisOps;
    }

    @Override
    public <T1> void add(MessageWrapper<T1> message) {
        this.redisOps.opsForList().leftPush((Object)this.queueName, message);
    }

    @Override
    public <T1> void preAdd(MessageWrapper<T1> message) {
        this.redisOps.opsForList().rightPush((Object)this.queueName, message);
    }

    @Override
    public MessageWrapper<T> poll() {
        return (MessageWrapper)this.redisOps.opsForList().rightPop((Object)this.queueName);
    }

    @Override
    public long size() {
        return this.redisOps.opsForList().size((Object)this.queueName);
    }
}

