/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.redis.mq.support.sender;

import com.itfsw.redis.mq.MessageSender;
import com.itfsw.redis.mq.model.MessageWrapper;
import com.itfsw.redis.mq.redis.RedisOperations;
import com.itfsw.redis.mq.support.sender.IdWorker;

public abstract class AbstractMessageSender<T>
implements MessageSender<T> {
    private RedisOperations redisOps;
    private T message;
    private long expires = -1L;
    private boolean highPriority = false;

    public abstract void send(MessageWrapper<T> var1);

    public AbstractMessageSender(RedisOperations redisOps) {
        this.redisOps = redisOps;
    }

    public MessageSender<T> withMessage(T message) {
        this.message = message;
        return this;
    }

    @Override
    public MessageSender<T> withExpires(long timeToLive) {
        this.expires = timeToLive;
        return this;
    }

    @Override
    public MessageSender<T> withHighPriority(boolean highPriority) {
        this.highPriority = highPriority;
        return this;
    }

    @Override
    public String send() {
        MessageWrapper<T> messageWrapper = new MessageWrapper<T>();
        long time = this.redisOps.time();
        String messageId = IdWorker.generateId(time);
        messageWrapper.setMessage(this.message);
        messageWrapper.setMessageId(messageId);
        messageWrapper.setExpires(this.expires < 0L ? -1L : this.expires);
        messageWrapper.setHighPriority(this.highPriority);
        messageWrapper.setCreateTime(time);
        this.send(messageWrapper);
        return messageId;
    }
}

