/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.redis.mq.support.sender;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Random;

public class IdWorker {
    private static long lastTimestamp = -1L;
    private static short sequence = 0;
    private static long mac = 0L;
    private static short fix = 0;

    public static synchronized String generateId(long millis) {
        long timestamp = millis;
        if (timestamp < lastTimestamp) {
            IdWorker.fixed();
        }
        if (lastTimestamp == timestamp) {
            if ((sequence = (short)(sequence + 1)) == Short.MAX_VALUE) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    IdWorker.fixed();
                }
                sequence = 0;
                ++timestamp;
            }
        } else {
            sequence = 0;
        }
        lastTimestamp = timestamp;
        return String.format("%s-%s-%s-%s", Long.toString(lastTimestamp, 36), Long.toString(sequence, 36), Long.toString(mac, 36), Long.toString(fix, 36));
    }

    private static void fixed() {
        short s = fix;
        fix = (short)(s + 1);
        if (s == Short.MAX_VALUE) {
            fix = 0;
        }
    }

    public static synchronized String nextId() {
        return IdWorker.generateId(System.currentTimeMillis());
    }

    static {
        try {
            byte[] macBytes;
            for (byte bt : macBytes = NetworkInterface.getByInetAddress(InetAddress.getLocalHost()).getHardwareAddress()) {
                mac = mac << 8 | (long)bt;
            }
        }
        catch (Throwable e) {
            mac = new Random().nextLong() >>> 16;
        }
        fix = (short)Math.abs(new Random().nextInt(Short.MAX_VALUE));
    }
}

