/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins;

import com.itfsw.mybatis.generator.plugins.utils.BasePlugin;
import com.itfsw.mybatis.generator.plugins.utils.JavaElementGeneratorTools;
import com.itfsw.mybatis.generator.plugins.utils.enhanced.InnerInterface;
import com.itfsw.mybatis.generator.plugins.utils.enhanced.InnerInterfaceWrapperToInnerClass;
import java.util.List;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerClass;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;

public class ExampleEnhancedPlugin
extends BasePlugin {
    public boolean modelExampleClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        List innerClasses = topLevelClass.getInnerClasses();
        for (InnerClass innerClass : innerClasses) {
            if (!"Criteria".equals(innerClass.getType().getShortName())) continue;
            this.addFactoryMethodToCriteria(topLevelClass, innerClass, introspectedTable);
            this.addAndIfMethodToCriteria(topLevelClass, innerClass, introspectedTable);
        }
        List methods = topLevelClass.getMethods();
        for (Method method : methods) {
            if (!"createCriteriaInternal".equals(method.getName())) continue;
            method.getBodyLines().set(0, "Criteria criteria = new Criteria(this);");
            logger.debug("itfsw(Example\u589e\u5f3a\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + "\u4fee\u6539createCriteriaInternal\u65b9\u6cd5\uff0c\u4fee\u6539\u6784\u9020Criteria\u65f6\u4f20\u5165Example\u5bf9\u8c61");
        }
        this.addOrderByMethodToExample(topLevelClass, introspectedTable);
        return true;
    }

    private void addFactoryMethodToCriteria(TopLevelClass topLevelClass, InnerClass innerClass, IntrospectedTable introspectedTable) {
        Field exampleField = JavaElementGeneratorTools.generateField("example", JavaVisibility.PRIVATE, topLevelClass.getType(), null);
        this.commentGenerator.addFieldComment(exampleField, introspectedTable);
        innerClass.addField(exampleField);
        List methods = innerClass.getMethods();
        for (Method method : methods) {
            if (!method.isConstructor()) continue;
            method.addParameter(new Parameter(topLevelClass.getType(), "example"));
            method.addBodyLine("this.example = example;");
            this.commentGenerator.addGeneralMethodComment(method, introspectedTable);
            logger.debug("itfsw(Example\u589e\u5f3a\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + "\u4fee\u6539\u6784\u9020\u65b9\u6cd5\uff0c\u589e\u52a0example\u53c2\u6570");
        }
        Method exampleMethod = JavaElementGeneratorTools.generateMethod("example", JavaVisibility.PUBLIC, topLevelClass.getType(), new Parameter[0]);
        this.commentGenerator.addGeneralMethodComment(exampleMethod, introspectedTable);
        exampleMethod = JavaElementGeneratorTools.generateMethodBody(exampleMethod, "return this.example;");
        innerClass.addMethod(exampleMethod);
        logger.debug("itfsw(Example\u589e\u5f3a\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + "." + innerClass.getType().getShortName() + "\u589e\u52a0\u5de5\u5382\u65b9\u6cd5example");
    }

    private void addAndIfMethodToCriteria(TopLevelClass topLevelClass, InnerClass innerClass, IntrospectedTable introspectedTable) {
        InnerInterface criteriaAddInterface = new InnerInterface("ICriteriaAdd");
        criteriaAddInterface.setVisibility(JavaVisibility.PUBLIC);
        logger.debug("itfsw(Example\u589e\u5f3a\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + "." + innerClass.getType().getShortName() + "\u589e\u52a0\u63a5\u53e3ICriteriaAdd");
        Method addMethod = JavaElementGeneratorTools.generateMethod("add", JavaVisibility.DEFAULT, innerClass.getType(), new Parameter(innerClass.getType(), "add"));
        this.commentGenerator.addGeneralMethodComment(addMethod, introspectedTable);
        criteriaAddInterface.addMethod(addMethod);
        logger.debug("itfsw(Example\u589e\u5f3a\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + "." + innerClass.getType().getShortName() + "." + criteriaAddInterface.getType().getShortName() + "\u589e\u52a0\u65b9\u6cd5add");
        InnerInterfaceWrapperToInnerClass innerClassWrapper = new InnerInterfaceWrapperToInnerClass(criteriaAddInterface);
        this.commentGenerator.addClassComment((InnerClass)innerClassWrapper, introspectedTable);
        innerClass.addInnerClass((InnerClass)innerClassWrapper);
        Method andIfMethod = JavaElementGeneratorTools.generateMethod("andIf", JavaVisibility.PUBLIC, innerClass.getType(), new Parameter(FullyQualifiedJavaType.getBooleanPrimitiveInstance(), "ifAdd"), new Parameter(criteriaAddInterface.getType(), "add"));
        this.commentGenerator.addGeneralMethodComment(andIfMethod, introspectedTable);
        andIfMethod = JavaElementGeneratorTools.generateMethodBody(andIfMethod, "if (ifAdd) {", "add.add(this);", "}", "return this;");
        innerClass.addMethod(andIfMethod);
        logger.debug("itfsw(Example\u589e\u5f3a\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + "." + innerClass.getType().getShortName() + "\u589e\u52a0\u65b9\u6cd5andIf");
    }

    private void addOrderByMethodToExample(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        Method orderByMethod = JavaElementGeneratorTools.generateMethod("orderBy", JavaVisibility.PUBLIC, topLevelClass.getType(), new Parameter(FullyQualifiedJavaType.getStringInstance(), "orderByClause"));
        this.commentGenerator.addGeneralMethodComment(orderByMethod, introspectedTable);
        orderByMethod = JavaElementGeneratorTools.generateMethodBody(orderByMethod, "this.setOrderByClause(orderByClause);", "return this;");
        topLevelClass.addMethod(orderByMethod);
        logger.debug("itfsw(Example\u589e\u5f3a\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + "\u589e\u52a0\u65b9\u6cd5orderBy");
        Method orderByMethod1 = JavaElementGeneratorTools.generateMethod("orderBy", JavaVisibility.PUBLIC, topLevelClass.getType(), new Parameter(FullyQualifiedJavaType.getStringInstance(), "orderByClauses", true));
        this.commentGenerator.addGeneralMethodComment(orderByMethod1, introspectedTable);
        orderByMethod1 = JavaElementGeneratorTools.generateMethodBody(orderByMethod1, "StringBuffer sb = new StringBuffer();", "for (int i = 0; i < orderByClauses.length; i++) {", "sb.append(orderByClauses[i]);", "if (i < orderByClauses.length - 1) {", "sb.append(\" , \");", "}", "}", "this.setOrderByClause(sb.toString());", "return this;");
        topLevelClass.addMethod(orderByMethod1);
        logger.debug("itfsw(Example\u589e\u5f3a\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + "\u589e\u52a0\u65b9\u6cd5orderBy(String ... orderByClauses)");
    }
}

