/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins;

import com.itfsw.mybatis.generator.plugins.utils.BasePlugin;
import java.util.List;
import java.util.Properties;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.JavaModelGeneratorConfiguration;

public class ExampleTargetPlugin
extends BasePlugin {
    public static final String PRO_TARGET_PACKAGE = "targetPackage";
    private static String targetPackage;

    @Override
    public boolean validate(List<String> warnings) {
        Properties properties = this.getProperties();
        targetPackage = properties.getProperty(PRO_TARGET_PACKAGE);
        if (targetPackage == null) {
            warnings.add("\u8bf7\u914d\u7f6ecom.itfsw.mybatis.generator.plugins.ExampleTargetPlugin\u63d2\u4ef6\u7684\u76ee\u6807\u5305\u540d(targetPackage)\uff01");
            return false;
        }
        return super.validate(warnings);
    }

    public void initialized(IntrospectedTable introspectedTable) {
        String exampleType = introspectedTable.getExampleType();
        Context context = this.getContext();
        JavaModelGeneratorConfiguration configuration = context.getJavaModelGeneratorConfiguration();
        String targetPackage = configuration.getTargetPackage();
        String newExampleType = exampleType.replace(targetPackage, ExampleTargetPlugin.targetPackage);
        introspectedTable.setExampleType(newExampleType);
        logger.debug("itfsw(Example \u76ee\u6807\u5305\u4fee\u6539\u63d2\u4ef6):\u4fee\u6539" + introspectedTable.getExampleType() + "\u7684\u5305\u5230" + ExampleTargetPlugin.targetPackage);
    }
}

