/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins;

import com.itfsw.mybatis.generator.plugins.ModelBuilderPlugin;
import com.itfsw.mybatis.generator.plugins.utils.BasePlugin;
import com.itfsw.mybatis.generator.plugins.utils.IncrementsPluginTools;
import com.itfsw.mybatis.generator.plugins.utils.IntrospectedTableTools;
import com.itfsw.mybatis.generator.plugins.utils.PluginTools;
import com.itfsw.mybatis.generator.plugins.utils.XmlElementGeneratorTools;
import java.util.ArrayList;
import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.xml.Element;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;

public class IncrementsPlugin
extends BasePlugin {
    public static final String PRO_INCREMENTS_COLUMNS = "incrementsColumns";
    public static final String FIELD_INC_MAP = "incrementsColumnsInfoMap";
    public static final String METHOD_INC_CHECK = "hasIncsForColumn";
    private IncrementsPluginTools incTools;

    @Override
    public boolean validate(List<String> warnings) {
        if (!PluginTools.checkDependencyPlugin(this.getContext(), ModelBuilderPlugin.class)) {
            warnings.add("itfsw:\u63d2\u4ef6" + ((Object)((Object)this)).getClass().getTypeName() + "\u63d2\u4ef6\u9700\u914d\u5408com.itfsw.mybatis.generator.plugins.ModelBuilderPlugin\u63d2\u4ef6\u4f7f\u7528\uff01");
            return false;
        }
        return super.validate(warnings);
    }

    public void initialized(IntrospectedTable introspectedTable) {
        this.incTools = IncrementsPluginTools.getTools(this.context, introspectedTable, this.warnings);
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return true;
    }

    public boolean modelRecordWithBLOBsClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return true;
    }

    public boolean sqlMapUpdateByExampleSelectiveElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.generatedWithSelective(element, introspectedTable, true);
        return true;
    }

    public boolean sqlMapUpdateByExampleWithBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.generatedWithoutSelective(element, introspectedTable, true);
        return true;
    }

    public boolean sqlMapUpdateByExampleWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.generatedWithoutSelective(element, introspectedTable, true);
        return true;
    }

    public boolean sqlMapUpdateByPrimaryKeySelectiveElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.generatedWithSelective(element, introspectedTable, false);
        return true;
    }

    public boolean sqlMapUpdateByPrimaryKeyWithBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.generatedWithoutSelective(element, introspectedTable, false);
        return true;
    }

    public boolean sqlMapUpdateByPrimaryKeyWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.generatedWithoutSelective(element, introspectedTable, false);
        return true;
    }

    private void generatedWithSelective(XmlElement element, IntrospectedTable introspectedTable, boolean hasPrefix) {
        List<XmlElement> ifs;
        List<XmlElement> sets;
        if (this.incTools.support() && (sets = XmlElementGeneratorTools.findXmlElements(element, "set")).size() > 0 && (ifs = XmlElementGeneratorTools.findXmlElements(sets.get(0), "if")).size() > 0) {
            for (XmlElement xmlElement : ifs) {
                List textEles = xmlElement.getElements();
                TextElement textEle = (TextElement)textEles.get(0);
                String[] strs = textEle.getContent().split("=");
                String columnName = strs[0].trim();
                IntrospectedColumn introspectedColumn = IntrospectedTableTools.safeGetColumn(introspectedTable, columnName);
                if (!this.incTools.supportColumn(introspectedColumn)) continue;
                xmlElement.getElements().clear();
                xmlElement.getElements().addAll(this.incTools.generatedIncrementsElement(introspectedColumn, hasPrefix, true));
            }
        }
    }

    private void generatedWithoutSelective(XmlElement xmlElement, IntrospectedTable introspectedTable, boolean hasPrefix) {
        if (this.incTools.support()) {
            ArrayList<Element> newEles = new ArrayList<Element>();
            for (Element ele : xmlElement.getElements()) {
                String columnName;
                IntrospectedColumn introspectedColumn;
                String text;
                if (ele instanceof TextElement && (text = ((TextElement)ele).getContent().trim()).matches("(^set\\s)?\\S+\\s?=.*") && this.incTools.supportColumn(introspectedColumn = IntrospectedTableTools.safeGetColumn(introspectedTable, columnName = (text = text.replaceFirst("^set\\s", "").trim()).split("=")[0].trim()))) {
                    newEles.addAll(this.incTools.generatedIncrementsElement(introspectedColumn, hasPrefix, text.endsWith(",")));
                    continue;
                }
                newEles.add(ele);
            }
            xmlElement.getElements().clear();
            xmlElement.getElements().addAll(newEles);
        }
    }
}

