/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins;

import com.itfsw.mybatis.generator.plugins.utils.BasePlugin;
import com.itfsw.mybatis.generator.plugins.utils.FormatTools;
import com.itfsw.mybatis.generator.plugins.utils.IncrementsPluginTools;
import com.itfsw.mybatis.generator.plugins.utils.JavaElementGeneratorTools;
import com.itfsw.mybatis.generator.plugins.utils.enhanced.InnerTypeFullyQualifiedJavaType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerClass;
import org.mybatis.generator.api.dom.java.InnerEnum;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.internal.util.JavaBeansUtil;

public class ModelBuilderPlugin
extends BasePlugin {
    public static final String BUILDER_CLASS_NAME = "Builder";
    private Map<IntrospectedTable, InnerTypeFullyQualifiedJavaType> innerClasses = new HashMap<IntrospectedTable, InnerTypeFullyQualifiedJavaType>();

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        List columns = introspectedTable.getRules().generateRecordWithBLOBsClass() ? introspectedTable.getNonBLOBColumns() : introspectedTable.getAllColumns();
        InnerClass innerClass = this.generateModelBuilder(topLevelClass, introspectedTable, columns);
        topLevelClass.addInnerClass(innerClass);
        return super.modelBaseRecordClassGenerated(topLevelClass, introspectedTable);
    }

    public boolean modelRecordWithBLOBsClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        InnerClass innerClass = this.generateModelBuilder(topLevelClass, introspectedTable, introspectedTable.getAllColumns());
        topLevelClass.addInnerClass(innerClass);
        return super.modelRecordWithBLOBsClassGenerated(topLevelClass, introspectedTable);
    }

    public boolean modelPrimaryKeyClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        InnerClass innerClass = this.generateModelBuilder(topLevelClass, introspectedTable, introspectedTable.getPrimaryKeyColumns());
        topLevelClass.addInnerClass(innerClass);
        return super.modelPrimaryKeyClassGenerated(topLevelClass, introspectedTable);
    }

    private InnerClass generateModelBuilder(TopLevelClass topLevelClass, IntrospectedTable introspectedTable, List<IntrospectedColumn> columns) {
        InnerClass innerClass = new InnerClass(BUILDER_CLASS_NAME);
        innerClass.setVisibility(JavaVisibility.PUBLIC);
        innerClass.setStatic(true);
        InnerTypeFullyQualifiedJavaType builderType = new InnerTypeFullyQualifiedJavaType(topLevelClass.getType().getFullyQualifiedName() + "." + BUILDER_CLASS_NAME);
        if (this.innerClasses.get(introspectedTable) != null) {
            innerClass.setSuperClass((FullyQualifiedJavaType)this.innerClasses.get(introspectedTable));
            this.innerClasses.remove(introspectedTable);
        }
        this.innerClasses.put(introspectedTable, builderType);
        Method builder = JavaElementGeneratorTools.generateMethod("builder", JavaVisibility.PUBLIC, builderType, new Parameter[0]);
        this.commentGenerator.addGeneralMethodComment(builder, introspectedTable);
        builder.setStatic(true);
        builder.addBodyLine("return new " + builderType.getShortName() + "();");
        topLevelClass.addMethod(builder);
        this.commentGenerator.addClassComment(innerClass, introspectedTable);
        logger.debug("itfsw(\u6570\u636eModel\u94fe\u5f0f\u6784\u5efa\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + "\u589e\u52a0\u5185\u90e8Builder\u7c7b\u3002");
        Field f = JavaElementGeneratorTools.generateField("obj", JavaVisibility.PRIVATE, topLevelClass.getType(), null);
        this.commentGenerator.addFieldComment(f, introspectedTable);
        innerClass.addField(f);
        Method constructor = new Method(BUILDER_CLASS_NAME);
        constructor.setVisibility(JavaVisibility.PUBLIC);
        constructor.setConstructor(true);
        constructor.addBodyLine("this.obj = new " + topLevelClass.getType().getShortName() + "();");
        this.commentGenerator.addGeneralMethodComment(constructor, introspectedTable);
        innerClass.addMethod(constructor);
        logger.debug("itfsw(\u6570\u636eModel\u94fe\u5f0f\u6784\u5efa\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + ".Builder\u589e\u52a0\u7684\u6784\u9020\u65b9\u6cd5\u3002");
        for (IntrospectedColumn introspectedColumn : columns) {
            Field field = JavaBeansUtil.getJavaBeansField((IntrospectedColumn)introspectedColumn, (Context)this.context, (IntrospectedTable)introspectedTable);
            Method setterMethod = JavaBeansUtil.getJavaBeansSetter((IntrospectedColumn)introspectedColumn, (Context)this.context, (IntrospectedTable)introspectedTable);
            Method method = JavaElementGeneratorTools.generateMethod(field.getName(), JavaVisibility.PUBLIC, innerClass.getType(), new Parameter(field.getType(), field.getName()));
            this.commentGenerator.addSetterComment(method, introspectedTable, introspectedColumn);
            method = JavaElementGeneratorTools.generateMethodBody(method, "obj." + setterMethod.getName() + "(" + field.getName() + ");", "return this;");
            innerClass.addMethod(method);
            logger.debug("itfsw(\u6570\u636eModel\u94fe\u5f0f\u6784\u5efa\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + ".Builder\u589e\u52a0" + method.getName() + "\u65b9\u6cd5(\u590d\u5408\u4e3b\u952e)\u3002");
        }
        Method build = JavaElementGeneratorTools.generateMethod("build", JavaVisibility.PUBLIC, topLevelClass.getType(), new Parameter[0]);
        build.addBodyLine("return this.obj;");
        this.commentGenerator.addGeneralMethodComment(build, introspectedTable);
        innerClass.addMethod(build);
        logger.debug("itfsw(\u6570\u636eModel\u94fe\u5f0f\u6784\u5efa\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + ".Builder\u589e\u52a0build\u65b9\u6cd5\u3002");
        IncrementsPluginTools incTools = IncrementsPluginTools.getTools(this.context, introspectedTable, this.warnings);
        if (incTools.support()) {
            InnerEnum eIncrements = new InnerEnum(new FullyQualifiedJavaType("Inc"));
            eIncrements.setVisibility(JavaVisibility.PUBLIC);
            eIncrements.setStatic(true);
            eIncrements.addEnumConstant("INC(\"+\")");
            eIncrements.addEnumConstant("DEC(\"-\")");
            this.commentGenerator.addEnumComment(eIncrements, introspectedTable);
            Field fValue = new Field("value", FullyQualifiedJavaType.getStringInstance());
            fValue.setVisibility(JavaVisibility.PRIVATE);
            fValue.setFinal(true);
            this.commentGenerator.addFieldComment(fValue, introspectedTable);
            eIncrements.addField(fValue);
            Method mInc = new Method("Inc");
            mInc.setConstructor(true);
            mInc.addBodyLine("this.value = value;");
            mInc.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "value"));
            this.commentGenerator.addGeneralMethodComment(mInc, introspectedTable);
            eIncrements.addMethod(mInc);
            Method mValue = JavaElementGeneratorTools.generateGetterMethod(fValue);
            this.commentGenerator.addGeneralMethodComment(mValue, introspectedTable);
            eIncrements.addMethod(mValue);
            innerClass.addInnerEnum(eIncrements);
            Field fIncrements = JavaElementGeneratorTools.generateField("incrementsColumnsInfoMap", JavaVisibility.PROTECTED, new FullyQualifiedJavaType("Map<String, " + incTools.getIncEnum().getFullyQualifiedName() + ">"), "new HashMap<String, " + incTools.getIncEnum().getFullyQualifiedName() + ">()");
            this.commentGenerator.addFieldComment(fIncrements, introspectedTable);
            topLevelClass.addField(fIncrements);
            topLevelClass.addImportedType("java.util.Map");
            topLevelClass.addImportedType("java.util.HashMap");
            Method mGetter = JavaElementGeneratorTools.generateGetterMethod(fIncrements);
            this.commentGenerator.addGetterComment(mGetter, introspectedTable, null);
            topLevelClass.addMethod(mGetter);
            Method mSetter = JavaElementGeneratorTools.generateSetterMethod(fIncrements);
            this.commentGenerator.addSetterComment(mSetter, introspectedTable, null);
            topLevelClass.addMethod(mSetter);
            Method mHasIncsForColumn = JavaElementGeneratorTools.generateMethod("hasIncsForColumn", JavaVisibility.PUBLIC, FullyQualifiedJavaType.getBooleanPrimitiveInstance(), new Parameter(FullyQualifiedJavaType.getStringInstance(), "column"));
            this.commentGenerator.addGeneralMethodComment(mHasIncsForColumn, introspectedTable);
            mHasIncsForColumn.addBodyLine("return incrementsColumnsInfoMap.get(column) != null;");
            FormatTools.addMethodWithBestPosition(topLevelClass, mHasIncsForColumn);
            for (IntrospectedColumn column : columns) {
                if (!incTools.supportColumn(column)) continue;
                Field field = JavaBeansUtil.getJavaBeansField((IntrospectedColumn)column, (Context)this.context, (IntrospectedTable)introspectedTable);
                Method mIncrements = JavaElementGeneratorTools.generateMethod(field.getName(), JavaVisibility.PUBLIC, innerClass.getType(), new Parameter(field.getType(), field.getName()), new Parameter(incTools.getIncEnum(), "inc"));
                this.commentGenerator.addSetterComment(mIncrements, introspectedTable, column);
                Method setterMethod = JavaBeansUtil.getJavaBeansSetter((IntrospectedColumn)column, (Context)this.context, (IntrospectedTable)introspectedTable);
                mIncrements.addBodyLine("obj.incrementsColumnsInfoMap.put(\"" + column.getActualColumnName() + "\", inc);");
                mIncrements.addBodyLine("obj." + setterMethod.getName() + "(" + field.getName() + ");");
                mIncrements.addBodyLine("return this;");
                FormatTools.addMethodWithBestPosition(innerClass, mIncrements);
            }
        }
        return innerClass;
    }
}

