/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins;

import com.itfsw.mybatis.generator.plugins.ModelColumnPlugin;
import com.itfsw.mybatis.generator.plugins.UpsertPlugin;
import com.itfsw.mybatis.generator.plugins.utils.BasePlugin;
import com.itfsw.mybatis.generator.plugins.utils.IntrospectedTableTools;
import com.itfsw.mybatis.generator.plugins.utils.PluginTools;
import com.itfsw.mybatis.generator.plugins.utils.XmlElementGeneratorTools;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.Element;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.codegen.mybatis3.MyBatis3FormattingUtilities;

public class SelectiveEnhancedPlugin
extends BasePlugin {
    public static final String METHOD_HAS_SELECTIVE = "hasSelective";

    @Override
    public boolean validate(List<String> warnings) {
        if (!PluginTools.checkDependencyPlugin(this.getContext(), ModelColumnPlugin.class)) {
            warnings.add("itfsw:\u63d2\u4ef6" + ((Object)((Object)this)).getClass().getTypeName() + "\u63d2\u4ef6\u9700\u914d\u5408com.itfsw.mybatis.generator.plugins.ModelColumnPlugin\u63d2\u4ef6\u4f7f\u7528\uff01");
            return false;
        }
        PluginTools.shouldAfterPlugins(this.getContext(), ((Object)((Object)this)).getClass(), warnings, UpsertPlugin.class);
        return super.validate(warnings);
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        topLevelClass.addImportedType(FullyQualifiedJavaType.getNewMapInstance());
        topLevelClass.addImportedType(FullyQualifiedJavaType.getNewHashMapInstance());
        Field selectiveColumnsField = new Field("selectiveColumns", new FullyQualifiedJavaType("Map<String, Boolean>"));
        this.commentGenerator.addFieldComment(selectiveColumnsField, introspectedTable);
        selectiveColumnsField.setVisibility(JavaVisibility.PRIVATE);
        selectiveColumnsField.setInitializationString("new HashMap<String, Boolean>()");
        topLevelClass.addField(selectiveColumnsField);
        Method mHasSelective = new Method(METHOD_HAS_SELECTIVE);
        this.commentGenerator.addGeneralMethodComment(mHasSelective, introspectedTable);
        mHasSelective.setVisibility(JavaVisibility.PUBLIC);
        mHasSelective.setReturnType(FullyQualifiedJavaType.getBooleanPrimitiveInstance());
        mHasSelective.addBodyLine("return this.selectiveColumns.size() > 0;");
        topLevelClass.addMethod(mHasSelective);
        Method mHasSelective1 = new Method(METHOD_HAS_SELECTIVE);
        this.commentGenerator.addGeneralMethodComment(mHasSelective1, introspectedTable);
        mHasSelective1.setVisibility(JavaVisibility.PUBLIC);
        mHasSelective1.setReturnType(FullyQualifiedJavaType.getBooleanPrimitiveInstance());
        mHasSelective1.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "column"));
        mHasSelective1.addBodyLine("return this.selectiveColumns.get(column) != null;");
        topLevelClass.addMethod(mHasSelective1);
        Method mSelective = new Method("selective");
        this.commentGenerator.addGeneralMethodComment(mSelective, introspectedTable);
        mSelective.setVisibility(JavaVisibility.PUBLIC);
        mSelective.setReturnType(topLevelClass.getType());
        mSelective.addParameter(new Parameter(new FullyQualifiedJavaType("Column"), "columns", true));
        mSelective.addBodyLine("this.selectiveColumns.clear();");
        mSelective.addBodyLine("if (columns != null) {");
        mSelective.addBodyLine("for (Column column : columns) {");
        mSelective.addBodyLine("this.selectiveColumns.put(column.value(), true);");
        mSelective.addBodyLine("}");
        mSelective.addBodyLine("}");
        mSelective.addBodyLine("return this;");
        topLevelClass.addMethod(mSelective);
        return true;
    }

    public boolean sqlMapDocumentGenerated(Document document, IntrospectedTable introspectedTable) {
        List rootElements = document.getRootElement().getElements();
        for (Element rootElement : rootElements) {
            XmlElement ele;
            List<XmlElement> eles;
            Object attribute2;
            if (!(rootElement instanceof XmlElement)) continue;
            XmlElement xmlElement = (XmlElement)rootElement;
            List attributes = xmlElement.getAttributes();
            String id = "";
            for (Object attribute2 : attributes) {
                if (!attribute2.getName().equals("id")) continue;
                id = attribute2.getValue();
            }
            if ("insertSelective".equals(id)) {
                eles = XmlElementGeneratorTools.findXmlElements(xmlElement, "trim");
                attribute2 = eles.iterator();
                while (attribute2.hasNext()) {
                    ele = (XmlElement)attribute2.next();
                    this.replaceEle(ele, "_parameter.", introspectedTable);
                }
            }
            if ("updateByExampleSelective".equals(id)) {
                eles = XmlElementGeneratorTools.findXmlElements(xmlElement, "set");
                attribute2 = eles.iterator();
                while (attribute2.hasNext()) {
                    ele = (XmlElement)attribute2.next();
                    this.replaceEle(ele, "record.", introspectedTable);
                }
            }
            if ("updateByPrimaryKeySelective".equals(id)) {
                eles = XmlElementGeneratorTools.findXmlElements(xmlElement, "set");
                attribute2 = eles.iterator();
                while (attribute2.hasNext()) {
                    ele = (XmlElement)attribute2.next();
                    this.replaceEle(ele, "_parameter.", introspectedTable);
                }
            }
            if ("upsertSelective".equals(id)) {
                eles = XmlElementGeneratorTools.findXmlElements(xmlElement, "trim");
                attribute2 = eles.iterator();
                while (attribute2.hasNext()) {
                    ele = (XmlElement)attribute2.next();
                    this.replaceEle(ele, "_parameter.", introspectedTable);
                }
            }
            if (!"upsertByExampleSelective".equals(id)) continue;
            eles = XmlElementGeneratorTools.findXmlElements(xmlElement, "trim");
            this.replaceEle(eles.get(0), "record.", introspectedTable);
            this.replaceEleForUpsertByExampleSelective(eles.get(1), "record.", introspectedTable, !introspectedTable.getRules().generateRecordWithBLOBsClass());
            List<XmlElement> eles1 = XmlElementGeneratorTools.findXmlElements(xmlElement, "set");
            for (XmlElement ele2 : eles1) {
                this.replaceEle(ele2, "record.", introspectedTable);
            }
        }
        return true;
    }

    private void replaceEle(XmlElement element, String prefix, IntrospectedTable introspectedTable) {
        XmlElement chooseEle = new XmlElement("choose");
        XmlElement whenEle = new XmlElement("when");
        whenEle.addAttribute(new Attribute("test", prefix + METHOD_HAS_SELECTIVE + "()"));
        for (Element ele : element.getElements()) {
            if (ele instanceof XmlElement) {
                XmlElement xmlElement = (XmlElement)ele;
                String text = ((TextElement)xmlElement.getElements().get(0)).getContent();
                String columnName = "";
                if (text.matches("#\\{.*\\},?")) {
                    Pattern pattern = Pattern.compile("#\\{(.*?),.*\\},?");
                    Matcher matcher = pattern.matcher(text);
                    if (matcher.find()) {
                        String field = matcher.group(1);
                        for (IntrospectedColumn column : introspectedTable.getAllColumns()) {
                            if (!column.getJavaProperty().equals(field)) continue;
                            columnName = column.getActualColumnName();
                        }
                    }
                } else {
                    columnName = text.matches(".*=.*") ? text.split("=")[0] : text.replaceAll(",", "");
                }
                IntrospectedColumn column = IntrospectedTableTools.safeGetColumn(introspectedTable, columnName);
                XmlElement ifEle = new XmlElement("if");
                ifEle.addAttribute(new Attribute("test", prefix + METHOD_HAS_SELECTIVE + "('" + column.getActualColumnName() + "')"));
                for (Element ifChild : xmlElement.getElements()) {
                    ifEle.addElement(ifChild);
                }
                whenEle.addElement((Element)ifEle);
                continue;
            }
            whenEle.addElement(ele);
        }
        XmlElement otherwiseEle = new XmlElement("otherwise");
        for (Element ele : element.getElements()) {
            otherwiseEle.addElement(ele);
        }
        chooseEle.addElement((Element)whenEle);
        chooseEle.addElement((Element)otherwiseEle);
        element.getElements().clear();
        element.addElement((Element)chooseEle);
    }

    private void replaceEleForUpsertByExampleSelective(XmlElement element, String prefix, IntrospectedTable introspectedTable, boolean allColumns) {
        XmlElement chooseEle = new XmlElement("choose");
        XmlElement whenEle = new XmlElement("when");
        whenEle.addAttribute(new Attribute("test", prefix + METHOD_HAS_SELECTIVE + "()"));
        for (IntrospectedColumn introspectedColumn : allColumns ? introspectedTable.getAllColumns() : introspectedTable.getNonBLOBColumns()) {
            XmlElement eleIf = new XmlElement("if");
            eleIf.addAttribute(new Attribute("test", prefix + METHOD_HAS_SELECTIVE + "('" + introspectedColumn.getActualColumnName() + "')"));
            eleIf.addElement((Element)new TextElement(MyBatis3FormattingUtilities.getParameterClause((IntrospectedColumn)introspectedColumn, (String)prefix) + ","));
            whenEle.addElement((Element)eleIf);
        }
        XmlElement otherwiseEle = new XmlElement("otherwise");
        for (Element ele : element.getElements()) {
            otherwiseEle.addElement(ele);
        }
        chooseEle.addElement((Element)whenEle);
        chooseEle.addElement((Element)otherwiseEle);
        element.getElements().clear();
        element.addElement((Element)chooseEle);
    }
}

