/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins;

import com.itfsw.mybatis.generator.plugins.utils.BasePlugin;
import com.itfsw.mybatis.generator.plugins.utils.IntrospectedTableTools;
import java.util.List;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.config.TableConfiguration;

public class TablePrefixPlugin
extends BasePlugin {
    public static final String PRO_PREFIX = "prefix";
    private String prefix;

    @Override
    public boolean validate(List<String> warnings) {
        for (TableConfiguration tableConfiguration : this.context.getTableConfigurations()) {
            if (tableConfiguration.getDomainObjectName() == null && tableConfiguration.getMapperName() == null) continue;
            warnings.add("itfsw:\u63d2\u4ef6" + ((Object)((Object)this)).getClass().getTypeName() + "\u63d2\u4ef6\u8bf7\u4e0d\u8981\u914d\u5408table\u7684domainObjectName\u6216\u8005mapperName\u4e00\u8d77\u4f7f\u7528\uff01");
            return false;
        }
        return super.validate(warnings);
    }

    public void initialized(IntrospectedTable introspectedTable) {
        this.prefix = this.getProperties().getProperty(PRO_PREFIX);
        if (introspectedTable.getTableConfigurationProperty(PRO_PREFIX) != null) {
            this.prefix = introspectedTable.getTableConfigurationProperty(PRO_PREFIX);
        }
        if (this.prefix != null && introspectedTable.getTableConfigurationProperty("tableOverride") == null) {
            String domainObjectName = introspectedTable.getFullyQualifiedTable().getDomainObjectName();
            domainObjectName = this.prefix + domainObjectName;
            try {
                IntrospectedTableTools.setDomainObjectName(introspectedTable, this.getContext(), domainObjectName);
            }
            catch (Exception e) {
                logger.error("itfsw:\u63d2\u4ef6" + ((Object)((Object)this)).getClass().getTypeName() + "\u4f7f\u7528prefix\u66ff\u6362\u65f6\u5f02\u5e38\uff01", (Throwable)e);
            }
        }
    }
}

